/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSummary;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse;

public class ListAlgorithmsPublisher
implements SdkPublisher<ListAlgorithmsResponse> {
    private final SageMakerAsyncClient client;
    private final ListAlgorithmsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAlgorithmsPublisher(SageMakerAsyncClient client, ListAlgorithmsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAlgorithmsPublisher(SageMakerAsyncClient client, ListAlgorithmsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAlgorithmsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAlgorithmsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AlgorithmSummary> algorithmSummaryList() {
        Function<ListAlgorithmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.algorithmSummaryList() != null) {
                return response.algorithmSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAlgorithmsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAlgorithmsResponseFetcher
    implements AsyncPageFetcher<ListAlgorithmsResponse> {
        private ListAlgorithmsResponseFetcher() {
        }

        public boolean hasNextPage(ListAlgorithmsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAlgorithmsResponse> nextPage(ListAlgorithmsResponse previousPage) {
            if (previousPage == null) {
                return ListAlgorithmsPublisher.this.client.listAlgorithms(ListAlgorithmsPublisher.this.firstRequest);
            }
            return ListAlgorithmsPublisher.this.client.listAlgorithms((ListAlgorithmsRequest)((Object)ListAlgorithmsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

