/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ProblemType {
    BINARY_CLASSIFICATION("BinaryClassification"),
    MULTICLASS_CLASSIFICATION("MulticlassClassification"),
    REGRESSION("Regression"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ProblemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProblemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ProblemType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProblemType> knownValues() {
        return Stream.of(ProblemType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

