/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single private workforce, which is automatically created when you create your first private work team. You can
 * create one private work force in each AWS Region. By default, any workforce-related API operation used in a specific
 * region will apply to the workforce created in that region. To learn how to create a private workforce, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private
 * Workforce</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workforce implements SdkPojo, Serializable, ToCopyableBuilder<Workforce.Builder, Workforce> {
    private static final SdkField<String> WORKFORCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workforce::workforceName)).setter(setter(Builder::workforceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceName").build()).build();

    private static final SdkField<String> WORKFORCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workforce::workforceArn)).setter(setter(Builder::workforceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceArn").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Workforce::lastUpdatedDate)).setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()).build();

    private static final SdkField<SourceIpConfig> SOURCE_IP_CONFIG_FIELD = SdkField
            .<SourceIpConfig> builder(MarshallingType.SDK_POJO).getter(getter(Workforce::sourceIpConfig))
            .setter(setter(Builder::sourceIpConfig)).constructor(SourceIpConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFORCE_NAME_FIELD,
            WORKFORCE_ARN_FIELD, LAST_UPDATED_DATE_FIELD, SOURCE_IP_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workforceName;

    private final String workforceArn;

    private final Instant lastUpdatedDate;

    private final SourceIpConfig sourceIpConfig;

    private Workforce(BuilderImpl builder) {
        this.workforceName = builder.workforceName;
        this.workforceArn = builder.workforceArn;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.sourceIpConfig = builder.sourceIpConfig;
    }

    /**
     * <p>
     * The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is automatically
     * set to <code>default</code> when a workforce is created and cannot be modified.
     * </p>
     * 
     * @return The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is
     *         automatically set to <code>default</code> when a workforce is created and cannot be modified.
     */
    public String workforceName() {
        return workforceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the private workforce.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the private workforce.
     */
    public String workforceArn() {
        return workforceArn;
    }

    /**
     * <p>
     * The most recent date that was used to successfully add one or more IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private workforce's
     * allow list.
     * </p>
     * 
     * @return The most recent date that was used to successfully add one or more IP address ranges (<a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private
     *         workforce's allow list.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * A list of one to four IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the workforce
     * allow list.
     * </p>
     * 
     * @return A list of one to four IP address ranges (<a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the
     *         workforce allow list.
     */
    public SourceIpConfig sourceIpConfig() {
        return sourceIpConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workforceName());
        hashCode = 31 * hashCode + Objects.hashCode(workforceArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workforce)) {
            return false;
        }
        Workforce other = (Workforce) obj;
        return Objects.equals(workforceName(), other.workforceName()) && Objects.equals(workforceArn(), other.workforceArn())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(sourceIpConfig(), other.sourceIpConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Workforce").add("WorkforceName", workforceName()).add("WorkforceArn", workforceArn())
                .add("LastUpdatedDate", lastUpdatedDate()).add("SourceIpConfig", sourceIpConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkforceName":
            return Optional.ofNullable(clazz.cast(workforceName()));
        case "WorkforceArn":
            return Optional.ofNullable(clazz.cast(workforceArn()));
        case "LastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "SourceIpConfig":
            return Optional.ofNullable(clazz.cast(sourceIpConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workforce, T> g) {
        return obj -> g.apply((Workforce) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workforce> {
        /**
         * <p>
         * The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is
         * automatically set to <code>default</code> when a workforce is created and cannot be modified.
         * </p>
         * 
         * @param workforceName
         *        The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is
         *        automatically set to <code>default</code> when a workforce is created and cannot be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforceName(String workforceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the private workforce.
         * </p>
         * 
         * @param workforceArn
         *        The Amazon Resource Name (ARN) of the private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforceArn(String workforceArn);

        /**
         * <p>
         * The most recent date that was used to successfully add one or more IP address ranges (<a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private workforce's
         * allow list.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The most recent date that was used to successfully add one or more IP address ranges (<a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private
         *        workforce's allow list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * A list of one to four IP address ranges (<a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the
         * workforce allow list.
         * </p>
         * 
         * @param sourceIpConfig
         *        A list of one to four IP address ranges (<a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the
         *        workforce allow list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpConfig(SourceIpConfig sourceIpConfig);

        /**
         * <p>
         * A list of one to four IP address ranges (<a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the
         * workforce allow list.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceIpConfig.Builder} avoiding the need to
         * create one manually via {@link SourceIpConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceIpConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceIpConfig(SourceIpConfig)}.
         * 
         * @param sourceIpConfig
         *        a consumer that will call methods on {@link SourceIpConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceIpConfig(SourceIpConfig)
         */
        default Builder sourceIpConfig(Consumer<SourceIpConfig.Builder> sourceIpConfig) {
            return sourceIpConfig(SourceIpConfig.builder().applyMutation(sourceIpConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String workforceName;

        private String workforceArn;

        private Instant lastUpdatedDate;

        private SourceIpConfig sourceIpConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Workforce model) {
            workforceName(model.workforceName);
            workforceArn(model.workforceArn);
            lastUpdatedDate(model.lastUpdatedDate);
            sourceIpConfig(model.sourceIpConfig);
        }

        public final String getWorkforceName() {
            return workforceName;
        }

        @Override
        public final Builder workforceName(String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        public final void setWorkforceName(String workforceName) {
            this.workforceName = workforceName;
        }

        public final String getWorkforceArn() {
            return workforceArn;
        }

        @Override
        public final Builder workforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
            return this;
        }

        public final void setWorkforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final SourceIpConfig.Builder getSourceIpConfig() {
            return sourceIpConfig != null ? sourceIpConfig.toBuilder() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final void setSourceIpConfig(SourceIpConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        @Override
        public Workforce build() {
            return new Workforce(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
