/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResponse extends SageMakerResponse implements ToCopyableBuilder<SearchResponse.Builder, SearchResponse> {
    private static final SdkField<List<SearchRecord>> RESULTS_FIELD = SdkField
            .<List<SearchRecord>> builder(MarshallingType.LIST)
            .getter(getter(SearchResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SearchRecord> results;

    private final String nextToken;

    private SearchResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Results property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SearchRecord</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>SearchRecord</code> objects.
     */
    public List<SearchRecord> results() {
        return results;
    }

    /**
     * <p>
     * If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken. To
     * retrieve the next set of results, use the token in the next request.
     * </p>
     * 
     * @return If the result of the previous <code>Search</code> request was truncated, the response includes a
     *         NextToken. To retrieve the next set of results, use the token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(results());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResponse)) {
            return false;
        }
        SearchResponse other = (SearchResponse) obj;
        return Objects.equals(results(), other.results()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchResponse").add("Results", results()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResponse, T> g) {
        return obj -> g.apply((SearchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchResponse> {
        /**
         * <p>
         * A list of <code>SearchRecord</code> objects.
         * </p>
         * 
         * @param results
         *        A list of <code>SearchRecord</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<SearchRecord> results);

        /**
         * <p>
         * A list of <code>SearchRecord</code> objects.
         * </p>
         * 
         * @param results
         *        A list of <code>SearchRecord</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(SearchRecord... results);

        /**
         * <p>
         * A list of <code>SearchRecord</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SearchRecord>.Builder} avoiding the need to
         * create one manually via {@link List<SearchRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SearchRecord>.Builder#build()} is called immediately and its
         * result is passed to {@link #results(List<SearchRecord>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<SearchRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<SearchRecord>)
         */
        Builder results(Consumer<SearchRecord.Builder>... results);

        /**
         * <p>
         * If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken.
         * To retrieve the next set of results, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>Search</code> request was truncated, the response includes a
         *        NextToken. To retrieve the next set of results, use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<SearchRecord> results = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResponse model) {
            super(model);
            results(model.results);
            nextToken(model.nextToken);
        }

        public final Collection<SearchRecord.Builder> getResults() {
            return results != null ? results.stream().map(SearchRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<SearchRecord> results) {
            this.results = SearchResultsListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(SearchRecord... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<SearchRecord.Builder>... results) {
            results(Stream.of(results).map(c -> SearchRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<SearchRecord.BuilderImpl> results) {
            this.results = SearchResultsListCopier.copyFromBuilder(results);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchResponse build() {
            return new SearchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
