/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrialsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListTrialsResponse.Builder, ListTrialsResponse> {
    private static final SdkField<List<TrialSummary>> TRIAL_SUMMARIES_FIELD = SdkField
            .<List<TrialSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListTrialsResponse::trialSummaries))
            .setter(setter(Builder::trialSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrialSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrialsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TrialSummary> trialSummaries;

    private final String nextToken;

    private ListTrialsResponse(BuilderImpl builder) {
        super(builder);
        this.trialSummaries = builder.trialSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TrialSummaries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTrialSummaries() {
        return trialSummaries != null && !(trialSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the summaries of your trials.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrialSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the summaries of your trials.
     */
    public List<TrialSummary> trialSummaries() {
        return trialSummaries;
    }

    /**
     * <p>
     * A token for getting the next set of trials, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of trials, if there are any.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trialSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrialsResponse)) {
            return false;
        }
        ListTrialsResponse other = (ListTrialsResponse) obj;
        return Objects.equals(trialSummaries(), other.trialSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTrialsResponse").add("TrialSummaries", trialSummaries()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialSummaries":
            return Optional.ofNullable(clazz.cast(trialSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrialsResponse, T> g) {
        return obj -> g.apply((ListTrialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTrialsResponse> {
        /**
         * <p>
         * A list of the summaries of your trials.
         * </p>
         * 
         * @param trialSummaries
         *        A list of the summaries of your trials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialSummaries(Collection<TrialSummary> trialSummaries);

        /**
         * <p>
         * A list of the summaries of your trials.
         * </p>
         * 
         * @param trialSummaries
         *        A list of the summaries of your trials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialSummaries(TrialSummary... trialSummaries);

        /**
         * <p>
         * A list of the summaries of your trials.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrialSummary>.Builder} avoiding the need to
         * create one manually via {@link List<TrialSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrialSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #trialSummaries(List<TrialSummary>)}.
         * 
         * @param trialSummaries
         *        a consumer that will call methods on {@link List<TrialSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialSummaries(List<TrialSummary>)
         */
        Builder trialSummaries(Consumer<TrialSummary.Builder>... trialSummaries);

        /**
         * <p>
         * A token for getting the next set of trials, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of trials, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<TrialSummary> trialSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrialsResponse model) {
            super(model);
            trialSummaries(model.trialSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<TrialSummary.Builder> getTrialSummaries() {
            return trialSummaries != null ? trialSummaries.stream().map(TrialSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder trialSummaries(Collection<TrialSummary> trialSummaries) {
            this.trialSummaries = TrialSummariesCopier.copy(trialSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialSummaries(TrialSummary... trialSummaries) {
            trialSummaries(Arrays.asList(trialSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialSummaries(Consumer<TrialSummary.Builder>... trialSummaries) {
            trialSummaries(Stream.of(trialSummaries).map(c -> TrialSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTrialSummaries(Collection<TrialSummary.BuilderImpl> trialSummaries) {
            this.trialSummaries = TrialSummariesCopier.copyFromBuilder(trialSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTrialsResponse build() {
            return new ListTrialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
