/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSubscribedWorkteamsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListSubscribedWorkteamsResponse.Builder, ListSubscribedWorkteamsResponse> {
    private static final SdkField<List<SubscribedWorkteam>> SUBSCRIBED_WORKTEAMS_FIELD = SdkField
            .<List<SubscribedWorkteam>> builder(MarshallingType.LIST)
            .getter(getter(ListSubscribedWorkteamsResponse::subscribedWorkteams))
            .setter(setter(Builder::subscribedWorkteams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedWorkteams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscribedWorkteam> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscribedWorkteam::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSubscribedWorkteamsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIBED_WORKTEAMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SubscribedWorkteam> subscribedWorkteams;

    private final String nextToken;

    private ListSubscribedWorkteamsResponse(BuilderImpl builder) {
        super(builder);
        this.subscribedWorkteams = builder.subscribedWorkteams;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SubscribedWorkteams property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSubscribedWorkteams() {
        return subscribedWorkteams != null && !(subscribedWorkteams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Workteam</code> objects, each describing a work team.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubscribedWorkteams()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Workteam</code> objects, each describing a work team.
     */
    public List<SubscribedWorkteam> subscribedWorkteams() {
        return subscribedWorkteams;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it
     * in the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work
     *         teams, use it in the subsequent request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscribedWorkteams());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscribedWorkteamsResponse)) {
            return false;
        }
        ListSubscribedWorkteamsResponse other = (ListSubscribedWorkteamsResponse) obj;
        return Objects.equals(subscribedWorkteams(), other.subscribedWorkteams())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSubscribedWorkteamsResponse").add("SubscribedWorkteams", subscribedWorkteams())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscribedWorkteams":
            return Optional.ofNullable(clazz.cast(subscribedWorkteams()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSubscribedWorkteamsResponse, T> g) {
        return obj -> g.apply((ListSubscribedWorkteamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSubscribedWorkteamsResponse> {
        /**
         * <p>
         * An array of <code>Workteam</code> objects, each describing a work team.
         * </p>
         * 
         * @param subscribedWorkteams
         *        An array of <code>Workteam</code> objects, each describing a work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedWorkteams(Collection<SubscribedWorkteam> subscribedWorkteams);

        /**
         * <p>
         * An array of <code>Workteam</code> objects, each describing a work team.
         * </p>
         * 
         * @param subscribedWorkteams
         *        An array of <code>Workteam</code> objects, each describing a work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedWorkteams(SubscribedWorkteam... subscribedWorkteams);

        /**
         * <p>
         * An array of <code>Workteam</code> objects, each describing a work team.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubscribedWorkteam>.Builder} avoiding the
         * need to create one manually via {@link List<SubscribedWorkteam>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubscribedWorkteam>.Builder#build()} is called immediately
         * and its result is passed to {@link #subscribedWorkteams(List<SubscribedWorkteam>)}.
         * 
         * @param subscribedWorkteams
         *        a consumer that will call methods on {@link List<SubscribedWorkteam>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribedWorkteams(List<SubscribedWorkteam>)
         */
        Builder subscribedWorkteams(Consumer<SubscribedWorkteam.Builder>... subscribedWorkteams);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams,
         * use it in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work
         *        teams, use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<SubscribedWorkteam> subscribedWorkteams = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscribedWorkteamsResponse model) {
            super(model);
            subscribedWorkteams(model.subscribedWorkteams);
            nextToken(model.nextToken);
        }

        public final Collection<SubscribedWorkteam.Builder> getSubscribedWorkteams() {
            return subscribedWorkteams != null ? subscribedWorkteams.stream().map(SubscribedWorkteam::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscribedWorkteams(Collection<SubscribedWorkteam> subscribedWorkteams) {
            this.subscribedWorkteams = SubscribedWorkteamsCopier.copy(subscribedWorkteams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedWorkteams(SubscribedWorkteam... subscribedWorkteams) {
            subscribedWorkteams(Arrays.asList(subscribedWorkteams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedWorkteams(Consumer<SubscribedWorkteam.Builder>... subscribedWorkteams) {
            subscribedWorkteams(Stream.of(subscribedWorkteams).map(c -> SubscribedWorkteam.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubscribedWorkteams(Collection<SubscribedWorkteam.BuilderImpl> subscribedWorkteams) {
            this.subscribedWorkteams = SubscribedWorkteamsCopier.copyFromBuilder(subscribedWorkteams);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSubscribedWorkteamsResponse build() {
            return new ListSubscribedWorkteamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
