/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the location of input model artifacts, the name and shape of the expected data inputs, and
 * the framework in which the model was trained.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputConfig implements SdkPojo, Serializable, ToCopyableBuilder<InputConfig.Builder, InputConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> DATA_INPUT_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputConfig::dataInputConfig)).setter(setter(Builder::dataInputConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfig").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputConfig::frameworkAsString)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            DATA_INPUT_CONFIG_FIELD, FRAMEWORK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String dataInputConfig;

    private final String framework;

    private InputConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.dataInputConfig = builder.dataInputConfig;
        this.framework = builder.framework;
    }

    /**
     * <p>
     * The S3 path where the model artifacts, which result from model training, are stored. This path must point to a
     * single gzip compressed tar archive (.tar.gz suffix).
     * </p>
     * 
     * @return The S3 path where the model artifacts, which result from model training, are stored. This path must point
     *         to a single gzip compressed tar archive (.tar.gz suffix).
     */
    public String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary form. The
     * data inputs are <a>InputConfig$Framework</a> specific.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TensorFlow</code>: You must specify the name and shape (NHWC format) of the expected data inputs using a
     * dictionary format for your trained model. The dictionary formats required for the console and CLI are different.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Examples for one input:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using the console, <code>{"input":[1,1024,1024,3]}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If using the CLI, <code>{\"input\":[1,1024,1024,3]}</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Examples for two inputs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using the console, <code>{"data1": [1,28,28,1], "data2":[1,28,28,1]}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If using the CLI, <code>{\"data1\": [1,28,28,1], \"data2\":[1,28,28,1]}</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>KERAS</code>: You must specify the name and shape (NCHW format) of expected data inputs using a dictionary
     * format for your trained model. Note that while Keras model artifacts should be uploaded in NHWC (channel-last)
     * format, <code>DataInputConfig</code> should be specified in NCHW (channel-first) format. The dictionary formats
     * required for the console and CLI are different.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Examples for one input:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using the console, <code>{"input_1":[1,3,224,224]}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If using the CLI, <code>{\"input_1\":[1,3,224,224]}</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Examples for two inputs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using the console, <code>{"input_1": [1,3,224,224], "input_2":[1,3,224,224]} </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If using the CLI, <code>{\"input_1\": [1,3,224,224], \"input_2\":[1,3,224,224]}</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>MXNET/ONNX</code>: You must specify the name and shape (NCHW format) of the expected data inputs in order
     * using a dictionary format for your trained model. The dictionary formats required for the console and CLI are
     * different.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Examples for one input:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using the console, <code>{"data":[1,3,1024,1024]}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If using the CLI, <code>{\"data\":[1,3,1024,1024]}</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Examples for two inputs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using the console, <code>{"var1": [1,1,28,28], "var2":[1,1,28,28]} </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If using the CLI, <code>{\"var1\": [1,1,28,28], \"var2\":[1,1,28,28]}</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>PyTorch</code>: You can either specify the name and shape (NCHW format) of expected data inputs in order
     * using a dictionary format for your trained model or you can specify the shape only using a list format. The
     * dictionary formats required for the console and CLI are different. The list formats for the console and CLI are
     * the same.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Examples for one input in dictionary format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using the console, <code>{"input0":[1,3,224,224]}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If using the CLI, <code>{\"input0\":[1,3,224,224]}</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Example for one input in list format: <code>[[1,3,224,224]]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Examples for two inputs in dictionary format:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If using the console, <code>{"input0":[1,3,224,224], "input1":[1,3,224,224]}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If using the CLI, <code>{\"input0\":[1,3,224,224], \"input1\":[1,3,224,224]} </code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Example for two inputs in list format: <code>[[1,3,224,224], [1,3,224,224]]</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>XGBOOST</code>: input data name and shape are not needed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary
     *         form. The data inputs are <a>InputConfig$Framework</a> specific. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TensorFlow</code>: You must specify the name and shape (NHWC format) of the expected data inputs
     *         using a dictionary format for your trained model. The dictionary formats required for the console and CLI
     *         are different.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Examples for one input:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using the console, <code>{"input":[1,1024,1024,3]}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If using the CLI, <code>{\"input\":[1,1024,1024,3]}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Examples for two inputs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using the console, <code>{"data1": [1,28,28,1], "data2":[1,28,28,1]}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If using the CLI, <code>{\"data1\": [1,28,28,1], \"data2\":[1,28,28,1]}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KERAS</code>: You must specify the name and shape (NCHW format) of expected data inputs using a
     *         dictionary format for your trained model. Note that while Keras model artifacts should be uploaded in
     *         NHWC (channel-last) format, <code>DataInputConfig</code> should be specified in NCHW (channel-first)
     *         format. The dictionary formats required for the console and CLI are different.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Examples for one input:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using the console, <code>{"input_1":[1,3,224,224]}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If using the CLI, <code>{\"input_1\":[1,3,224,224]}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Examples for two inputs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using the console, <code>{"input_1": [1,3,224,224], "input_2":[1,3,224,224]} </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If using the CLI, <code>{\"input_1\": [1,3,224,224], \"input_2\":[1,3,224,224]}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MXNET/ONNX</code>: You must specify the name and shape (NCHW format) of the expected data inputs in
     *         order using a dictionary format for your trained model. The dictionary formats required for the console
     *         and CLI are different.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Examples for one input:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using the console, <code>{"data":[1,3,1024,1024]}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If using the CLI, <code>{\"data\":[1,3,1024,1024]}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Examples for two inputs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using the console, <code>{"var1": [1,1,28,28], "var2":[1,1,28,28]} </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If using the CLI, <code>{\"var1\": [1,1,28,28], \"var2\":[1,1,28,28]}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PyTorch</code>: You can either specify the name and shape (NCHW format) of expected data inputs in
     *         order using a dictionary format for your trained model or you can specify the shape only using a list
     *         format. The dictionary formats required for the console and CLI are different. The list formats for the
     *         console and CLI are the same.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Examples for one input in dictionary format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using the console, <code>{"input0":[1,3,224,224]}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If using the CLI, <code>{\"input0\":[1,3,224,224]}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Example for one input in list format: <code>[[1,3,224,224]]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Examples for two inputs in dictionary format:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If using the console, <code>{"input0":[1,3,224,224], "input1":[1,3,224,224]}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If using the CLI, <code>{\"input0\":[1,3,224,224], \"input1\":[1,3,224,224]} </code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Example for two inputs in list format: <code>[[1,3,224,224], [1,3,224,224]]</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>XGBOOST</code>: input data name and shape are not needed.
     *         </p>
     *         </li>
     */
    public String dataInputConfig() {
        return dataInputConfig;
    }

    /**
     * <p>
     * Identifies the framework in which the model was trained. For example: TENSORFLOW.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return Identifies the framework in which the model was trained. For example: TENSORFLOW.
     * @see Framework
     */
    public Framework framework() {
        return Framework.fromValue(framework);
    }

    /**
     * <p>
     * Identifies the framework in which the model was trained. For example: TENSORFLOW.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return Identifies the framework in which the model was trained. For example: TENSORFLOW.
     * @see Framework
     */
    public String frameworkAsString() {
        return framework;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(dataInputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfig)) {
            return false;
        }
        InputConfig other = (InputConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(dataInputConfig(), other.dataInputConfig())
                && Objects.equals(frameworkAsString(), other.frameworkAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InputConfig").add("S3Uri", s3Uri()).add("DataInputConfig", dataInputConfig())
                .add("Framework", frameworkAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "DataInputConfig":
            return Optional.ofNullable(clazz.cast(dataInputConfig()));
        case "Framework":
            return Optional.ofNullable(clazz.cast(frameworkAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputConfig, T> g) {
        return obj -> g.apply((InputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputConfig> {
        /**
         * <p>
         * The S3 path where the model artifacts, which result from model training, are stored. This path must point to
         * a single gzip compressed tar archive (.tar.gz suffix).
         * </p>
         * 
         * @param s3Uri
         *        The S3 path where the model artifacts, which result from model training, are stored. This path must
         *        point to a single gzip compressed tar archive (.tar.gz suffix).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary form.
         * The data inputs are <a>InputConfig$Framework</a> specific.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TensorFlow</code>: You must specify the name and shape (NHWC format) of the expected data inputs using
         * a dictionary format for your trained model. The dictionary formats required for the console and CLI are
         * different.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Examples for one input:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using the console, <code>{"input":[1,1024,1024,3]}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If using the CLI, <code>{\"input\":[1,1024,1024,3]}</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Examples for two inputs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using the console, <code>{"data1": [1,28,28,1], "data2":[1,28,28,1]}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If using the CLI, <code>{\"data1\": [1,28,28,1], \"data2\":[1,28,28,1]}</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>KERAS</code>: You must specify the name and shape (NCHW format) of expected data inputs using a
         * dictionary format for your trained model. Note that while Keras model artifacts should be uploaded in NHWC
         * (channel-last) format, <code>DataInputConfig</code> should be specified in NCHW (channel-first) format. The
         * dictionary formats required for the console and CLI are different.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Examples for one input:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using the console, <code>{"input_1":[1,3,224,224]}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If using the CLI, <code>{\"input_1\":[1,3,224,224]}</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Examples for two inputs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using the console, <code>{"input_1": [1,3,224,224], "input_2":[1,3,224,224]} </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If using the CLI, <code>{\"input_1\": [1,3,224,224], \"input_2\":[1,3,224,224]}</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>MXNET/ONNX</code>: You must specify the name and shape (NCHW format) of the expected data inputs in
         * order using a dictionary format for your trained model. The dictionary formats required for the console and
         * CLI are different.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Examples for one input:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using the console, <code>{"data":[1,3,1024,1024]}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If using the CLI, <code>{\"data\":[1,3,1024,1024]}</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Examples for two inputs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using the console, <code>{"var1": [1,1,28,28], "var2":[1,1,28,28]} </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If using the CLI, <code>{\"var1\": [1,1,28,28], \"var2\":[1,1,28,28]}</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>PyTorch</code>: You can either specify the name and shape (NCHW format) of expected data inputs in
         * order using a dictionary format for your trained model or you can specify the shape only using a list format.
         * The dictionary formats required for the console and CLI are different. The list formats for the console and
         * CLI are the same.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Examples for one input in dictionary format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using the console, <code>{"input0":[1,3,224,224]}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If using the CLI, <code>{\"input0\":[1,3,224,224]}</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Example for one input in list format: <code>[[1,3,224,224]]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Examples for two inputs in dictionary format:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If using the console, <code>{"input0":[1,3,224,224], "input1":[1,3,224,224]}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If using the CLI, <code>{\"input0\":[1,3,224,224], \"input1\":[1,3,224,224]} </code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Example for two inputs in list format: <code>[[1,3,224,224], [1,3,224,224]]</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>XGBOOST</code>: input data name and shape are not needed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataInputConfig
         *        Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary
         *        form. The data inputs are <a>InputConfig$Framework</a> specific. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TensorFlow</code>: You must specify the name and shape (NHWC format) of the expected data inputs
         *        using a dictionary format for your trained model. The dictionary formats required for the console and
         *        CLI are different.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Examples for one input:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using the console, <code>{"input":[1,1024,1024,3]}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If using the CLI, <code>{\"input\":[1,1024,1024,3]}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Examples for two inputs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using the console, <code>{"data1": [1,28,28,1], "data2":[1,28,28,1]}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If using the CLI, <code>{\"data1\": [1,28,28,1], \"data2\":[1,28,28,1]}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KERAS</code>: You must specify the name and shape (NCHW format) of expected data inputs using a
         *        dictionary format for your trained model. Note that while Keras model artifacts should be uploaded in
         *        NHWC (channel-last) format, <code>DataInputConfig</code> should be specified in NCHW (channel-first)
         *        format. The dictionary formats required for the console and CLI are different.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Examples for one input:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using the console, <code>{"input_1":[1,3,224,224]}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If using the CLI, <code>{\"input_1\":[1,3,224,224]}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Examples for two inputs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using the console, <code>{"input_1": [1,3,224,224], "input_2":[1,3,224,224]} </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If using the CLI, <code>{\"input_1\": [1,3,224,224], \"input_2\":[1,3,224,224]}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MXNET/ONNX</code>: You must specify the name and shape (NCHW format) of the expected data inputs
         *        in order using a dictionary format for your trained model. The dictionary formats required for the
         *        console and CLI are different.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Examples for one input:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using the console, <code>{"data":[1,3,1024,1024]}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If using the CLI, <code>{\"data\":[1,3,1024,1024]}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Examples for two inputs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using the console, <code>{"var1": [1,1,28,28], "var2":[1,1,28,28]} </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If using the CLI, <code>{\"var1\": [1,1,28,28], \"var2\":[1,1,28,28]}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PyTorch</code>: You can either specify the name and shape (NCHW format) of expected data inputs
         *        in order using a dictionary format for your trained model or you can specify the shape only using a
         *        list format. The dictionary formats required for the console and CLI are different. The list formats
         *        for the console and CLI are the same.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Examples for one input in dictionary format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using the console, <code>{"input0":[1,3,224,224]}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If using the CLI, <code>{\"input0\":[1,3,224,224]}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Example for one input in list format: <code>[[1,3,224,224]]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Examples for two inputs in dictionary format:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If using the console, <code>{"input0":[1,3,224,224], "input1":[1,3,224,224]}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If using the CLI, <code>{\"input0\":[1,3,224,224], \"input1\":[1,3,224,224]} </code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Example for two inputs in list format: <code>[[1,3,224,224], [1,3,224,224]]</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>XGBOOST</code>: input data name and shape are not needed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataInputConfig(String dataInputConfig);

        /**
         * <p>
         * Identifies the framework in which the model was trained. For example: TENSORFLOW.
         * </p>
         * 
         * @param framework
         *        Identifies the framework in which the model was trained. For example: TENSORFLOW.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(String framework);

        /**
         * <p>
         * Identifies the framework in which the model was trained. For example: TENSORFLOW.
         * </p>
         * 
         * @param framework
         *        Identifies the framework in which the model was trained. For example: TENSORFLOW.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(Framework framework);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String dataInputConfig;

        private String framework;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfig model) {
            s3Uri(model.s3Uri);
            dataInputConfig(model.dataInputConfig);
            framework(model.framework);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getDataInputConfig() {
            return dataInputConfig;
        }

        @Override
        public final Builder dataInputConfig(String dataInputConfig) {
            this.dataInputConfig = dataInputConfig;
            return this;
        }

        public final void setDataInputConfig(String dataInputConfig) {
            this.dataInputConfig = dataInputConfig;
        }

        public final String getFramework() {
            return framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        public final Builder framework(Framework framework) {
            this.framework(framework == null ? null : framework.toString());
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public InputConfig build() {
            return new InputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
