/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for human task user interface information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanTaskUiSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanTaskUiSummary.Builder, HumanTaskUiSummary> {
    private static final SdkField<String> HUMAN_TASK_UI_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanTaskUiSummary::humanTaskUiName)).setter(setter(Builder::humanTaskUiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiName").build()).build();

    private static final SdkField<String> HUMAN_TASK_UI_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanTaskUiSummary::humanTaskUiArn)).setter(setter(Builder::humanTaskUiArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(HumanTaskUiSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_TASK_UI_NAME_FIELD,
            HUMAN_TASK_UI_ARN_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String humanTaskUiName;

    private final String humanTaskUiArn;

    private final Instant creationTime;

    private HumanTaskUiSummary(BuilderImpl builder) {
        this.humanTaskUiName = builder.humanTaskUiName;
        this.humanTaskUiArn = builder.humanTaskUiArn;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the human task user interface.
     * </p>
     * 
     * @return The name of the human task user interface.
     */
    public String humanTaskUiName() {
        return humanTaskUiName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the human task user interface.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the human task user interface.
     */
    public String humanTaskUiArn() {
        return humanTaskUiArn;
    }

    /**
     * <p>
     * A timestamp when SageMaker created the human task user interface.
     * </p>
     * 
     * @return A timestamp when SageMaker created the human task user interface.
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiName());
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanTaskUiSummary)) {
            return false;
        }
        HumanTaskUiSummary other = (HumanTaskUiSummary) obj;
        return Objects.equals(humanTaskUiName(), other.humanTaskUiName())
                && Objects.equals(humanTaskUiArn(), other.humanTaskUiArn())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HumanTaskUiSummary").add("HumanTaskUiName", humanTaskUiName())
                .add("HumanTaskUiArn", humanTaskUiArn()).add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanTaskUiName":
            return Optional.ofNullable(clazz.cast(humanTaskUiName()));
        case "HumanTaskUiArn":
            return Optional.ofNullable(clazz.cast(humanTaskUiArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanTaskUiSummary, T> g) {
        return obj -> g.apply((HumanTaskUiSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanTaskUiSummary> {
        /**
         * <p>
         * The name of the human task user interface.
         * </p>
         * 
         * @param humanTaskUiName
         *        The name of the human task user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiName(String humanTaskUiName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the human task user interface.
         * </p>
         * 
         * @param humanTaskUiArn
         *        The Amazon Resource Name (ARN) of the human task user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiArn(String humanTaskUiArn);

        /**
         * <p>
         * A timestamp when SageMaker created the human task user interface.
         * </p>
         * 
         * @param creationTime
         *        A timestamp when SageMaker created the human task user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String humanTaskUiName;

        private String humanTaskUiArn;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanTaskUiSummary model) {
            humanTaskUiName(model.humanTaskUiName);
            humanTaskUiArn(model.humanTaskUiArn);
            creationTime(model.creationTime);
        }

        public final String getHumanTaskUiName() {
            return humanTaskUiName;
        }

        @Override
        public final Builder humanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
            return this;
        }

        public final void setHumanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
        }

        public final String getHumanTaskUiArn() {
            return humanTaskUiArn;
        }

        @Override
        public final Builder humanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
            return this;
        }

        public final void setHumanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public HumanTaskUiSummary build() {
            return new HumanTaskUiSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
