/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The candidate result from a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FinalAutoMLJobObjectiveMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<FinalAutoMLJobObjectiveMetric.Builder, FinalAutoMLJobObjectiveMetric> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FinalAutoMLJobObjectiveMetric::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FinalAutoMLJobObjectiveMetric::metricNameAsString)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<Float> VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(FinalAutoMLJobObjectiveMetric::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, METRIC_NAME_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String metricName;

    private final Float value;

    private FinalAutoMLJobObjectiveMetric(BuilderImpl builder) {
        this.type = builder.type;
        this.metricName = builder.metricName;
        this.value = builder.value;
    }

    /**
     * <p>
     * The metric type used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AutoMLJobObjectiveType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The metric type used.
     * @see AutoMLJobObjectiveType
     */
    public AutoMLJobObjectiveType type() {
        return AutoMLJobObjectiveType.fromValue(type);
    }

    /**
     * <p>
     * The metric type used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AutoMLJobObjectiveType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The metric type used.
     * @see AutoMLJobObjectiveType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link AutoMLMetricEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric.
     * @see AutoMLMetricEnum
     */
    public AutoMLMetricEnum metricName() {
        return AutoMLMetricEnum.fromValue(metricName);
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link AutoMLMetricEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric.
     * @see AutoMLMetricEnum
     */
    public String metricNameAsString() {
        return metricName;
    }

    /**
     * <p>
     * The value of the metric.
     * </p>
     * 
     * @return The value of the metric.
     */
    public Float value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FinalAutoMLJobObjectiveMetric)) {
            return false;
        }
        FinalAutoMLJobObjectiveMetric other = (FinalAutoMLJobObjectiveMetric) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(metricNameAsString(), other.metricNameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FinalAutoMLJobObjectiveMetric").add("Type", typeAsString())
                .add("MetricName", metricNameAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FinalAutoMLJobObjectiveMetric, T> g) {
        return obj -> g.apply((FinalAutoMLJobObjectiveMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FinalAutoMLJobObjectiveMetric> {
        /**
         * <p>
         * The metric type used.
         * </p>
         * 
         * @param type
         *        The metric type used.
         * @see AutoMLJobObjectiveType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobObjectiveType
         */
        Builder type(String type);

        /**
         * <p>
         * The metric type used.
         * </p>
         * 
         * @param type
         *        The metric type used.
         * @see AutoMLJobObjectiveType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobObjectiveType
         */
        Builder type(AutoMLJobObjectiveType type);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @see AutoMLMetricEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLMetricEnum
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @see AutoMLMetricEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLMetricEnum
         */
        Builder metricName(AutoMLMetricEnum metricName);

        /**
         * <p>
         * The value of the metric.
         * </p>
         * 
         * @param value
         *        The value of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Float value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String metricName;

        private Float value;

        private BuilderImpl() {
        }

        private BuilderImpl(FinalAutoMLJobObjectiveMetric model) {
            type(model.type);
            metricName(model.metricName);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AutoMLJobObjectiveType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(AutoMLMetricEnum metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Float getValue() {
            return value;
        }

        @Override
        public final Builder value(Float value) {
            this.value = value;
            return this;
        }

        public final void setValue(Float value) {
            this.value = value;
        }

        @Override
        public FinalAutoMLJobObjectiveMetric build() {
            return new FinalAutoMLJobObjectiveMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
