/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a model compilation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompilationJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CompilationJobSummary.Builder, CompilationJobSummary> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CompilationJobSummary::compilationJobName)).setter(setter(Builder::compilationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build())
            .build();

    private static final SdkField<String> COMPILATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CompilationJobSummary::compilationJobArn)).setter(setter(Builder::compilationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CompilationJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPILATION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CompilationJobSummary::compilationStartTime)).setter(setter(Builder::compilationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationStartTime").build())
            .build();

    private static final SdkField<Instant> COMPILATION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CompilationJobSummary::compilationEndTime)).setter(setter(Builder::compilationEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationEndTime").build())
            .build();

    private static final SdkField<String> COMPILATION_TARGET_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CompilationJobSummary::compilationTargetDeviceAsString))
            .setter(setter(Builder::compilationTargetDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationTargetDevice").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CompilationJobSummary::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> COMPILATION_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CompilationJobSummary::compilationJobStatusAsString)).setter(setter(Builder::compilationJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD,
            COMPILATION_JOB_ARN_FIELD, CREATION_TIME_FIELD, COMPILATION_START_TIME_FIELD, COMPILATION_END_TIME_FIELD,
            COMPILATION_TARGET_DEVICE_FIELD, LAST_MODIFIED_TIME_FIELD, COMPILATION_JOB_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String compilationJobName;

    private final String compilationJobArn;

    private final Instant creationTime;

    private final Instant compilationStartTime;

    private final Instant compilationEndTime;

    private final String compilationTargetDevice;

    private final Instant lastModifiedTime;

    private final String compilationJobStatus;

    private CompilationJobSummary(BuilderImpl builder) {
        this.compilationJobName = builder.compilationJobName;
        this.compilationJobArn = builder.compilationJobArn;
        this.creationTime = builder.creationTime;
        this.compilationStartTime = builder.compilationStartTime;
        this.compilationEndTime = builder.compilationEndTime;
        this.compilationTargetDevice = builder.compilationTargetDevice;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.compilationJobStatus = builder.compilationJobStatus;
    }

    /**
     * <p>
     * The name of the model compilation job that you want a summary for.
     * </p>
     * 
     * @return The name of the model compilation job that you want a summary for.
     */
    public String compilationJobName() {
        return compilationJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model compilation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model compilation job.
     */
    public String compilationJobArn() {
        return compilationJobArn;
    }

    /**
     * <p>
     * The time when the model compilation job was created.
     * </p>
     * 
     * @return The time when the model compilation job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the model compilation job started.
     * </p>
     * 
     * @return The time when the model compilation job started.
     */
    public Instant compilationStartTime() {
        return compilationStartTime;
    }

    /**
     * <p>
     * The time when the model compilation job completed.
     * </p>
     * 
     * @return The time when the model compilation job completed.
     */
    public Instant compilationEndTime() {
        return compilationEndTime;
    }

    /**
     * <p>
     * The type of device that the model will run on after compilation has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetDevice} will return {@link TargetDevice#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #compilationTargetDeviceAsString}.
     * </p>
     * 
     * @return The type of device that the model will run on after compilation has completed.
     * @see TargetDevice
     */
    public TargetDevice compilationTargetDevice() {
        return TargetDevice.fromValue(compilationTargetDevice);
    }

    /**
     * <p>
     * The type of device that the model will run on after compilation has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetDevice} will return {@link TargetDevice#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #compilationTargetDeviceAsString}.
     * </p>
     * 
     * @return The type of device that the model will run on after compilation has completed.
     * @see TargetDevice
     */
    public String compilationTargetDeviceAsString() {
        return compilationTargetDevice;
    }

    /**
     * <p>
     * The time when the model compilation job was last modified.
     * </p>
     * 
     * @return The time when the model compilation job was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the model compilation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationJobStatus} will return {@link CompilationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #compilationJobStatusAsString}.
     * </p>
     * 
     * @return The status of the model compilation job.
     * @see CompilationJobStatus
     */
    public CompilationJobStatus compilationJobStatus() {
        return CompilationJobStatus.fromValue(compilationJobStatus);
    }

    /**
     * <p>
     * The status of the model compilation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationJobStatus} will return {@link CompilationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #compilationJobStatusAsString}.
     * </p>
     * 
     * @return The status of the model compilation job.
     * @see CompilationJobStatus
     */
    public String compilationJobStatusAsString() {
        return compilationJobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(compilationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(compilationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(compilationTargetDeviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompilationJobSummary)) {
            return false;
        }
        CompilationJobSummary other = (CompilationJobSummary) obj;
        return Objects.equals(compilationJobName(), other.compilationJobName())
                && Objects.equals(compilationJobArn(), other.compilationJobArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(compilationStartTime(), other.compilationStartTime())
                && Objects.equals(compilationEndTime(), other.compilationEndTime())
                && Objects.equals(compilationTargetDeviceAsString(), other.compilationTargetDeviceAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(compilationJobStatusAsString(), other.compilationJobStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CompilationJobSummary").add("CompilationJobName", compilationJobName())
                .add("CompilationJobArn", compilationJobArn()).add("CreationTime", creationTime())
                .add("CompilationStartTime", compilationStartTime()).add("CompilationEndTime", compilationEndTime())
                .add("CompilationTargetDevice", compilationTargetDeviceAsString()).add("LastModifiedTime", lastModifiedTime())
                .add("CompilationJobStatus", compilationJobStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompilationJobName":
            return Optional.ofNullable(clazz.cast(compilationJobName()));
        case "CompilationJobArn":
            return Optional.ofNullable(clazz.cast(compilationJobArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompilationStartTime":
            return Optional.ofNullable(clazz.cast(compilationStartTime()));
        case "CompilationEndTime":
            return Optional.ofNullable(clazz.cast(compilationEndTime()));
        case "CompilationTargetDevice":
            return Optional.ofNullable(clazz.cast(compilationTargetDeviceAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CompilationJobStatus":
            return Optional.ofNullable(clazz.cast(compilationJobStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompilationJobSummary, T> g) {
        return obj -> g.apply((CompilationJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompilationJobSummary> {
        /**
         * <p>
         * The name of the model compilation job that you want a summary for.
         * </p>
         * 
         * @param compilationJobName
         *        The name of the model compilation job that you want a summary for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobName(String compilationJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model compilation job.
         * </p>
         * 
         * @param compilationJobArn
         *        The Amazon Resource Name (ARN) of the model compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobArn(String compilationJobArn);

        /**
         * <p>
         * The time when the model compilation job was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the model compilation job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the model compilation job started.
         * </p>
         * 
         * @param compilationStartTime
         *        The time when the model compilation job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationStartTime(Instant compilationStartTime);

        /**
         * <p>
         * The time when the model compilation job completed.
         * </p>
         * 
         * @param compilationEndTime
         *        The time when the model compilation job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationEndTime(Instant compilationEndTime);

        /**
         * <p>
         * The type of device that the model will run on after compilation has completed.
         * </p>
         * 
         * @param compilationTargetDevice
         *        The type of device that the model will run on after compilation has completed.
         * @see TargetDevice
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDevice
         */
        Builder compilationTargetDevice(String compilationTargetDevice);

        /**
         * <p>
         * The type of device that the model will run on after compilation has completed.
         * </p>
         * 
         * @param compilationTargetDevice
         *        The type of device that the model will run on after compilation has completed.
         * @see TargetDevice
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDevice
         */
        Builder compilationTargetDevice(TargetDevice compilationTargetDevice);

        /**
         * <p>
         * The time when the model compilation job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the model compilation job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The status of the model compilation job.
         * </p>
         * 
         * @param compilationJobStatus
         *        The status of the model compilation job.
         * @see CompilationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompilationJobStatus
         */
        Builder compilationJobStatus(String compilationJobStatus);

        /**
         * <p>
         * The status of the model compilation job.
         * </p>
         * 
         * @param compilationJobStatus
         *        The status of the model compilation job.
         * @see CompilationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompilationJobStatus
         */
        Builder compilationJobStatus(CompilationJobStatus compilationJobStatus);
    }

    static final class BuilderImpl implements Builder {
        private String compilationJobName;

        private String compilationJobArn;

        private Instant creationTime;

        private Instant compilationStartTime;

        private Instant compilationEndTime;

        private String compilationTargetDevice;

        private Instant lastModifiedTime;

        private String compilationJobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CompilationJobSummary model) {
            compilationJobName(model.compilationJobName);
            compilationJobArn(model.compilationJobArn);
            creationTime(model.creationTime);
            compilationStartTime(model.compilationStartTime);
            compilationEndTime(model.compilationEndTime);
            compilationTargetDevice(model.compilationTargetDevice);
            lastModifiedTime(model.lastModifiedTime);
            compilationJobStatus(model.compilationJobStatus);
        }

        public final String getCompilationJobName() {
            return compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        public final String getCompilationJobArn() {
            return compilationJobArn;
        }

        @Override
        public final Builder compilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
            return this;
        }

        public final void setCompilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getCompilationStartTime() {
            return compilationStartTime;
        }

        @Override
        public final Builder compilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
            return this;
        }

        public final void setCompilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
        }

        public final Instant getCompilationEndTime() {
            return compilationEndTime;
        }

        @Override
        public final Builder compilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
            return this;
        }

        public final void setCompilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
        }

        public final String getCompilationTargetDevice() {
            return compilationTargetDevice;
        }

        @Override
        public final Builder compilationTargetDevice(String compilationTargetDevice) {
            this.compilationTargetDevice = compilationTargetDevice;
            return this;
        }

        @Override
        public final Builder compilationTargetDevice(TargetDevice compilationTargetDevice) {
            this.compilationTargetDevice(compilationTargetDevice == null ? null : compilationTargetDevice.toString());
            return this;
        }

        public final void setCompilationTargetDevice(String compilationTargetDevice) {
            this.compilationTargetDevice = compilationTargetDevice;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getCompilationJobStatus() {
            return compilationJobStatus;
        }

        @Override
        public final Builder compilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
            return this;
        }

        @Override
        public final Builder compilationJobStatus(CompilationJobStatus compilationJobStatus) {
            this.compilationJobStatus(compilationJobStatus == null ? null : compilationJobStatus.toString());
            return this;
        }

        public final void setCompilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
        }

        @Override
        public CompilationJobSummary build() {
            return new CompilationJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
