/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings;
import software.amazon.awssdk.services.sagemaker.model.KernelGatewayAppSettings;
import software.amazon.awssdk.services.sagemaker.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.sagemaker.model.SharingSettings;
import software.amazon.awssdk.services.sagemaker.model.TensorBoardAppSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSettings> {
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserSettings.getter(UserSettings::executionRole)).setter(UserSettings.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UserSettings.getter(UserSettings::securityGroups)).setter(UserSettings.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SharingSettings> SHARING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UserSettings.getter(UserSettings::sharingSettings)).setter(UserSettings.setter(Builder::sharingSettings)).constructor(SharingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharingSettings").build()}).build();
    private static final SdkField<JupyterServerAppSettings> JUPYTER_SERVER_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UserSettings.getter(UserSettings::jupyterServerAppSettings)).setter(UserSettings.setter(Builder::jupyterServerAppSettings)).constructor(JupyterServerAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterServerAppSettings").build()}).build();
    private static final SdkField<KernelGatewayAppSettings> KERNEL_GATEWAY_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UserSettings.getter(UserSettings::kernelGatewayAppSettings)).setter(UserSettings.setter(Builder::kernelGatewayAppSettings)).constructor(KernelGatewayAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayAppSettings").build()}).build();
    private static final SdkField<TensorBoardAppSettings> TENSOR_BOARD_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UserSettings.getter(UserSettings::tensorBoardAppSettings)).setter(UserSettings.setter(Builder::tensorBoardAppSettings)).constructor(TensorBoardAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TensorBoardAppSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_FIELD, SECURITY_GROUPS_FIELD, SHARING_SETTINGS_FIELD, JUPYTER_SERVER_APP_SETTINGS_FIELD, KERNEL_GATEWAY_APP_SETTINGS_FIELD, TENSOR_BOARD_APP_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionRole;
    private final List<String> securityGroups;
    private final SharingSettings sharingSettings;
    private final JupyterServerAppSettings jupyterServerAppSettings;
    private final KernelGatewayAppSettings kernelGatewayAppSettings;
    private final TensorBoardAppSettings tensorBoardAppSettings;

    private UserSettings(BuilderImpl builder) {
        this.executionRole = builder.executionRole;
        this.securityGroups = builder.securityGroups;
        this.sharingSettings = builder.sharingSettings;
        this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
        this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
        this.tensorBoardAppSettings = builder.tensorBoardAppSettings;
    }

    public String executionRole() {
        return this.executionRole;
    }

    public boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public SharingSettings sharingSettings() {
        return this.sharingSettings;
    }

    public JupyterServerAppSettings jupyterServerAppSettings() {
        return this.jupyterServerAppSettings;
    }

    public KernelGatewayAppSettings kernelGatewayAppSettings() {
        return this.kernelGatewayAppSettings;
    }

    public TensorBoardAppSettings tensorBoardAppSettings() {
        return this.tensorBoardAppSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.jupyterServerAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelGatewayAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tensorBoardAppSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings)obj;
        return Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sharingSettings(), other.sharingSettings()) && Objects.equals(this.jupyterServerAppSettings(), other.jupyterServerAppSettings()) && Objects.equals(this.kernelGatewayAppSettings(), other.kernelGatewayAppSettings()) && Objects.equals(this.tensorBoardAppSettings(), other.tensorBoardAppSettings());
    }

    public String toString() {
        return ToString.builder((String)"UserSettings").add("ExecutionRole", (Object)this.executionRole()).add("SecurityGroups", this.securityGroups()).add("SharingSettings", (Object)this.sharingSettings()).add("JupyterServerAppSettings", (Object)this.jupyterServerAppSettings()).add("KernelGatewayAppSettings", (Object)this.kernelGatewayAppSettings()).add("TensorBoardAppSettings", (Object)this.tensorBoardAppSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SharingSettings": {
                return Optional.ofNullable(clazz.cast(this.sharingSettings()));
            }
            case "JupyterServerAppSettings": {
                return Optional.ofNullable(clazz.cast(this.jupyterServerAppSettings()));
            }
            case "KernelGatewayAppSettings": {
                return Optional.ofNullable(clazz.cast(this.kernelGatewayAppSettings()));
            }
            case "TensorBoardAppSettings": {
                return Optional.ofNullable(clazz.cast(this.tensorBoardAppSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserSettings, T> g) {
        return obj -> g.apply((UserSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionRole;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private SharingSettings sharingSettings;
        private JupyterServerAppSettings jupyterServerAppSettings;
        private KernelGatewayAppSettings kernelGatewayAppSettings;
        private TensorBoardAppSettings tensorBoardAppSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSettings model) {
            this.executionRole(model.executionRole);
            this.securityGroups(model.securityGroups);
            this.sharingSettings(model.sharingSettings);
            this.jupyterServerAppSettings(model.jupyterServerAppSettings);
            this.kernelGatewayAppSettings(model.kernelGatewayAppSettings);
            this.tensorBoardAppSettings(model.tensorBoardAppSettings);
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
        }

        public final SharingSettings.Builder getSharingSettings() {
            return this.sharingSettings != null ? this.sharingSettings.toBuilder() : null;
        }

        @Override
        public final Builder sharingSettings(SharingSettings sharingSettings) {
            this.sharingSettings = sharingSettings;
            return this;
        }

        public final void setSharingSettings(SharingSettings.BuilderImpl sharingSettings) {
            this.sharingSettings = sharingSettings != null ? sharingSettings.build() : null;
        }

        public final JupyterServerAppSettings.Builder getJupyterServerAppSettings() {
            return this.jupyterServerAppSettings != null ? this.jupyterServerAppSettings.toBuilder() : null;
        }

        @Override
        public final Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings;
            return this;
        }

        public final void setJupyterServerAppSettings(JupyterServerAppSettings.BuilderImpl jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings != null ? jupyterServerAppSettings.build() : null;
        }

        public final KernelGatewayAppSettings.Builder getKernelGatewayAppSettings() {
            return this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.toBuilder() : null;
        }

        @Override
        public final Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings;
            return this;
        }

        public final void setKernelGatewayAppSettings(KernelGatewayAppSettings.BuilderImpl kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings != null ? kernelGatewayAppSettings.build() : null;
        }

        public final TensorBoardAppSettings.Builder getTensorBoardAppSettings() {
            return this.tensorBoardAppSettings != null ? this.tensorBoardAppSettings.toBuilder() : null;
        }

        @Override
        public final Builder tensorBoardAppSettings(TensorBoardAppSettings tensorBoardAppSettings) {
            this.tensorBoardAppSettings = tensorBoardAppSettings;
            return this;
        }

        public final void setTensorBoardAppSettings(TensorBoardAppSettings.BuilderImpl tensorBoardAppSettings) {
            this.tensorBoardAppSettings = tensorBoardAppSettings != null ? tensorBoardAppSettings.build() : null;
        }

        public UserSettings build() {
            return new UserSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSettings> {
        public Builder executionRole(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder sharingSettings(SharingSettings var1);

        default public Builder sharingSettings(Consumer<SharingSettings.Builder> sharingSettings) {
            return this.sharingSettings((SharingSettings)((SharingSettings.Builder)SharingSettings.builder().applyMutation(sharingSettings)).build());
        }

        public Builder jupyterServerAppSettings(JupyterServerAppSettings var1);

        default public Builder jupyterServerAppSettings(Consumer<JupyterServerAppSettings.Builder> jupyterServerAppSettings) {
            return this.jupyterServerAppSettings((JupyterServerAppSettings)((JupyterServerAppSettings.Builder)JupyterServerAppSettings.builder().applyMutation(jupyterServerAppSettings)).build());
        }

        public Builder kernelGatewayAppSettings(KernelGatewayAppSettings var1);

        default public Builder kernelGatewayAppSettings(Consumer<KernelGatewayAppSettings.Builder> kernelGatewayAppSettings) {
            return this.kernelGatewayAppSettings((KernelGatewayAppSettings)((KernelGatewayAppSettings.Builder)KernelGatewayAppSettings.builder().applyMutation(kernelGatewayAppSettings)).build());
        }

        public Builder tensorBoardAppSettings(TensorBoardAppSettings var1);

        default public Builder tensorBoardAppSettings(Consumer<TensorBoardAppSettings.Builder> tensorBoardAppSettings) {
            return this.tensorBoardAppSettings((TensorBoardAppSettings)((TensorBoardAppSettings.Builder)TensorBoardAppSettings.builder().applyMutation(tensorBoardAppSettings)).build());
        }
    }
}

