/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the monitoring schedule and defines the monitoring job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringScheduleConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringScheduleConfig.Builder, MonitoringScheduleConfig> {
    private static final SdkField<ScheduleConfig> SCHEDULE_CONFIG_FIELD = SdkField
            .<ScheduleConfig> builder(MarshallingType.SDK_POJO).getter(getter(MonitoringScheduleConfig::scheduleConfig))
            .setter(setter(Builder::scheduleConfig)).constructor(ScheduleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfig").build()).build();

    private static final SdkField<MonitoringJobDefinition> MONITORING_JOB_DEFINITION_FIELD = SdkField
            .<MonitoringJobDefinition> builder(MarshallingType.SDK_POJO)
            .getter(getter(MonitoringScheduleConfig::monitoringJobDefinition)).setter(setter(Builder::monitoringJobDefinition))
            .constructor(MonitoringJobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringJobDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_CONFIG_FIELD,
            MONITORING_JOB_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ScheduleConfig scheduleConfig;

    private final MonitoringJobDefinition monitoringJobDefinition;

    private MonitoringScheduleConfig(BuilderImpl builder) {
        this.scheduleConfig = builder.scheduleConfig;
        this.monitoringJobDefinition = builder.monitoringJobDefinition;
    }

    /**
     * <p>
     * Configures the monitoring schedule.
     * </p>
     * 
     * @return Configures the monitoring schedule.
     */
    public ScheduleConfig scheduleConfig() {
        return scheduleConfig;
    }

    /**
     * <p>
     * Defines the monitoring job.
     * </p>
     * 
     * @return Defines the monitoring job.
     */
    public MonitoringJobDefinition monitoringJobDefinition() {
        return monitoringJobDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringJobDefinition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringScheduleConfig)) {
            return false;
        }
        MonitoringScheduleConfig other = (MonitoringScheduleConfig) obj;
        return Objects.equals(scheduleConfig(), other.scheduleConfig())
                && Objects.equals(monitoringJobDefinition(), other.monitoringJobDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MonitoringScheduleConfig").add("ScheduleConfig", scheduleConfig())
                .add("MonitoringJobDefinition", monitoringJobDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleConfig":
            return Optional.ofNullable(clazz.cast(scheduleConfig()));
        case "MonitoringJobDefinition":
            return Optional.ofNullable(clazz.cast(monitoringJobDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringScheduleConfig, T> g) {
        return obj -> g.apply((MonitoringScheduleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringScheduleConfig> {
        /**
         * <p>
         * Configures the monitoring schedule.
         * </p>
         * 
         * @param scheduleConfig
         *        Configures the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfig(ScheduleConfig scheduleConfig);

        /**
         * <p>
         * Configures the monitoring schedule.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduleConfig.Builder} avoiding the need to
         * create one manually via {@link ScheduleConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduleConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #scheduleConfig(ScheduleConfig)}.
         * 
         * @param scheduleConfig
         *        a consumer that will call methods on {@link ScheduleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfig(ScheduleConfig)
         */
        default Builder scheduleConfig(Consumer<ScheduleConfig.Builder> scheduleConfig) {
            return scheduleConfig(ScheduleConfig.builder().applyMutation(scheduleConfig).build());
        }

        /**
         * <p>
         * Defines the monitoring job.
         * </p>
         * 
         * @param monitoringJobDefinition
         *        Defines the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringJobDefinition(MonitoringJobDefinition monitoringJobDefinition);

        /**
         * <p>
         * Defines the monitoring job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringJobDefinition.Builder} avoiding the
         * need to create one manually via {@link MonitoringJobDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringJobDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringJobDefinition(MonitoringJobDefinition)}.
         * 
         * @param monitoringJobDefinition
         *        a consumer that will call methods on {@link MonitoringJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringJobDefinition(MonitoringJobDefinition)
         */
        default Builder monitoringJobDefinition(Consumer<MonitoringJobDefinition.Builder> monitoringJobDefinition) {
            return monitoringJobDefinition(MonitoringJobDefinition.builder().applyMutation(monitoringJobDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ScheduleConfig scheduleConfig;

        private MonitoringJobDefinition monitoringJobDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringScheduleConfig model) {
            scheduleConfig(model.scheduleConfig);
            monitoringJobDefinition(model.monitoringJobDefinition);
        }

        public final ScheduleConfig.Builder getScheduleConfig() {
            return scheduleConfig != null ? scheduleConfig.toBuilder() : null;
        }

        @Override
        public final Builder scheduleConfig(ScheduleConfig scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public final void setScheduleConfig(ScheduleConfig.BuilderImpl scheduleConfig) {
            this.scheduleConfig = scheduleConfig != null ? scheduleConfig.build() : null;
        }

        public final MonitoringJobDefinition.Builder getMonitoringJobDefinition() {
            return monitoringJobDefinition != null ? monitoringJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder monitoringJobDefinition(MonitoringJobDefinition monitoringJobDefinition) {
            this.monitoringJobDefinition = monitoringJobDefinition;
            return this;
        }

        public final void setMonitoringJobDefinition(MonitoringJobDefinition.BuilderImpl monitoringJobDefinition) {
            this.monitoringJobDefinition = monitoringJobDefinition != null ? monitoringJobDefinition.build() : null;
        }

        @Override
        public MonitoringScheduleConfig build() {
            return new MonitoringScheduleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
