/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of information about the last monitoring job to run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringExecutionSummary.Builder, MonitoringExecutionSummary> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringExecutionSummary::monitoringScheduleName)).setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MonitoringExecutionSummary::scheduledTime)).setter(setter(Builder::scheduledTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MonitoringExecutionSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MonitoringExecutionSummary::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> MONITORING_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringExecutionSummary::monitoringExecutionStatusAsString))
            .setter(setter(Builder::monitoringExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringExecutionStatus").build())
            .build();

    private static final SdkField<String> PROCESSING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringExecutionSummary::processingJobArn)).setter(setter(Builder::processingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobArn").build()).build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringExecutionSummary::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringExecutionSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_NAME_FIELD, SCHEDULED_TIME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            MONITORING_EXECUTION_STATUS_FIELD, PROCESSING_JOB_ARN_FIELD, ENDPOINT_NAME_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String monitoringScheduleName;

    private final Instant scheduledTime;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String monitoringExecutionStatus;

    private final String processingJobArn;

    private final String endpointName;

    private final String failureReason;

    private MonitoringExecutionSummary(BuilderImpl builder) {
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.scheduledTime = builder.scheduledTime;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringExecutionStatus = builder.monitoringExecutionStatus;
        this.processingJobArn = builder.processingJobArn;
        this.endpointName = builder.endpointName;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the monitoring schedule.
     * </p>
     * 
     * @return The name of the monitoring schedule.
     */
    public String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The time the monitoring job was scheduled.
     * </p>
     * 
     * @return The time the monitoring job was scheduled.
     */
    public Instant scheduledTime() {
        return scheduledTime;
    }

    /**
     * <p>
     * The time at which the monitoring job was created.
     * </p>
     * 
     * @return The time at which the monitoring job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that indicates the last time the monitoring job was modified.
     * </p>
     * 
     * @return A timestamp that indicates the last time the monitoring job was modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the monitoring job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringExecutionStatus} will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring job.
     * @see ExecutionStatus
     */
    public ExecutionStatus monitoringExecutionStatus() {
        return ExecutionStatus.fromValue(monitoringExecutionStatus);
    }

    /**
     * <p>
     * The status of the monitoring job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringExecutionStatus} will return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring job.
     * @see ExecutionStatus
     */
    public String monitoringExecutionStatusAsString() {
        return monitoringExecutionStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitoring job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitoring job.
     */
    public String processingJobArn() {
        return processingJobArn;
    }

    /**
     * <p>
     * The name of teh endpoint used to run the monitoring job.
     * </p>
     * 
     * @return The name of teh endpoint used to run the monitoring job.
     */
    public String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * Contains the reason a monitoring job failed, if it failed.
     * </p>
     * 
     * @return Contains the reason a monitoring job failed, if it failed.
     */
    public String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(processingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringExecutionSummary)) {
            return false;
        }
        MonitoringExecutionSummary other = (MonitoringExecutionSummary) obj;
        return Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(scheduledTime(), other.scheduledTime()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(monitoringExecutionStatusAsString(), other.monitoringExecutionStatusAsString())
                && Objects.equals(processingJobArn(), other.processingJobArn())
                && Objects.equals(endpointName(), other.endpointName()) && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MonitoringExecutionSummary").add("MonitoringScheduleName", monitoringScheduleName())
                .add("ScheduledTime", scheduledTime()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime())
                .add("MonitoringExecutionStatus", monitoringExecutionStatusAsString())
                .add("ProcessingJobArn", processingJobArn()).add("EndpointName", endpointName())
                .add("FailureReason", failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "ScheduledTime":
            return Optional.ofNullable(clazz.cast(scheduledTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "MonitoringExecutionStatus":
            return Optional.ofNullable(clazz.cast(monitoringExecutionStatusAsString()));
        case "ProcessingJobArn":
            return Optional.ofNullable(clazz.cast(processingJobArn()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringExecutionSummary, T> g) {
        return obj -> g.apply((MonitoringExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringExecutionSummary> {
        /**
         * <p>
         * The name of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The time the monitoring job was scheduled.
         * </p>
         * 
         * @param scheduledTime
         *        The time the monitoring job was scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledTime(Instant scheduledTime);

        /**
         * <p>
         * The time at which the monitoring job was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the monitoring job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that indicates the last time the monitoring job was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that indicates the last time the monitoring job was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The status of the monitoring job.
         * </p>
         * 
         * @param monitoringExecutionStatus
         *        The status of the monitoring job.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder monitoringExecutionStatus(String monitoringExecutionStatus);

        /**
         * <p>
         * The status of the monitoring job.
         * </p>
         * 
         * @param monitoringExecutionStatus
         *        The status of the monitoring job.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder monitoringExecutionStatus(ExecutionStatus monitoringExecutionStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitoring job.
         * </p>
         * 
         * @param processingJobArn
         *        The Amazon Resource Name (ARN) of the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJobArn(String processingJobArn);

        /**
         * <p>
         * The name of teh endpoint used to run the monitoring job.
         * </p>
         * 
         * @param endpointName
         *        The name of teh endpoint used to run the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * Contains the reason a monitoring job failed, if it failed.
         * </p>
         * 
         * @param failureReason
         *        Contains the reason a monitoring job failed, if it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String monitoringScheduleName;

        private Instant scheduledTime;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String monitoringExecutionStatus;

        private String processingJobArn;

        private String endpointName;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringExecutionSummary model) {
            monitoringScheduleName(model.monitoringScheduleName);
            scheduledTime(model.scheduledTime);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            monitoringExecutionStatus(model.monitoringExecutionStatus);
            processingJobArn(model.processingJobArn);
            endpointName(model.endpointName);
            failureReason(model.failureReason);
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        public final Instant getScheduledTime() {
            return scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getMonitoringExecutionStatusAsString() {
            return monitoringExecutionStatus;
        }

        @Override
        public final Builder monitoringExecutionStatus(String monitoringExecutionStatus) {
            this.monitoringExecutionStatus = monitoringExecutionStatus;
            return this;
        }

        @Override
        public final Builder monitoringExecutionStatus(ExecutionStatus monitoringExecutionStatus) {
            this.monitoringExecutionStatus(monitoringExecutionStatus == null ? null : monitoringExecutionStatus.toString());
            return this;
        }

        public final void setMonitoringExecutionStatus(String monitoringExecutionStatus) {
            this.monitoringExecutionStatus = monitoringExecutionStatus;
        }

        public final String getProcessingJobArn() {
            return processingJobArn;
        }

        @Override
        public final Builder processingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
            return this;
        }

        public final void setProcessingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public MonitoringExecutionSummary build() {
            return new MonitoringExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
