/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a training job and a batch transform job that Amazon SageMaker runs to validate your algorithm.
 * </p>
 * <p>
 * The data provided in the validation profile is made available to your buyers on AWS Marketplace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlgorithmValidationProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<AlgorithmValidationProfile.Builder, AlgorithmValidationProfile> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AlgorithmValidationProfile::profileName)).setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()).build();

    private static final SdkField<TrainingJobDefinition> TRAINING_JOB_DEFINITION_FIELD = SdkField
            .<TrainingJobDefinition> builder(MarshallingType.SDK_POJO)
            .getter(getter(AlgorithmValidationProfile::trainingJobDefinition)).setter(setter(Builder::trainingJobDefinition))
            .constructor(TrainingJobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinition").build())
            .build();

    private static final SdkField<TransformJobDefinition> TRANSFORM_JOB_DEFINITION_FIELD = SdkField
            .<TransformJobDefinition> builder(MarshallingType.SDK_POJO)
            .getter(getter(AlgorithmValidationProfile::transformJobDefinition)).setter(setter(Builder::transformJobDefinition))
            .constructor(TransformJobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD,
            TRAINING_JOB_DEFINITION_FIELD, TRANSFORM_JOB_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String profileName;

    private final TrainingJobDefinition trainingJobDefinition;

    private final TransformJobDefinition transformJobDefinition;

    private AlgorithmValidationProfile(BuilderImpl builder) {
        this.profileName = builder.profileName;
        this.trainingJobDefinition = builder.trainingJobDefinition;
        this.transformJobDefinition = builder.transformJobDefinition;
    }

    /**
     * <p>
     * The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are a-z, A-Z,
     * 0-9, and - (hyphen).
     * </p>
     * 
     * @return The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are
     *         a-z, A-Z, 0-9, and - (hyphen).
     */
    public String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The <code>TrainingJobDefinition</code> object that describes the training job that Amazon SageMaker runs to
     * validate your algorithm.
     * </p>
     * 
     * @return The <code>TrainingJobDefinition</code> object that describes the training job that Amazon SageMaker runs
     *         to validate your algorithm.
     */
    public TrainingJobDefinition trainingJobDefinition() {
        return trainingJobDefinition;
    }

    /**
     * <p>
     * The <code>TransformJobDefinition</code> object that describes the transform job that Amazon SageMaker runs to
     * validate your algorithm.
     * </p>
     * 
     * @return The <code>TransformJobDefinition</code> object that describes the transform job that Amazon SageMaker
     *         runs to validate your algorithm.
     */
    public TransformJobDefinition transformJobDefinition() {
        return transformJobDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(transformJobDefinition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmValidationProfile)) {
            return false;
        }
        AlgorithmValidationProfile other = (AlgorithmValidationProfile) obj;
        return Objects.equals(profileName(), other.profileName())
                && Objects.equals(trainingJobDefinition(), other.trainingJobDefinition())
                && Objects.equals(transformJobDefinition(), other.transformJobDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AlgorithmValidationProfile").add("ProfileName", profileName())
                .add("TrainingJobDefinition", trainingJobDefinition()).add("TransformJobDefinition", transformJobDefinition())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "TrainingJobDefinition":
            return Optional.ofNullable(clazz.cast(trainingJobDefinition()));
        case "TransformJobDefinition":
            return Optional.ofNullable(clazz.cast(transformJobDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmValidationProfile, T> g) {
        return obj -> g.apply((AlgorithmValidationProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlgorithmValidationProfile> {
        /**
         * <p>
         * The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are a-z,
         * A-Z, 0-9, and - (hyphen).
         * </p>
         * 
         * @param profileName
         *        The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are
         *        a-z, A-Z, 0-9, and - (hyphen).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The <code>TrainingJobDefinition</code> object that describes the training job that Amazon SageMaker runs to
         * validate your algorithm.
         * </p>
         * 
         * @param trainingJobDefinition
         *        The <code>TrainingJobDefinition</code> object that describes the training job that Amazon SageMaker
         *        runs to validate your algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobDefinition(TrainingJobDefinition trainingJobDefinition);

        /**
         * <p>
         * The <code>TrainingJobDefinition</code> object that describes the training job that Amazon SageMaker runs to
         * validate your algorithm.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingJobDefinition.Builder} avoiding the need
         * to create one manually via {@link TrainingJobDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingJobDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #trainingJobDefinition(TrainingJobDefinition)}.
         * 
         * @param trainingJobDefinition
         *        a consumer that will call methods on {@link TrainingJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobDefinition(TrainingJobDefinition)
         */
        default Builder trainingJobDefinition(Consumer<TrainingJobDefinition.Builder> trainingJobDefinition) {
            return trainingJobDefinition(TrainingJobDefinition.builder().applyMutation(trainingJobDefinition).build());
        }

        /**
         * <p>
         * The <code>TransformJobDefinition</code> object that describes the transform job that Amazon SageMaker runs to
         * validate your algorithm.
         * </p>
         * 
         * @param transformJobDefinition
         *        The <code>TransformJobDefinition</code> object that describes the transform job that Amazon SageMaker
         *        runs to validate your algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJobDefinition(TransformJobDefinition transformJobDefinition);

        /**
         * <p>
         * The <code>TransformJobDefinition</code> object that describes the transform job that Amazon SageMaker runs to
         * validate your algorithm.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformJobDefinition.Builder} avoiding the
         * need to create one manually via {@link TransformJobDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformJobDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #transformJobDefinition(TransformJobDefinition)}.
         * 
         * @param transformJobDefinition
         *        a consumer that will call methods on {@link TransformJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformJobDefinition(TransformJobDefinition)
         */
        default Builder transformJobDefinition(Consumer<TransformJobDefinition.Builder> transformJobDefinition) {
            return transformJobDefinition(TransformJobDefinition.builder().applyMutation(transformJobDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String profileName;

        private TrainingJobDefinition trainingJobDefinition;

        private TransformJobDefinition transformJobDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmValidationProfile model) {
            profileName(model.profileName);
            trainingJobDefinition(model.trainingJobDefinition);
            transformJobDefinition(model.transformJobDefinition);
        }

        public final String getProfileName() {
            return profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final TrainingJobDefinition.Builder getTrainingJobDefinition() {
            return trainingJobDefinition != null ? trainingJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder trainingJobDefinition(TrainingJobDefinition trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition;
            return this;
        }

        public final void setTrainingJobDefinition(TrainingJobDefinition.BuilderImpl trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition != null ? trainingJobDefinition.build() : null;
        }

        public final TransformJobDefinition.Builder getTransformJobDefinition() {
            return transformJobDefinition != null ? transformJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder transformJobDefinition(TransformJobDefinition transformJobDefinition) {
            this.transformJobDefinition = transformJobDefinition;
            return this;
        }

        public final void setTransformJobDefinition(TransformJobDefinition.BuilderImpl transformJobDefinition) {
            this.transformJobDefinition = transformJobDefinition != null ? transformJobDefinition.build() : null;
        }

        @Override
        public AlgorithmValidationProfile build() {
            return new AlgorithmValidationProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
