/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.S3DataSource;

public class S3DataSourceUnmarshaller
implements Unmarshaller<S3DataSource, JsonUnmarshallerContext> {
    private static final S3DataSourceUnmarshaller INSTANCE = new S3DataSourceUnmarshaller();

    public S3DataSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3DataSource.Builder s3DataSourceBuilder = S3DataSource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3DataType", targetDepth)) {
                    context.nextToken();
                    s3DataSourceBuilder.s3DataType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3Uri", targetDepth)) {
                    context.nextToken();
                    s3DataSourceBuilder.s3Uri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3DataDistributionType", targetDepth)) {
                    context.nextToken();
                    s3DataSourceBuilder.s3DataDistributionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3DataSource)s3DataSourceBuilder.build();
    }

    public static S3DataSourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

