/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AlgorithmSpecificationMarshaller {
    private static final MarshallingInfo<String> TRAININGIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingImage").isBinary(false).build();
    private static final MarshallingInfo<String> TRAININGINPUTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingInputMode").isBinary(false).build();
    private static final AlgorithmSpecificationMarshaller INSTANCE = new AlgorithmSpecificationMarshaller();

    private AlgorithmSpecificationMarshaller() {
    }

    public static AlgorithmSpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AlgorithmSpecification algorithmSpecification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)algorithmSpecification, (String)"algorithmSpecification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)algorithmSpecification.trainingImage(), TRAININGIMAGE_BINDING);
            protocolMarshaller.marshall((Object)algorithmSpecification.trainingInputModeString(), TRAININGINPUTMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

