/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;

public class ListModelsIterable
implements SdkIterable<ListModelsResponse> {
    private final SageMakerClient client;
    private final ListModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelsIterable(SageMakerClient client, ListModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListModelsResponseFetcher();
    }

    public Iterator<ListModelsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListModelsIterable resume(ListModelsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListModelsIterable(this.client, (ListModelsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListModelsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListModelsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListModelsResponseFetcher
    implements SyncPageFetcher<ListModelsResponse> {
        private ListModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListModelsResponse nextPage(ListModelsResponse previousPage) {
            if (previousPage == null) {
                return ListModelsIterable.this.client.listModels(ListModelsIterable.this.firstRequest);
            }
            return ListModelsIterable.this.client.listModels((ListModelsRequest)((Object)ListModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

