/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sagemaker.model.ContainerDefinition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateModelRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateModelRequest> {
    private final String modelName;
    private final ContainerDefinition primaryContainer;
    private final String executionRoleArn;
    private final List<Tag> tags;

    private CreateModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.primaryContainer = builder.primaryContainer;
        this.executionRoleArn = builder.executionRoleArn;
        this.tags = builder.tags;
    }

    public String modelName() {
        return this.modelName;
    }

    public ContainerDefinition primaryContainer() {
        return this.primaryContainer;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelRequest)) {
            return false;
        }
        CreateModelRequest other = (CreateModelRequest)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.primaryContainer(), other.primaryContainer()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateModelRequest").add("ModelName", (Object)this.modelName()).add("PrimaryContainer", (Object)this.primaryContainer()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.of(clazz.cast(this.modelName()));
            }
            case "PrimaryContainer": {
                return Optional.of(clazz.cast(this.primaryContainer()));
            }
            case "ExecutionRoleArn": {
                return Optional.of(clazz.cast(this.executionRoleArn()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelName;
        private ContainerDefinition primaryContainer;
        private String executionRoleArn;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelRequest model) {
            this.modelName(model.modelName);
            this.primaryContainer(model.primaryContainer);
            this.executionRoleArn(model.executionRoleArn);
            this.tags(model.tags);
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final ContainerDefinition.Builder getPrimaryContainer() {
            return this.primaryContainer != null ? this.primaryContainer.toBuilder() : null;
        }

        @Override
        public final Builder primaryContainer(ContainerDefinition primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final void setPrimaryContainer(ContainerDefinition.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateModelRequest build() {
            return new CreateModelRequest(this);
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    CopyableBuilder<Builder, CreateModelRequest> {
        public Builder modelName(String var1);

        public Builder primaryContainer(ContainerDefinition var1);

        default public Builder primaryContainer(Consumer<ContainerDefinition.Builder> primaryContainer) {
            return this.primaryContainer((ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().apply(primaryContainer)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

