/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.TrainingInputMode;
import software.amazon.awssdk.services.sagemaker.transform.AlgorithmSpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AlgorithmSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, AlgorithmSpecification> {
    private final String trainingImage;
    private final String trainingInputMode;

    private AlgorithmSpecification(BuilderImpl builder) {
        this.trainingImage = builder.trainingImage;
        this.trainingInputMode = builder.trainingInputMode;
    }

    public String trainingImage() {
        return this.trainingImage;
    }

    public TrainingInputMode trainingInputMode() {
        return TrainingInputMode.fromValue(this.trainingInputMode);
    }

    public String trainingInputModeString() {
        return this.trainingInputMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingInputModeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmSpecification)) {
            return false;
        }
        AlgorithmSpecification other = (AlgorithmSpecification)obj;
        return Objects.equals(this.trainingImage(), other.trainingImage()) && Objects.equals(this.trainingInputModeString(), other.trainingInputModeString());
    }

    public String toString() {
        return ToString.builder((String)"AlgorithmSpecification").add("TrainingImage", (Object)this.trainingImage()).add("TrainingInputMode", (Object)this.trainingInputModeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingImage": {
                return Optional.of(clazz.cast(this.trainingImage()));
            }
            case "TrainingInputMode": {
                return Optional.of(clazz.cast(this.trainingInputModeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlgorithmSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingImage;
        private String trainingInputMode;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmSpecification model) {
            this.trainingImage(model.trainingImage);
            this.trainingInputMode(model.trainingInputMode);
        }

        public final String getTrainingImage() {
            return this.trainingImage;
        }

        @Override
        public final Builder trainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
            return this;
        }

        public final void setTrainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
        }

        public final String getTrainingInputMode() {
            return this.trainingInputMode;
        }

        @Override
        public final Builder trainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        @Override
        public final Builder trainingInputMode(TrainingInputMode trainingInputMode) {
            this.trainingInputMode(trainingInputMode.toString());
            return this;
        }

        public final void setTrainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
        }

        public AlgorithmSpecification build() {
            return new AlgorithmSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AlgorithmSpecification> {
        public Builder trainingImage(String var1);

        public Builder trainingInputMode(String var1);

        public Builder trainingInputMode(TrainingInputMode var1);
    }
}

