/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.Channel;
import software.amazon.awssdk.services.sagemaker.transform.DataSourceUnmarshaller;

public class ChannelUnmarshaller
implements Unmarshaller<Channel, JsonUnmarshallerContext> {
    private static final ChannelUnmarshaller INSTANCE = new ChannelUnmarshaller();

    public Channel unmarshall(JsonUnmarshallerContext context) throws Exception {
        Channel.Builder channelBuilder = Channel.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ChannelName", targetDepth)) {
                    context.nextToken();
                    channelBuilder.channelName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSource", targetDepth)) {
                    context.nextToken();
                    channelBuilder.dataSource(DataSourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ContentType", targetDepth)) {
                    context.nextToken();
                    channelBuilder.contentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CompressionType", targetDepth)) {
                    context.nextToken();
                    channelBuilder.compressionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RecordWrapperType", targetDepth)) {
                    context.nextToken();
                    channelBuilder.recordWrapperType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Channel)channelBuilder.build();
    }

    public static ChannelUnmarshaller getInstance() {
        return INSTANCE;
    }
}

