/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListNotebookInstancesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListNotebookInstancesResponse> {
    private final String nextToken;
    private final List<NotebookInstanceSummary> notebookInstances;

    private ListNotebookInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notebookInstances = builder.notebookInstances;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<NotebookInstanceSummary> notebookInstances() {
        return this.notebookInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookInstancesResponse)) {
            return false;
        }
        ListNotebookInstancesResponse other = (ListNotebookInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.notebookInstances(), other.notebookInstances());
    }

    public String toString() {
        return ToString.builder((String)"ListNotebookInstancesResponse").add("NextToken", (Object)this.nextToken()).add("NotebookInstances", this.notebookInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "NotebookInstances": {
                return Optional.of(clazz.cast(this.notebookInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NotebookInstanceSummary> notebookInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookInstancesResponse model) {
            this.nextToken(model.nextToken);
            this.notebookInstances(model.notebookInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<NotebookInstanceSummary.Builder> getNotebookInstances() {
            return this.notebookInstances != null ? (Collection)this.notebookInstances.stream().map(NotebookInstanceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notebookInstances(Collection<NotebookInstanceSummary> notebookInstances) {
            this.notebookInstances = NotebookInstanceSummaryListCopier.copy(notebookInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstances(NotebookInstanceSummary ... notebookInstances) {
            this.notebookInstances(Arrays.asList(notebookInstances));
            return this;
        }

        public final void setNotebookInstances(Collection<NotebookInstanceSummary.BuilderImpl> notebookInstances) {
            this.notebookInstances = NotebookInstanceSummaryListCopier.copyFromBuilder(notebookInstances);
        }

        @Override
        public ListNotebookInstancesResponse build() {
            return new ListNotebookInstancesResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, ListNotebookInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder notebookInstances(Collection<NotebookInstanceSummary> var1);

        public Builder notebookInstances(NotebookInstanceSummary ... var1);
    }
}

