/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;

public class ListTransformJobsPublisher
implements SdkPublisher<ListTransformJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListTransformJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTransformJobsPublisher(SageMakerAsyncClient client, ListTransformJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTransformJobsPublisher(SageMakerAsyncClient client, ListTransformJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTransformJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTransformJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListTransformJobsPublisher resume(ListTransformJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTransformJobsPublisher(this.client, (ListTransformJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTransformJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTransformJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTransformJobsResponseFetcher
    implements AsyncPageFetcher<ListTransformJobsResponse> {
        private ListTransformJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTransformJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTransformJobsResponse> nextPage(ListTransformJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTransformJobsPublisher.this.client.listTransformJobs(ListTransformJobsPublisher.this.firstRequest);
            }
            return ListTransformJobsPublisher.this.client.listTransformJobs((ListTransformJobsRequest)((Object)ListTransformJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

