/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse;

public class ListHyperParameterTuningJobsPublisher
implements SdkPublisher<ListHyperParameterTuningJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListHyperParameterTuningJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHyperParameterTuningJobsPublisher(SageMakerAsyncClient client, ListHyperParameterTuningJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHyperParameterTuningJobsPublisher(SageMakerAsyncClient client, ListHyperParameterTuningJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHyperParameterTuningJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHyperParameterTuningJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListHyperParameterTuningJobsPublisher resume(ListHyperParameterTuningJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHyperParameterTuningJobsPublisher(this.client, (ListHyperParameterTuningJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListHyperParameterTuningJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListHyperParameterTuningJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListHyperParameterTuningJobsResponseFetcher
    implements AsyncPageFetcher<ListHyperParameterTuningJobsResponse> {
        private ListHyperParameterTuningJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListHyperParameterTuningJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHyperParameterTuningJobsResponse> nextPage(ListHyperParameterTuningJobsResponse previousPage) {
            if (previousPage == null) {
                return ListHyperParameterTuningJobsPublisher.this.client.listHyperParameterTuningJobs(ListHyperParameterTuningJobsPublisher.this.firstRequest);
            }
            return ListHyperParameterTuningJobsPublisher.this.client.listHyperParameterTuningJobs((ListHyperParameterTuningJobsRequest)((Object)ListHyperParameterTuningJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

