/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TrainingInputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlgorithmSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlgorithmSpecification> {
    private static final SdkField<String> TRAINING_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AlgorithmSpecification.getter(AlgorithmSpecification::trainingImage)).setter(AlgorithmSpecification.setter(Builder::trainingImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingImage").build()}).build();
    private static final SdkField<String> TRAINING_INPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AlgorithmSpecification.getter(AlgorithmSpecification::trainingInputModeAsString)).setter(AlgorithmSpecification.setter(Builder::trainingInputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingInputMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_IMAGE_FIELD, TRAINING_INPUT_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trainingImage;
    private final String trainingInputMode;

    private AlgorithmSpecification(BuilderImpl builder) {
        this.trainingImage = builder.trainingImage;
        this.trainingInputMode = builder.trainingInputMode;
    }

    public String trainingImage() {
        return this.trainingImage;
    }

    public TrainingInputMode trainingInputMode() {
        return TrainingInputMode.fromValue(this.trainingInputMode);
    }

    public String trainingInputModeAsString() {
        return this.trainingInputMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingInputModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmSpecification)) {
            return false;
        }
        AlgorithmSpecification other = (AlgorithmSpecification)obj;
        return Objects.equals(this.trainingImage(), other.trainingImage()) && Objects.equals(this.trainingInputModeAsString(), other.trainingInputModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AlgorithmSpecification").add("TrainingImage", (Object)this.trainingImage()).add("TrainingInputMode", (Object)this.trainingInputModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingImage": {
                return Optional.ofNullable(clazz.cast(this.trainingImage()));
            }
            case "TrainingInputMode": {
                return Optional.ofNullable(clazz.cast(this.trainingInputModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmSpecification, T> g) {
        return obj -> g.apply((AlgorithmSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingImage;
        private String trainingInputMode;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmSpecification model) {
            this.trainingImage(model.trainingImage);
            this.trainingInputMode(model.trainingInputMode);
        }

        public final String getTrainingImage() {
            return this.trainingImage;
        }

        @Override
        public final Builder trainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
            return this;
        }

        public final void setTrainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
        }

        public final String getTrainingInputMode() {
            return this.trainingInputMode;
        }

        @Override
        public final Builder trainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        @Override
        public final Builder trainingInputMode(TrainingInputMode trainingInputMode) {
            this.trainingInputMode(trainingInputMode.toString());
            return this;
        }

        public final void setTrainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
        }

        public AlgorithmSpecification build() {
            return new AlgorithmSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlgorithmSpecification> {
        public Builder trainingImage(String var1);

        public Builder trainingInputMode(String var1);

        public Builder trainingInputMode(TrainingInputMode var1);
    }
}

