/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.OutputDataConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputDataConfigMarshaller {
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final MarshallingInfo<String> S3OUTPUTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3OutputPath").isBinary(false).build();
    private static final OutputDataConfigMarshaller INSTANCE = new OutputDataConfigMarshaller();

    private OutputDataConfigMarshaller() {
    }

    public static OutputDataConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputDataConfig outputDataConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputDataConfig, (String)"outputDataConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputDataConfig.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)outputDataConfig.s3OutputPath(), S3OUTPUTPATH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

