/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.ContainerDefinition;

public class ContainerDefinitionUnmarshaller
implements Unmarshaller<ContainerDefinition, JsonUnmarshallerContext> {
    private static final ContainerDefinitionUnmarshaller INSTANCE = new ContainerDefinitionUnmarshaller();

    public ContainerDefinition unmarshall(JsonUnmarshallerContext context) throws Exception {
        ContainerDefinition.Builder containerDefinitionBuilder = ContainerDefinition.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ContainerHostname", targetDepth)) {
                    context.nextToken();
                    containerDefinitionBuilder.containerHostname((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Image", targetDepth)) {
                    context.nextToken();
                    containerDefinitionBuilder.image((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ModelDataUrl", targetDepth)) {
                    context.nextToken();
                    containerDefinitionBuilder.modelDataUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Environment", targetDepth)) {
                    context.nextToken();
                    containerDefinitionBuilder.environment(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ContainerDefinition)containerDefinitionBuilder.build();
    }

    public static ContainerDefinitionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

