/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.S3DataDistribution;
import software.amazon.awssdk.services.sagemaker.model.S3DataType;
import software.amazon.awssdk.services.sagemaker.transform.S3DataSourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3DataSource
implements StructuredPojo,
ToCopyableBuilder<Builder, S3DataSource> {
    private final String s3DataType;
    private final String s3Uri;
    private final String s3DataDistributionType;

    private S3DataSource(BuilderImpl builder) {
        this.s3DataType = builder.s3DataType;
        this.s3Uri = builder.s3Uri;
        this.s3DataDistributionType = builder.s3DataDistributionType;
    }

    public S3DataType s3DataType() {
        return S3DataType.fromValue(this.s3DataType);
    }

    public String s3DataTypeAsString() {
        return this.s3DataType;
    }

    public String s3Uri() {
        return this.s3Uri;
    }

    public S3DataDistribution s3DataDistributionType() {
        return S3DataDistribution.fromValue(this.s3DataDistributionType);
    }

    public String s3DataDistributionTypeAsString() {
        return this.s3DataDistributionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataDistributionTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSource)) {
            return false;
        }
        S3DataSource other = (S3DataSource)obj;
        return Objects.equals(this.s3DataTypeAsString(), other.s3DataTypeAsString()) && Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.s3DataDistributionTypeAsString(), other.s3DataDistributionTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"S3DataSource").add("S3DataType", (Object)this.s3DataTypeAsString()).add("S3Uri", (Object)this.s3Uri()).add("S3DataDistributionType", (Object)this.s3DataDistributionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3DataType": {
                return Optional.of(clazz.cast(this.s3DataTypeAsString()));
            }
            case "S3Uri": {
                return Optional.of(clazz.cast(this.s3Uri()));
            }
            case "S3DataDistributionType": {
                return Optional.of(clazz.cast(this.s3DataDistributionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3DataType;
        private String s3Uri;
        private String s3DataDistributionType;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataSource model) {
            this.s3DataType(model.s3DataType);
            this.s3Uri(model.s3Uri);
            this.s3DataDistributionType(model.s3DataDistributionType);
        }

        public final String getS3DataType() {
            return this.s3DataType;
        }

        @Override
        public final Builder s3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        @Override
        public final Builder s3DataType(S3DataType s3DataType) {
            this.s3DataType(s3DataType.toString());
            return this;
        }

        public final void setS3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getS3DataDistributionType() {
            return this.s3DataDistributionType;
        }

        @Override
        public final Builder s3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        @Override
        public final Builder s3DataDistributionType(S3DataDistribution s3DataDistributionType) {
            this.s3DataDistributionType(s3DataDistributionType.toString());
            return this;
        }

        public final void setS3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
        }

        public S3DataSource build() {
            return new S3DataSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3DataSource> {
        public Builder s3DataType(String var1);

        public Builder s3DataType(S3DataType var1);

        public Builder s3Uri(String var1);

        public Builder s3DataDistributionType(String var1);

        public Builder s3DataDistributionType(S3DataDistribution var1);
    }
}

