/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType;
import software.amazon.awssdk.services.sagemaker.transform.ProductionVariantMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProductionVariant
implements StructuredPojo,
ToCopyableBuilder<Builder, ProductionVariant> {
    private final String variantName;
    private final String modelName;
    private final Integer initialInstanceCount;
    private final String instanceType;
    private final Float initialVariantWeight;

    private ProductionVariant(BuilderImpl builder) {
        this.variantName = builder.variantName;
        this.modelName = builder.modelName;
        this.initialInstanceCount = builder.initialInstanceCount;
        this.instanceType = builder.instanceType;
        this.initialVariantWeight = builder.initialVariantWeight;
    }

    public String variantName() {
        return this.variantName;
    }

    public String modelName() {
        return this.modelName;
    }

    public Integer initialInstanceCount() {
        return this.initialInstanceCount;
    }

    public ProductionVariantInstanceType instanceType() {
        return ProductionVariantInstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public Float initialVariantWeight() {
        return this.initialVariantWeight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialVariantWeight());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariant)) {
            return false;
        }
        ProductionVariant other = (ProductionVariant)obj;
        return Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.initialInstanceCount(), other.initialInstanceCount()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.initialVariantWeight(), other.initialVariantWeight());
    }

    public String toString() {
        return ToString.builder((String)"ProductionVariant").add("VariantName", (Object)this.variantName()).add("ModelName", (Object)this.modelName()).add("InitialInstanceCount", (Object)this.initialInstanceCount()).add("InstanceType", (Object)this.instanceTypeAsString()).add("InitialVariantWeight", (Object)this.initialVariantWeight()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VariantName": {
                return Optional.of(clazz.cast(this.variantName()));
            }
            case "ModelName": {
                return Optional.of(clazz.cast(this.modelName()));
            }
            case "InitialInstanceCount": {
                return Optional.of(clazz.cast(this.initialInstanceCount()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeAsString()));
            }
            case "InitialVariantWeight": {
                return Optional.of(clazz.cast(this.initialVariantWeight()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProductionVariantMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String variantName;
        private String modelName;
        private Integer initialInstanceCount;
        private String instanceType;
        private Float initialVariantWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariant model) {
            this.variantName(model.variantName);
            this.modelName(model.modelName);
            this.initialInstanceCount(model.initialInstanceCount);
            this.instanceType(model.instanceType);
            this.initialVariantWeight(model.initialVariantWeight);
        }

        public final String getVariantName() {
            return this.variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final Integer getInitialInstanceCount() {
            return this.initialInstanceCount;
        }

        @Override
        public final Builder initialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
            return this;
        }

        public final void setInitialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ProductionVariantInstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Float getInitialVariantWeight() {
            return this.initialVariantWeight;
        }

        @Override
        public final Builder initialVariantWeight(Float initialVariantWeight) {
            this.initialVariantWeight = initialVariantWeight;
            return this;
        }

        public final void setInitialVariantWeight(Float initialVariantWeight) {
            this.initialVariantWeight = initialVariantWeight;
        }

        public ProductionVariant build() {
            return new ProductionVariant(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProductionVariant> {
        public Builder variantName(String var1);

        public Builder modelName(String var1);

        public Builder initialInstanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ProductionVariantInstanceType var1);

        public Builder initialVariantWeight(Float var1);
    }
}

