/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListEndpointConfigsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListEndpointConfigsResponse> {
    private final List<EndpointConfigSummary> endpointConfigs;
    private final String nextToken;

    private ListEndpointConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.endpointConfigs = builder.endpointConfigs;
        this.nextToken = builder.nextToken;
    }

    public List<EndpointConfigSummary> endpointConfigs() {
        return this.endpointConfigs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointConfigsResponse)) {
            return false;
        }
        ListEndpointConfigsResponse other = (ListEndpointConfigsResponse)((Object)obj);
        return Objects.equals(this.endpointConfigs(), other.endpointConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEndpointConfigsResponse").add("EndpointConfigs", this.endpointConfigs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfigs": {
                return Optional.of(clazz.cast(this.endpointConfigs()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<EndpointConfigSummary> endpointConfigs;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointConfigsResponse model) {
            super(model);
            this.endpointConfigs(model.endpointConfigs);
            this.nextToken(model.nextToken);
        }

        public final Collection<EndpointConfigSummary.Builder> getEndpointConfigs() {
            return this.endpointConfigs != null ? (Collection)this.endpointConfigs.stream().map(EndpointConfigSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointConfigs(Collection<EndpointConfigSummary> endpointConfigs) {
            this.endpointConfigs = EndpointConfigSummaryListCopier.copy(endpointConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigs(EndpointConfigSummary ... endpointConfigs) {
            this.endpointConfigs(Arrays.asList(endpointConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigs(Consumer<EndpointConfigSummary.Builder> ... endpointConfigs) {
            this.endpointConfigs(Stream.of(endpointConfigs).map(c -> (EndpointConfigSummary)((EndpointConfigSummary.Builder)EndpointConfigSummary.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointConfigs(Collection<EndpointConfigSummary.BuilderImpl> endpointConfigs) {
            this.endpointConfigs = EndpointConfigSummaryListCopier.copyFromBuilder(endpointConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointConfigsResponse build() {
            return new ListEndpointConfigsResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, ListEndpointConfigsResponse> {
        public Builder endpointConfigs(Collection<EndpointConfigSummary> var1);

        public Builder endpointConfigs(EndpointConfigSummary ... var1);

        public Builder endpointConfigs(Consumer<EndpointConfigSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

