/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DistanceMetric {
    EUCLIDEAN("euclidean"),
    COSINE("cosine"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DistanceMetric> VALUE_MAP;
    private final String value;

    private DistanceMetric(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DistanceMetric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DistanceMetric> knownValues() {
        EnumSet<DistanceMetric> knownValues = EnumSet.allOf(DistanceMetric.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DistanceMetric.class, DistanceMetric::toString);
    }
}

