/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.s3vectors.DefaultS3VectorsClientBuilder;
import software.amazon.awssdk.services.s3vectors.S3VectorsClientBuilder;
import software.amazon.awssdk.services.s3vectors.S3VectorsServiceClientConfiguration;
import software.amazon.awssdk.services.s3vectors.model.AccessDeniedException;
import software.amazon.awssdk.services.s3vectors.model.ConflictException;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.GetIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.GetIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.InternalServerException;
import software.amazon.awssdk.services.s3vectors.model.KmsDisabledException;
import software.amazon.awssdk.services.s3vectors.model.KmsInvalidKeyUsageException;
import software.amazon.awssdk.services.s3vectors.model.KmsInvalidStateException;
import software.amazon.awssdk.services.s3vectors.model.KmsNotFoundException;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.NotFoundException;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsException;
import software.amazon.awssdk.services.s3vectors.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.s3vectors.model.ServiceUnavailableException;
import software.amazon.awssdk.services.s3vectors.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3vectors.model.ValidationException;
import software.amazon.awssdk.services.s3vectors.paginators.ListIndexesIterable;
import software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsIterable;
import software.amazon.awssdk.services.s3vectors.paginators.ListVectorsIterable;

@SdkPublicApi
@ThreadSafe
public interface S3VectorsClient
extends AwsClient {
    public static final String SERVICE_NAME = "s3vectors";
    public static final String SERVICE_METADATA_ID = "s3vectors";

    default public CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ConflictException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public CreateIndexResponse createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ConflictException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.createIndex((CreateIndexRequest)((Object)((CreateIndexRequest.Builder)CreateIndexRequest.builder().applyMutation(createIndexRequest)).build()));
    }

    default public CreateVectorBucketResponse createVectorBucket(CreateVectorBucketRequest createVectorBucketRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public CreateVectorBucketResponse createVectorBucket(Consumer<CreateVectorBucketRequest.Builder> createVectorBucketRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.createVectorBucket((CreateVectorBucketRequest)((Object)((CreateVectorBucketRequest.Builder)CreateVectorBucketRequest.builder().applyMutation(createVectorBucketRequest)).build()));
    }

    default public DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteIndexResponse deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.deleteIndex((DeleteIndexRequest)((Object)((DeleteIndexRequest.Builder)DeleteIndexRequest.builder().applyMutation(deleteIndexRequest)).build()));
    }

    default public DeleteVectorBucketResponse deleteVectorBucket(DeleteVectorBucketRequest deleteVectorBucketRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVectorBucketResponse deleteVectorBucket(Consumer<DeleteVectorBucketRequest.Builder> deleteVectorBucketRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.deleteVectorBucket((DeleteVectorBucketRequest)((Object)((DeleteVectorBucketRequest.Builder)DeleteVectorBucketRequest.builder().applyMutation(deleteVectorBucketRequest)).build()));
    }

    default public DeleteVectorBucketPolicyResponse deleteVectorBucketPolicy(DeleteVectorBucketPolicyRequest deleteVectorBucketPolicyRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVectorBucketPolicyResponse deleteVectorBucketPolicy(Consumer<DeleteVectorBucketPolicyRequest.Builder> deleteVectorBucketPolicyRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.deleteVectorBucketPolicy((DeleteVectorBucketPolicyRequest)((Object)((DeleteVectorBucketPolicyRequest.Builder)DeleteVectorBucketPolicyRequest.builder().applyMutation(deleteVectorBucketPolicyRequest)).build()));
    }

    default public DeleteVectorsResponse deleteVectors(DeleteVectorsRequest deleteVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, NotFoundException, ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteVectorsResponse deleteVectors(Consumer<DeleteVectorsRequest.Builder> deleteVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, NotFoundException, ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.deleteVectors((DeleteVectorsRequest)((Object)((DeleteVectorsRequest.Builder)DeleteVectorsRequest.builder().applyMutation(deleteVectorsRequest)).build()));
    }

    default public GetIndexResponse getIndex(GetIndexRequest getIndexRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public GetIndexResponse getIndex(Consumer<GetIndexRequest.Builder> getIndexRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.getIndex((GetIndexRequest)((Object)((GetIndexRequest.Builder)GetIndexRequest.builder().applyMutation(getIndexRequest)).build()));
    }

    default public GetVectorBucketResponse getVectorBucket(GetVectorBucketRequest getVectorBucketRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public GetVectorBucketResponse getVectorBucket(Consumer<GetVectorBucketRequest.Builder> getVectorBucketRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.getVectorBucket((GetVectorBucketRequest)((Object)((GetVectorBucketRequest.Builder)GetVectorBucketRequest.builder().applyMutation(getVectorBucketRequest)).build()));
    }

    default public GetVectorBucketPolicyResponse getVectorBucketPolicy(GetVectorBucketPolicyRequest getVectorBucketPolicyRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public GetVectorBucketPolicyResponse getVectorBucketPolicy(Consumer<GetVectorBucketPolicyRequest.Builder> getVectorBucketPolicyRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.getVectorBucketPolicy((GetVectorBucketPolicyRequest)((Object)((GetVectorBucketPolicyRequest.Builder)GetVectorBucketPolicyRequest.builder().applyMutation(getVectorBucketPolicyRequest)).build()));
    }

    default public GetVectorsResponse getVectors(GetVectorsRequest getVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, NotFoundException, ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public GetVectorsResponse getVectors(Consumer<GetVectorsRequest.Builder> getVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, NotFoundException, ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.getVectors((GetVectorsRequest)((Object)((GetVectorsRequest.Builder)GetVectorsRequest.builder().applyMutation(getVectorsRequest)).build()));
    }

    default public ListIndexesResponse listIndexes(ListIndexesRequest listIndexesRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public ListIndexesResponse listIndexes(Consumer<ListIndexesRequest.Builder> listIndexesRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.listIndexes((ListIndexesRequest)((Object)((ListIndexesRequest.Builder)ListIndexesRequest.builder().applyMutation(listIndexesRequest)).build()));
    }

    default public ListIndexesIterable listIndexesPaginator(ListIndexesRequest listIndexesRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return new ListIndexesIterable(this, listIndexesRequest);
    }

    default public ListIndexesIterable listIndexesPaginator(Consumer<ListIndexesRequest.Builder> listIndexesRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.listIndexesPaginator((ListIndexesRequest)((Object)((ListIndexesRequest.Builder)ListIndexesRequest.builder().applyMutation(listIndexesRequest)).build()));
    }

    default public ListVectorBucketsResponse listVectorBuckets(ListVectorBucketsRequest listVectorBucketsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public ListVectorBucketsResponse listVectorBuckets(Consumer<ListVectorBucketsRequest.Builder> listVectorBucketsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.listVectorBuckets((ListVectorBucketsRequest)((Object)((ListVectorBucketsRequest.Builder)ListVectorBucketsRequest.builder().applyMutation(listVectorBucketsRequest)).build()));
    }

    default public ListVectorBucketsIterable listVectorBucketsPaginator(ListVectorBucketsRequest listVectorBucketsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return new ListVectorBucketsIterable(this, listVectorBucketsRequest);
    }

    default public ListVectorBucketsIterable listVectorBucketsPaginator(Consumer<ListVectorBucketsRequest.Builder> listVectorBucketsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.listVectorBucketsPaginator((ListVectorBucketsRequest)((Object)((ListVectorBucketsRequest.Builder)ListVectorBucketsRequest.builder().applyMutation(listVectorBucketsRequest)).build()));
    }

    default public ListVectorsResponse listVectors(ListVectorsRequest listVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public ListVectorsResponse listVectors(Consumer<ListVectorsRequest.Builder> listVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.listVectors((ListVectorsRequest)((Object)((ListVectorsRequest.Builder)ListVectorsRequest.builder().applyMutation(listVectorsRequest)).build()));
    }

    default public ListVectorsIterable listVectorsPaginator(ListVectorsRequest listVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return new ListVectorsIterable(this, listVectorsRequest);
    }

    default public ListVectorsIterable listVectorsPaginator(Consumer<ListVectorsRequest.Builder> listVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.listVectorsPaginator((ListVectorsRequest)((Object)((ListVectorsRequest.Builder)ListVectorsRequest.builder().applyMutation(listVectorsRequest)).build()));
    }

    default public PutVectorBucketPolicyResponse putVectorBucketPolicy(PutVectorBucketPolicyRequest putVectorBucketPolicyRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public PutVectorBucketPolicyResponse putVectorBucketPolicy(Consumer<PutVectorBucketPolicyRequest.Builder> putVectorBucketPolicyRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.putVectorBucketPolicy((PutVectorBucketPolicyRequest)((Object)((PutVectorBucketPolicyRequest.Builder)PutVectorBucketPolicyRequest.builder().applyMutation(putVectorBucketPolicyRequest)).build()));
    }

    default public PutVectorsResponse putVectors(PutVectorsRequest putVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, NotFoundException, ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public PutVectorsResponse putVectors(Consumer<PutVectorsRequest.Builder> putVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, NotFoundException, ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.putVectors((PutVectorsRequest)((Object)((PutVectorsRequest.Builder)PutVectorsRequest.builder().applyMutation(putVectorsRequest)).build()));
    }

    default public QueryVectorsResponse queryVectors(QueryVectorsRequest queryVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, NotFoundException, ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    default public QueryVectorsResponse queryVectors(Consumer<QueryVectorsRequest.Builder> queryVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, NotFoundException, ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        return this.queryVectors((QueryVectorsRequest)((Object)((QueryVectorsRequest.Builder)QueryVectorsRequest.builder().applyMutation(queryVectorsRequest)).build()));
    }

    public static S3VectorsClient create() {
        return (S3VectorsClient)S3VectorsClient.builder().build();
    }

    public static S3VectorsClientBuilder builder() {
        return new DefaultS3VectorsClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"s3vectors");
    }

    default public S3VectorsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

