/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3tables.S3TablesAsyncClient;
import software.amazon.awssdk.services.s3tables.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest;
import software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse;
import software.amazon.awssdk.services.s3tables.model.TableBucketSummary;

public class ListTableBucketsPublisher
implements SdkPublisher<ListTableBucketsResponse> {
    private final S3TablesAsyncClient client;
    private final ListTableBucketsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTableBucketsPublisher(S3TablesAsyncClient client, ListTableBucketsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTableBucketsPublisher(S3TablesAsyncClient client, ListTableBucketsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTableBucketsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTableBucketsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TableBucketSummary> tableBuckets() {
        Function<ListTableBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableBuckets() != null) {
                return response.tableBuckets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTableBucketsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTableBucketsResponseFetcher
    implements AsyncPageFetcher<ListTableBucketsResponse> {
        private ListTableBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListTableBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.continuationToken());
        }

        public CompletableFuture<ListTableBucketsResponse> nextPage(ListTableBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListTableBucketsPublisher.this.client.listTableBuckets(ListTableBucketsPublisher.this.firstRequest);
            }
            return ListTableBucketsPublisher.this.client.listTableBuckets((ListTableBucketsRequest)((Object)ListTableBucketsPublisher.this.firstRequest.toBuilder().continuationToken(previousPage.continuationToken()).build()));
        }
    }
}

