/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergSnapshotManagementSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergSnapshotManagementSettings> {
    private static final SdkField<Integer> MIN_SNAPSHOTS_TO_KEEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minSnapshotsToKeep").getter(IcebergSnapshotManagementSettings.getter(IcebergSnapshotManagementSettings::minSnapshotsToKeep)).setter(IcebergSnapshotManagementSettings.setter(Builder::minSnapshotsToKeep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSnapshotsToKeep").build()}).build();
    private static final SdkField<Integer> MAX_SNAPSHOT_AGE_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxSnapshotAgeHours").getter(IcebergSnapshotManagementSettings.getter(IcebergSnapshotManagementSettings::maxSnapshotAgeHours)).setter(IcebergSnapshotManagementSettings.setter(Builder::maxSnapshotAgeHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSnapshotAgeHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_SNAPSHOTS_TO_KEEP_FIELD, MAX_SNAPSHOT_AGE_HOURS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergSnapshotManagementSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer minSnapshotsToKeep;
    private final Integer maxSnapshotAgeHours;

    private IcebergSnapshotManagementSettings(BuilderImpl builder) {
        this.minSnapshotsToKeep = builder.minSnapshotsToKeep;
        this.maxSnapshotAgeHours = builder.maxSnapshotAgeHours;
    }

    public final Integer minSnapshotsToKeep() {
        return this.minSnapshotsToKeep;
    }

    public final Integer maxSnapshotAgeHours() {
        return this.maxSnapshotAgeHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minSnapshotsToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSnapshotAgeHours());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergSnapshotManagementSettings)) {
            return false;
        }
        IcebergSnapshotManagementSettings other = (IcebergSnapshotManagementSettings)obj;
        return Objects.equals(this.minSnapshotsToKeep(), other.minSnapshotsToKeep()) && Objects.equals(this.maxSnapshotAgeHours(), other.maxSnapshotAgeHours());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergSnapshotManagementSettings").add("MinSnapshotsToKeep", (Object)this.minSnapshotsToKeep()).add("MaxSnapshotAgeHours", (Object)this.maxSnapshotAgeHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "minSnapshotsToKeep": {
                return Optional.ofNullable(clazz.cast(this.minSnapshotsToKeep()));
            }
            case "maxSnapshotAgeHours": {
                return Optional.ofNullable(clazz.cast(this.maxSnapshotAgeHours()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("minSnapshotsToKeep", MIN_SNAPSHOTS_TO_KEEP_FIELD);
        map.put("maxSnapshotAgeHours", MAX_SNAPSHOT_AGE_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergSnapshotManagementSettings, T> g) {
        return obj -> g.apply((IcebergSnapshotManagementSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minSnapshotsToKeep;
        private Integer maxSnapshotAgeHours;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergSnapshotManagementSettings model) {
            this.minSnapshotsToKeep(model.minSnapshotsToKeep);
            this.maxSnapshotAgeHours(model.maxSnapshotAgeHours);
        }

        public final Integer getMinSnapshotsToKeep() {
            return this.minSnapshotsToKeep;
        }

        public final void setMinSnapshotsToKeep(Integer minSnapshotsToKeep) {
            this.minSnapshotsToKeep = minSnapshotsToKeep;
        }

        @Override
        public final Builder minSnapshotsToKeep(Integer minSnapshotsToKeep) {
            this.minSnapshotsToKeep = minSnapshotsToKeep;
            return this;
        }

        public final Integer getMaxSnapshotAgeHours() {
            return this.maxSnapshotAgeHours;
        }

        public final void setMaxSnapshotAgeHours(Integer maxSnapshotAgeHours) {
            this.maxSnapshotAgeHours = maxSnapshotAgeHours;
        }

        @Override
        public final Builder maxSnapshotAgeHours(Integer maxSnapshotAgeHours) {
            this.maxSnapshotAgeHours = maxSnapshotAgeHours;
            return this;
        }

        public IcebergSnapshotManagementSettings build() {
            return new IcebergSnapshotManagementSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergSnapshotManagementSettings> {
        public Builder minSnapshotsToKeep(Integer var1);

        public Builder maxSnapshotAgeHours(Integer var1);
    }
}

