/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.s3control.DefaultS3ControlClientBuilder;
import software.amazon.awssdk.services.s3control.S3ControlClientBuilder;
import software.amazon.awssdk.services.s3control.model.BadRequestException;
import software.amazon.awssdk.services.s3control.model.CreateJobRequest;
import software.amazon.awssdk.services.s3control.model.CreateJobResponse;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.DescribeJobRequest;
import software.amazon.awssdk.services.s3control.model.DescribeJobResponse;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.IdempotencyException;
import software.amazon.awssdk.services.s3control.model.InternalServiceException;
import software.amazon.awssdk.services.s3control.model.InvalidNextTokenException;
import software.amazon.awssdk.services.s3control.model.InvalidRequestException;
import software.amazon.awssdk.services.s3control.model.JobStatusException;
import software.amazon.awssdk.services.s3control.model.ListJobsRequest;
import software.amazon.awssdk.services.s3control.model.ListJobsResponse;
import software.amazon.awssdk.services.s3control.model.NoSuchPublicAccessBlockConfigurationException;
import software.amazon.awssdk.services.s3control.model.NotFoundException;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.S3ControlException;
import software.amazon.awssdk.services.s3control.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse;
import software.amazon.awssdk.services.s3control.paginators.ListJobsIterable;

public interface S3ControlClient
extends SdkClient {
    public static final String SERVICE_NAME = "s3";

    public static S3ControlClient create() {
        return (S3ControlClient)S3ControlClient.builder().build();
    }

    public static S3ControlClientBuilder builder() {
        return new DefaultS3ControlClientBuilder();
    }

    default public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws TooManyRequestsException, BadRequestException, IdempotencyException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        throw new UnsupportedOperationException();
    }

    default public CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws TooManyRequestsException, BadRequestException, IdempotencyException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        return this.createJob((CreateJobRequest)((Object)((CreateJobRequest.Builder)CreateJobRequest.builder().applyMutation(createJobRequest)).build()));
    }

    default public DeletePublicAccessBlockResponse deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        throw new UnsupportedOperationException();
    }

    default public DeletePublicAccessBlockResponse deletePublicAccessBlock(Consumer<DeletePublicAccessBlockRequest.Builder> deletePublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return this.deletePublicAccessBlock((DeletePublicAccessBlockRequest)((Object)((DeletePublicAccessBlockRequest.Builder)DeletePublicAccessBlockRequest.builder().applyMutation(deletePublicAccessBlockRequest)).build()));
    }

    default public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        throw new UnsupportedOperationException();
    }

    default public DescribeJobResponse describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        return this.describeJob((DescribeJobRequest)((Object)((DescribeJobRequest.Builder)DescribeJobRequest.builder().applyMutation(describeJobRequest)).build()));
    }

    default public GetPublicAccessBlockResponse getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) throws NoSuchPublicAccessBlockConfigurationException, AwsServiceException, SdkClientException, S3ControlException {
        throw new UnsupportedOperationException();
    }

    default public GetPublicAccessBlockResponse getPublicAccessBlock(Consumer<GetPublicAccessBlockRequest.Builder> getPublicAccessBlockRequest) throws NoSuchPublicAccessBlockConfigurationException, AwsServiceException, SdkClientException, S3ControlException {
        return this.getPublicAccessBlock((GetPublicAccessBlockRequest)((Object)((GetPublicAccessBlockRequest.Builder)GetPublicAccessBlockRequest.builder().applyMutation(getPublicAccessBlockRequest)).build()));
    }

    default public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        throw new UnsupportedOperationException();
    }

    default public ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        return this.listJobs((ListJobsRequest)((Object)((ListJobsRequest.Builder)ListJobsRequest.builder().applyMutation(listJobsRequest)).build()));
    }

    default public ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        throw new UnsupportedOperationException();
    }

    default public ListJobsIterable listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        return this.listJobsPaginator((ListJobsRequest)((Object)((ListJobsRequest.Builder)ListJobsRequest.builder().applyMutation(listJobsRequest)).build()));
    }

    default public PutPublicAccessBlockResponse putPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        throw new UnsupportedOperationException();
    }

    default public PutPublicAccessBlockResponse putPublicAccessBlock(Consumer<PutPublicAccessBlockRequest.Builder> putPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return this.putPublicAccessBlock((PutPublicAccessBlockRequest)((Object)((PutPublicAccessBlockRequest.Builder)PutPublicAccessBlockRequest.builder().applyMutation(putPublicAccessBlockRequest)).build()));
    }

    default public UpdateJobPriorityResponse updateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        throw new UnsupportedOperationException();
    }

    default public UpdateJobPriorityResponse updateJobPriority(Consumer<UpdateJobPriorityRequest.Builder> updateJobPriorityRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        return this.updateJobPriority((UpdateJobPriorityRequest)((Object)((UpdateJobPriorityRequest.Builder)UpdateJobPriorityRequest.builder().applyMutation(updateJobPriorityRequest)).build()));
    }

    default public UpdateJobStatusResponse updateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, JobStatusException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        throw new UnsupportedOperationException();
    }

    default public UpdateJobStatusResponse updateJobStatus(Consumer<UpdateJobStatusRequest.Builder> updateJobStatusRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, JobStatusException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        return this.updateJobStatus((UpdateJobStatusRequest)((Object)((UpdateJobStatusRequest.Builder)UpdateJobStatusRequest.builder().applyMutation(updateJobStatusRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"s3-control");
    }
}

