/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.ActivityMetrics;
import software.amazon.awssdk.services.s3control.model.AdvancedCostOptimizationMetrics;
import software.amazon.awssdk.services.s3control.model.AdvancedDataProtectionMetrics;
import software.amazon.awssdk.services.s3control.model.AdvancedPerformanceMetrics;
import software.amazon.awssdk.services.s3control.model.DetailedStatusCodesMetrics;
import software.amazon.awssdk.services.s3control.model.PrefixLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketLevel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketLevel> {
    private static final SdkField<ActivityMetrics> ACTIVITY_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActivityMetrics").getter(BucketLevel.getter(BucketLevel::activityMetrics)).setter(BucketLevel.setter(Builder::activityMetrics)).constructor(ActivityMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityMetrics").unmarshallLocationName("ActivityMetrics").build()}).build();
    private static final SdkField<PrefixLevel> PREFIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrefixLevel").getter(BucketLevel.getter(BucketLevel::prefixLevel)).setter(BucketLevel.setter(Builder::prefixLevel)).constructor(PrefixLevel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixLevel").unmarshallLocationName("PrefixLevel").build()}).build();
    private static final SdkField<AdvancedCostOptimizationMetrics> ADVANCED_COST_OPTIMIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedCostOptimizationMetrics").getter(BucketLevel.getter(BucketLevel::advancedCostOptimizationMetrics)).setter(BucketLevel.setter(Builder::advancedCostOptimizationMetrics)).constructor(AdvancedCostOptimizationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedCostOptimizationMetrics").unmarshallLocationName("AdvancedCostOptimizationMetrics").build()}).build();
    private static final SdkField<AdvancedDataProtectionMetrics> ADVANCED_DATA_PROTECTION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedDataProtectionMetrics").getter(BucketLevel.getter(BucketLevel::advancedDataProtectionMetrics)).setter(BucketLevel.setter(Builder::advancedDataProtectionMetrics)).constructor(AdvancedDataProtectionMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedDataProtectionMetrics").unmarshallLocationName("AdvancedDataProtectionMetrics").build()}).build();
    private static final SdkField<DetailedStatusCodesMetrics> DETAILED_STATUS_CODES_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetailedStatusCodesMetrics").getter(BucketLevel.getter(BucketLevel::detailedStatusCodesMetrics)).setter(BucketLevel.setter(Builder::detailedStatusCodesMetrics)).constructor(DetailedStatusCodesMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatusCodesMetrics").unmarshallLocationName("DetailedStatusCodesMetrics").build()}).build();
    private static final SdkField<AdvancedPerformanceMetrics> ADVANCED_PERFORMANCE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedPerformanceMetrics").getter(BucketLevel.getter(BucketLevel::advancedPerformanceMetrics)).setter(BucketLevel.setter(Builder::advancedPerformanceMetrics)).constructor(AdvancedPerformanceMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedPerformanceMetrics").unmarshallLocationName("AdvancedPerformanceMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_METRICS_FIELD, PREFIX_LEVEL_FIELD, ADVANCED_COST_OPTIMIZATION_METRICS_FIELD, ADVANCED_DATA_PROTECTION_METRICS_FIELD, DETAILED_STATUS_CODES_METRICS_FIELD, ADVANCED_PERFORMANCE_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BucketLevel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ActivityMetrics activityMetrics;
    private final PrefixLevel prefixLevel;
    private final AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics;
    private final AdvancedDataProtectionMetrics advancedDataProtectionMetrics;
    private final DetailedStatusCodesMetrics detailedStatusCodesMetrics;
    private final AdvancedPerformanceMetrics advancedPerformanceMetrics;

    private BucketLevel(BuilderImpl builder) {
        this.activityMetrics = builder.activityMetrics;
        this.prefixLevel = builder.prefixLevel;
        this.advancedCostOptimizationMetrics = builder.advancedCostOptimizationMetrics;
        this.advancedDataProtectionMetrics = builder.advancedDataProtectionMetrics;
        this.detailedStatusCodesMetrics = builder.detailedStatusCodesMetrics;
        this.advancedPerformanceMetrics = builder.advancedPerformanceMetrics;
    }

    public final ActivityMetrics activityMetrics() {
        return this.activityMetrics;
    }

    public final PrefixLevel prefixLevel() {
        return this.prefixLevel;
    }

    public final AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics() {
        return this.advancedCostOptimizationMetrics;
    }

    public final AdvancedDataProtectionMetrics advancedDataProtectionMetrics() {
        return this.advancedDataProtectionMetrics;
    }

    public final DetailedStatusCodesMetrics detailedStatusCodesMetrics() {
        return this.detailedStatusCodesMetrics;
    }

    public final AdvancedPerformanceMetrics advancedPerformanceMetrics() {
        return this.advancedPerformanceMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedCostOptimizationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedDataProtectionMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatusCodesMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedPerformanceMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketLevel)) {
            return false;
        }
        BucketLevel other = (BucketLevel)obj;
        return Objects.equals(this.activityMetrics(), other.activityMetrics()) && Objects.equals(this.prefixLevel(), other.prefixLevel()) && Objects.equals(this.advancedCostOptimizationMetrics(), other.advancedCostOptimizationMetrics()) && Objects.equals(this.advancedDataProtectionMetrics(), other.advancedDataProtectionMetrics()) && Objects.equals(this.detailedStatusCodesMetrics(), other.detailedStatusCodesMetrics()) && Objects.equals(this.advancedPerformanceMetrics(), other.advancedPerformanceMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"BucketLevel").add("ActivityMetrics", (Object)this.activityMetrics()).add("PrefixLevel", (Object)this.prefixLevel()).add("AdvancedCostOptimizationMetrics", (Object)this.advancedCostOptimizationMetrics()).add("AdvancedDataProtectionMetrics", (Object)this.advancedDataProtectionMetrics()).add("DetailedStatusCodesMetrics", (Object)this.detailedStatusCodesMetrics()).add("AdvancedPerformanceMetrics", (Object)this.advancedPerformanceMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityMetrics": {
                return Optional.ofNullable(clazz.cast(this.activityMetrics()));
            }
            case "PrefixLevel": {
                return Optional.ofNullable(clazz.cast(this.prefixLevel()));
            }
            case "AdvancedCostOptimizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.advancedCostOptimizationMetrics()));
            }
            case "AdvancedDataProtectionMetrics": {
                return Optional.ofNullable(clazz.cast(this.advancedDataProtectionMetrics()));
            }
            case "DetailedStatusCodesMetrics": {
                return Optional.ofNullable(clazz.cast(this.detailedStatusCodesMetrics()));
            }
            case "AdvancedPerformanceMetrics": {
                return Optional.ofNullable(clazz.cast(this.advancedPerformanceMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActivityMetrics", ACTIVITY_METRICS_FIELD);
        map.put("PrefixLevel", PREFIX_LEVEL_FIELD);
        map.put("AdvancedCostOptimizationMetrics", ADVANCED_COST_OPTIMIZATION_METRICS_FIELD);
        map.put("AdvancedDataProtectionMetrics", ADVANCED_DATA_PROTECTION_METRICS_FIELD);
        map.put("DetailedStatusCodesMetrics", DETAILED_STATUS_CODES_METRICS_FIELD);
        map.put("AdvancedPerformanceMetrics", ADVANCED_PERFORMANCE_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BucketLevel, T> g) {
        return obj -> g.apply((BucketLevel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActivityMetrics activityMetrics;
        private PrefixLevel prefixLevel;
        private AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics;
        private AdvancedDataProtectionMetrics advancedDataProtectionMetrics;
        private DetailedStatusCodesMetrics detailedStatusCodesMetrics;
        private AdvancedPerformanceMetrics advancedPerformanceMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketLevel model) {
            this.activityMetrics(model.activityMetrics);
            this.prefixLevel(model.prefixLevel);
            this.advancedCostOptimizationMetrics(model.advancedCostOptimizationMetrics);
            this.advancedDataProtectionMetrics(model.advancedDataProtectionMetrics);
            this.detailedStatusCodesMetrics(model.detailedStatusCodesMetrics);
            this.advancedPerformanceMetrics(model.advancedPerformanceMetrics);
        }

        public final ActivityMetrics.Builder getActivityMetrics() {
            return this.activityMetrics != null ? this.activityMetrics.toBuilder() : null;
        }

        public final void setActivityMetrics(ActivityMetrics.BuilderImpl activityMetrics) {
            this.activityMetrics = activityMetrics != null ? activityMetrics.build() : null;
        }

        @Override
        public final Builder activityMetrics(ActivityMetrics activityMetrics) {
            this.activityMetrics = activityMetrics;
            return this;
        }

        public final PrefixLevel.Builder getPrefixLevel() {
            return this.prefixLevel != null ? this.prefixLevel.toBuilder() : null;
        }

        public final void setPrefixLevel(PrefixLevel.BuilderImpl prefixLevel) {
            this.prefixLevel = prefixLevel != null ? prefixLevel.build() : null;
        }

        @Override
        public final Builder prefixLevel(PrefixLevel prefixLevel) {
            this.prefixLevel = prefixLevel;
            return this;
        }

        public final AdvancedCostOptimizationMetrics.Builder getAdvancedCostOptimizationMetrics() {
            return this.advancedCostOptimizationMetrics != null ? this.advancedCostOptimizationMetrics.toBuilder() : null;
        }

        public final void setAdvancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics.BuilderImpl advancedCostOptimizationMetrics) {
            this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics != null ? advancedCostOptimizationMetrics.build() : null;
        }

        @Override
        public final Builder advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics) {
            this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics;
            return this;
        }

        public final AdvancedDataProtectionMetrics.Builder getAdvancedDataProtectionMetrics() {
            return this.advancedDataProtectionMetrics != null ? this.advancedDataProtectionMetrics.toBuilder() : null;
        }

        public final void setAdvancedDataProtectionMetrics(AdvancedDataProtectionMetrics.BuilderImpl advancedDataProtectionMetrics) {
            this.advancedDataProtectionMetrics = advancedDataProtectionMetrics != null ? advancedDataProtectionMetrics.build() : null;
        }

        @Override
        public final Builder advancedDataProtectionMetrics(AdvancedDataProtectionMetrics advancedDataProtectionMetrics) {
            this.advancedDataProtectionMetrics = advancedDataProtectionMetrics;
            return this;
        }

        public final DetailedStatusCodesMetrics.Builder getDetailedStatusCodesMetrics() {
            return this.detailedStatusCodesMetrics != null ? this.detailedStatusCodesMetrics.toBuilder() : null;
        }

        public final void setDetailedStatusCodesMetrics(DetailedStatusCodesMetrics.BuilderImpl detailedStatusCodesMetrics) {
            this.detailedStatusCodesMetrics = detailedStatusCodesMetrics != null ? detailedStatusCodesMetrics.build() : null;
        }

        @Override
        public final Builder detailedStatusCodesMetrics(DetailedStatusCodesMetrics detailedStatusCodesMetrics) {
            this.detailedStatusCodesMetrics = detailedStatusCodesMetrics;
            return this;
        }

        public final AdvancedPerformanceMetrics.Builder getAdvancedPerformanceMetrics() {
            return this.advancedPerformanceMetrics != null ? this.advancedPerformanceMetrics.toBuilder() : null;
        }

        public final void setAdvancedPerformanceMetrics(AdvancedPerformanceMetrics.BuilderImpl advancedPerformanceMetrics) {
            this.advancedPerformanceMetrics = advancedPerformanceMetrics != null ? advancedPerformanceMetrics.build() : null;
        }

        @Override
        public final Builder advancedPerformanceMetrics(AdvancedPerformanceMetrics advancedPerformanceMetrics) {
            this.advancedPerformanceMetrics = advancedPerformanceMetrics;
            return this;
        }

        public BucketLevel build() {
            return new BucketLevel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketLevel> {
        public Builder activityMetrics(ActivityMetrics var1);

        default public Builder activityMetrics(Consumer<ActivityMetrics.Builder> activityMetrics) {
            return this.activityMetrics((ActivityMetrics)((ActivityMetrics.Builder)ActivityMetrics.builder().applyMutation(activityMetrics)).build());
        }

        public Builder prefixLevel(PrefixLevel var1);

        default public Builder prefixLevel(Consumer<PrefixLevel.Builder> prefixLevel) {
            return this.prefixLevel((PrefixLevel)((PrefixLevel.Builder)PrefixLevel.builder().applyMutation(prefixLevel)).build());
        }

        public Builder advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics var1);

        default public Builder advancedCostOptimizationMetrics(Consumer<AdvancedCostOptimizationMetrics.Builder> advancedCostOptimizationMetrics) {
            return this.advancedCostOptimizationMetrics((AdvancedCostOptimizationMetrics)((AdvancedCostOptimizationMetrics.Builder)AdvancedCostOptimizationMetrics.builder().applyMutation(advancedCostOptimizationMetrics)).build());
        }

        public Builder advancedDataProtectionMetrics(AdvancedDataProtectionMetrics var1);

        default public Builder advancedDataProtectionMetrics(Consumer<AdvancedDataProtectionMetrics.Builder> advancedDataProtectionMetrics) {
            return this.advancedDataProtectionMetrics((AdvancedDataProtectionMetrics)((AdvancedDataProtectionMetrics.Builder)AdvancedDataProtectionMetrics.builder().applyMutation(advancedDataProtectionMetrics)).build());
        }

        public Builder detailedStatusCodesMetrics(DetailedStatusCodesMetrics var1);

        default public Builder detailedStatusCodesMetrics(Consumer<DetailedStatusCodesMetrics.Builder> detailedStatusCodesMetrics) {
            return this.detailedStatusCodesMetrics((DetailedStatusCodesMetrics)((DetailedStatusCodesMetrics.Builder)DetailedStatusCodesMetrics.builder().applyMutation(detailedStatusCodesMetrics)).build());
        }

        public Builder advancedPerformanceMetrics(AdvancedPerformanceMetrics var1);

        default public Builder advancedPerformanceMetrics(Consumer<AdvancedPerformanceMetrics.Builder> advancedPerformanceMetrics) {
            return this.advancedPerformanceMetrics((AdvancedPerformanceMetrics)((AdvancedPerformanceMetrics.Builder)AdvancedPerformanceMetrics.builder().applyMutation(advancedPerformanceMetrics)).build());
        }
    }
}

