/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.AccessPoint;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForDirectoryBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForDirectoryBucketsResponse;

public class ListAccessPointsForDirectoryBucketsIterable
implements SdkIterable<ListAccessPointsForDirectoryBucketsResponse> {
    private final S3ControlClient client;
    private final ListAccessPointsForDirectoryBucketsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessPointsForDirectoryBucketsIterable(S3ControlClient client, ListAccessPointsForDirectoryBucketsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessPointsForDirectoryBucketsResponseFetcher();
    }

    public Iterator<ListAccessPointsForDirectoryBucketsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessPoint> accessPointList() {
        Function<ListAccessPointsForDirectoryBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessPointList() != null) {
                return response.accessPointList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessPointsForDirectoryBucketsResponseFetcher
    implements SyncPageFetcher<ListAccessPointsForDirectoryBucketsResponse> {
        private ListAccessPointsForDirectoryBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPointsForDirectoryBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessPointsForDirectoryBucketsResponse nextPage(ListAccessPointsForDirectoryBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPointsForDirectoryBucketsIterable.this.client.listAccessPointsForDirectoryBuckets(ListAccessPointsForDirectoryBucketsIterable.this.firstRequest);
            }
            return ListAccessPointsForDirectoryBucketsIterable.this.client.listAccessPointsForDirectoryBuckets((ListAccessPointsForDirectoryBucketsRequest)((Object)ListAccessPointsForDirectoryBucketsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

