/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.PrefixesListCopier;
import software.amazon.awssdk.services.s3control.model.ScopePermission;
import software.amazon.awssdk.services.s3control.model.ScopePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Scope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Scope> {
    private static final SdkField<List<String>> PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Prefixes").getter(Scope.getter(Scope::prefixes)).setter(Scope.setter(Builder::prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefixes").unmarshallLocationName("Prefixes").build(), ListTrait.builder().memberLocationName("Prefix").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("Prefix").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(Scope.getter(Scope::permissionsAsStrings)).setter(Scope.setter(Builder::permissionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").unmarshallLocationName("Permissions").build(), ListTrait.builder().memberLocationName("Permission").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").unmarshallLocationName("Permission").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIXES_FIELD, PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Scope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> prefixes;
    private final List<String> permissions;

    private Scope(BuilderImpl builder) {
        this.prefixes = builder.prefixes;
        this.permissions = builder.permissions;
    }

    public final boolean hasPrefixes() {
        return this.prefixes != null && !(this.prefixes instanceof SdkAutoConstructList);
    }

    public final List<String> prefixes() {
        return this.prefixes;
    }

    public final List<ScopePermission> permissions() {
        return ScopePermissionListCopier.copyStringToEnum(this.permissions);
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissionsAsStrings() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrefixes() ? this.prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)obj;
        return this.hasPrefixes() == other.hasPrefixes() && Objects.equals(this.prefixes(), other.prefixes()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissionsAsStrings(), other.permissionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Scope").add("Prefixes", this.hasPrefixes() ? this.prefixes() : null).add("Permissions", this.hasPermissions() ? this.permissionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Prefixes": {
                return Optional.ofNullable(clazz.cast(this.prefixes()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Prefixes", PREFIXES_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Scope, T> g) {
        return obj -> g.apply((Scope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> prefixes = DefaultSdkAutoConstructList.getInstance();
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Scope model) {
            this.prefixes(model.prefixes);
            this.permissionsWithStrings(model.permissions);
        }

        public final Collection<String> getPrefixes() {
            if (this.prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.prefixes;
        }

        public final void setPrefixes(Collection<String> prefixes) {
            this.prefixes = PrefixesListCopier.copy(prefixes);
        }

        @Override
        public final Builder prefixes(Collection<String> prefixes) {
            this.prefixes = PrefixesListCopier.copy(prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixes(String ... prefixes) {
            this.prefixes(Arrays.asList(prefixes));
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = ScopePermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = ScopePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String ... permissions) {
            this.permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<ScopePermission> permissions) {
            this.permissions = ScopePermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ScopePermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public Scope build() {
            return new Scope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Scope> {
        public Builder prefixes(Collection<String> var1);

        public Builder prefixes(String ... var1);

        public Builder permissionsWithStrings(Collection<String> var1);

        public Builder permissionsWithStrings(String ... var1);

        public Builder permissions(Collection<ScopePermission> var1);

        public Builder permissions(ScopePermission ... var1);
    }
}

