/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.Permission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCallerAccessGrantsEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListCallerAccessGrantsEntry> {
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Permission").getter(ListCallerAccessGrantsEntry.getter(ListCallerAccessGrantsEntry::permissionAsString)).setter(ListCallerAccessGrantsEntry.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").unmarshallLocationName("Permission").build()}).build();
    private static final SdkField<String> GRANT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantScope").getter(ListCallerAccessGrantsEntry.getter(ListCallerAccessGrantsEntry::grantScope)).setter(ListCallerAccessGrantsEntry.setter(Builder::grantScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantScope").unmarshallLocationName("GrantScope").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(ListCallerAccessGrantsEntry.getter(ListCallerAccessGrantsEntry::applicationArn)).setter(ListCallerAccessGrantsEntry.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").unmarshallLocationName("ApplicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_FIELD, GRANT_SCOPE_FIELD, APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Permission", PERMISSION_FIELD);
            this.put("GrantScope", GRANT_SCOPE_FIELD);
            this.put("ApplicationArn", APPLICATION_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String permission;
    private final String grantScope;
    private final String applicationArn;

    private ListCallerAccessGrantsEntry(BuilderImpl builder) {
        this.permission = builder.permission;
        this.grantScope = builder.grantScope;
        this.applicationArn = builder.applicationArn;
    }

    public final Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final String grantScope() {
        return this.grantScope;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCallerAccessGrantsEntry)) {
            return false;
        }
        ListCallerAccessGrantsEntry other = (ListCallerAccessGrantsEntry)obj;
        return Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.grantScope(), other.grantScope()) && Objects.equals(this.applicationArn(), other.applicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"ListCallerAccessGrantsEntry").add("Permission", (Object)this.permissionAsString()).add("GrantScope", (Object)this.grantScope()).add("ApplicationArn", (Object)this.applicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "GrantScope": {
                return Optional.ofNullable(clazz.cast(this.grantScope()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCallerAccessGrantsEntry, T> g) {
        return obj -> g.apply((ListCallerAccessGrantsEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String permission;
        private String grantScope;
        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCallerAccessGrantsEntry model) {
            this.permission(model.permission);
            this.grantScope(model.grantScope);
            this.applicationArn(model.applicationArn);
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final String getGrantScope() {
            return this.grantScope;
        }

        public final void setGrantScope(String grantScope) {
            this.grantScope = grantScope;
        }

        @Override
        public final Builder grantScope(String grantScope) {
            this.grantScope = grantScope;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public ListCallerAccessGrantsEntry build() {
            return new ListCallerAccessGrantsEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListCallerAccessGrantsEntry> {
        public Builder permission(String var1);

        public Builder permission(Permission var1);

        public Builder grantScope(String var1);

        public Builder applicationArn(String var1);
    }
}

