/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessGrantsInstanceForPrefixResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, GetAccessGrantsInstanceForPrefixResponse> {
    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantsInstanceArn").getter(GetAccessGrantsInstanceForPrefixResponse.getter(GetAccessGrantsInstanceForPrefixResponse::accessGrantsInstanceArn)).setter(GetAccessGrantsInstanceForPrefixResponse.setter(Builder::accessGrantsInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceArn").unmarshallLocationName("AccessGrantsInstanceArn").build()}).build();
    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantsInstanceId").getter(GetAccessGrantsInstanceForPrefixResponse.getter(GetAccessGrantsInstanceForPrefixResponse::accessGrantsInstanceId)).setter(GetAccessGrantsInstanceForPrefixResponse.setter(Builder::accessGrantsInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceId").unmarshallLocationName("AccessGrantsInstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_GRANTS_INSTANCE_ARN_FIELD, ACCESS_GRANTS_INSTANCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccessGrantsInstanceArn", ACCESS_GRANTS_INSTANCE_ARN_FIELD);
            this.put("AccessGrantsInstanceId", ACCESS_GRANTS_INSTANCE_ID_FIELD);
        }
    });
    private final String accessGrantsInstanceArn;
    private final String accessGrantsInstanceId;

    private GetAccessGrantsInstanceForPrefixResponse(BuilderImpl builder) {
        super(builder);
        this.accessGrantsInstanceArn = builder.accessGrantsInstanceArn;
        this.accessGrantsInstanceId = builder.accessGrantsInstanceId;
    }

    public final String accessGrantsInstanceArn() {
        return this.accessGrantsInstanceArn;
    }

    public final String accessGrantsInstanceId() {
        return this.accessGrantsInstanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsInstanceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessGrantsInstanceForPrefixResponse)) {
            return false;
        }
        GetAccessGrantsInstanceForPrefixResponse other = (GetAccessGrantsInstanceForPrefixResponse)((Object)obj);
        return Objects.equals(this.accessGrantsInstanceArn(), other.accessGrantsInstanceArn()) && Objects.equals(this.accessGrantsInstanceId(), other.accessGrantsInstanceId());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessGrantsInstanceForPrefixResponse").add("AccessGrantsInstanceArn", (Object)this.accessGrantsInstanceArn()).add("AccessGrantsInstanceId", (Object)this.accessGrantsInstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessGrantsInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsInstanceArn()));
            }
            case "AccessGrantsInstanceId": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsInstanceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessGrantsInstanceForPrefixResponse, T> g) {
        return obj -> g.apply((GetAccessGrantsInstanceForPrefixResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String accessGrantsInstanceArn;
        private String accessGrantsInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessGrantsInstanceForPrefixResponse model) {
            super(model);
            this.accessGrantsInstanceArn(model.accessGrantsInstanceArn);
            this.accessGrantsInstanceId(model.accessGrantsInstanceId);
        }

        public final String getAccessGrantsInstanceArn() {
            return this.accessGrantsInstanceArn;
        }

        public final void setAccessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
        }

        @Override
        public final Builder accessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
            return this;
        }

        public final String getAccessGrantsInstanceId() {
            return this.accessGrantsInstanceId;
        }

        public final void setAccessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
        }

        @Override
        public final Builder accessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
            return this;
        }

        @Override
        public GetAccessGrantsInstanceForPrefixResponse build() {
            return new GetAccessGrantsInstanceForPrefixResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessGrantsInstanceForPrefixResponse> {
        public Builder accessGrantsInstanceArn(String var1);

        public Builder accessGrantsInstanceId(String var1);
    }
}

