/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListStorageLensGroupsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensGroupsResponse;

public class ListStorageLensGroupsPublisher
implements SdkPublisher<ListStorageLensGroupsResponse> {
    private final S3ControlAsyncClient client;
    private final ListStorageLensGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStorageLensGroupsPublisher(S3ControlAsyncClient client, ListStorageLensGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStorageLensGroupsPublisher(S3ControlAsyncClient client, ListStorageLensGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStorageLensGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStorageLensGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStorageLensGroupsResponseFetcher
    implements AsyncPageFetcher<ListStorageLensGroupsResponse> {
        private ListStorageLensGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageLensGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStorageLensGroupsResponse> nextPage(ListStorageLensGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListStorageLensGroupsPublisher.this.client.listStorageLensGroups(ListStorageLensGroupsPublisher.this.firstRequest);
            }
            return ListStorageLensGroupsPublisher.this.client.listStorageLensGroups((ListStorageLensGroupsRequest)((Object)ListStorageLensGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

