/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse;

public class ListMultiRegionAccessPointsIterable
implements SdkIterable<ListMultiRegionAccessPointsResponse> {
    private final S3ControlClient client;
    private final ListMultiRegionAccessPointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMultiRegionAccessPointsIterable(S3ControlClient client, ListMultiRegionAccessPointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMultiRegionAccessPointsResponseFetcher();
    }

    public Iterator<ListMultiRegionAccessPointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMultiRegionAccessPointsResponseFetcher
    implements SyncPageFetcher<ListMultiRegionAccessPointsResponse> {
        private ListMultiRegionAccessPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultiRegionAccessPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMultiRegionAccessPointsResponse nextPage(ListMultiRegionAccessPointsResponse previousPage) {
            if (previousPage == null) {
                return ListMultiRegionAccessPointsIterable.this.client.listMultiRegionAccessPoints(ListMultiRegionAccessPointsIterable.this.firstRequest);
            }
            return ListMultiRegionAccessPointsIterable.this.client.listMultiRegionAccessPoints((ListMultiRegionAccessPointsRequest)((Object)ListMultiRegionAccessPointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

