/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAlias;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessPointForObjectLambdaResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, CreateAccessPointForObjectLambdaResponse> {
    private static final SdkField<String> OBJECT_LAMBDA_ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectLambdaAccessPointArn").getter(CreateAccessPointForObjectLambdaResponse.getter(CreateAccessPointForObjectLambdaResponse::objectLambdaAccessPointArn)).setter(CreateAccessPointForObjectLambdaResponse.setter(Builder::objectLambdaAccessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLambdaAccessPointArn").unmarshallLocationName("ObjectLambdaAccessPointArn").build()}).build();
    private static final SdkField<ObjectLambdaAccessPointAlias> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Alias").getter(CreateAccessPointForObjectLambdaResponse.getter(CreateAccessPointForObjectLambdaResponse::alias)).setter(CreateAccessPointForObjectLambdaResponse.setter(Builder::alias)).constructor(ObjectLambdaAccessPointAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").unmarshallLocationName("Alias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_LAMBDA_ACCESS_POINT_ARN_FIELD, ALIAS_FIELD));
    private final String objectLambdaAccessPointArn;
    private final ObjectLambdaAccessPointAlias alias;

    private CreateAccessPointForObjectLambdaResponse(BuilderImpl builder) {
        super(builder);
        this.objectLambdaAccessPointArn = builder.objectLambdaAccessPointArn;
        this.alias = builder.alias;
    }

    public final String objectLambdaAccessPointArn() {
        return this.objectLambdaAccessPointArn;
    }

    public final ObjectLambdaAccessPointAlias alias() {
        return this.alias;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.objectLambdaAccessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPointForObjectLambdaResponse)) {
            return false;
        }
        CreateAccessPointForObjectLambdaResponse other = (CreateAccessPointForObjectLambdaResponse)((Object)obj);
        return Objects.equals(this.objectLambdaAccessPointArn(), other.objectLambdaAccessPointArn()) && Objects.equals(this.alias(), other.alias());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessPointForObjectLambdaResponse").add("ObjectLambdaAccessPointArn", (Object)this.objectLambdaAccessPointArn()).add("Alias", (Object)this.alias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectLambdaAccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.objectLambdaAccessPointArn()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPointForObjectLambdaResponse, T> g) {
        return obj -> g.apply((CreateAccessPointForObjectLambdaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String objectLambdaAccessPointArn;
        private ObjectLambdaAccessPointAlias alias;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPointForObjectLambdaResponse model) {
            super(model);
            this.objectLambdaAccessPointArn(model.objectLambdaAccessPointArn);
            this.alias(model.alias);
        }

        public final String getObjectLambdaAccessPointArn() {
            return this.objectLambdaAccessPointArn;
        }

        public final void setObjectLambdaAccessPointArn(String objectLambdaAccessPointArn) {
            this.objectLambdaAccessPointArn = objectLambdaAccessPointArn;
        }

        @Override
        public final Builder objectLambdaAccessPointArn(String objectLambdaAccessPointArn) {
            this.objectLambdaAccessPointArn = objectLambdaAccessPointArn;
            return this;
        }

        public final ObjectLambdaAccessPointAlias.Builder getAlias() {
            return this.alias != null ? this.alias.toBuilder() : null;
        }

        public final void setAlias(ObjectLambdaAccessPointAlias.BuilderImpl alias) {
            this.alias = alias != null ? alias.build() : null;
        }

        @Override
        public final Builder alias(ObjectLambdaAccessPointAlias alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public CreateAccessPointForObjectLambdaResponse build() {
            return new CreateAccessPointForObjectLambdaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessPointForObjectLambdaResponse> {
        public Builder objectLambdaAccessPointArn(String var1);

        public Builder alias(ObjectLambdaAccessPointAlias var1);

        default public Builder alias(Consumer<ObjectLambdaAccessPointAlias.Builder> alias) {
            return this.alias((ObjectLambdaAccessPointAlias)((ObjectLambdaAccessPointAlias.Builder)ObjectLambdaAccessPointAlias.builder().applyMutation(alias)).build());
        }
    }
}

