/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessGrantsInstanceForPrefixRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, GetAccessGrantsInstanceForPrefixRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(GetAccessGrantsInstanceForPrefixRequest.getter(GetAccessGrantsInstanceForPrefixRequest::accountId)).setter(GetAccessGrantsInstanceForPrefixRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(GetAccessGrantsInstanceForPrefixRequest.getter(GetAccessGrantsInstanceForPrefixRequest::s3Prefix)).setter(GetAccessGrantsInstanceForPrefixRequest.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("s3prefix").unmarshallLocationName("s3prefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, S3_PREFIX_FIELD));
    private final String accountId;
    private final String s3Prefix;

    private GetAccessGrantsInstanceForPrefixRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.s3Prefix = builder.s3Prefix;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessGrantsInstanceForPrefixRequest)) {
            return false;
        }
        GetAccessGrantsInstanceForPrefixRequest other = (GetAccessGrantsInstanceForPrefixRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.s3Prefix(), other.s3Prefix());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessGrantsInstanceForPrefixRequest").add("AccountId", (Object)this.accountId()).add("S3Prefix", (Object)this.s3Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessGrantsInstanceForPrefixRequest, T> g) {
        return obj -> g.apply((GetAccessGrantsInstanceForPrefixRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String s3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessGrantsInstanceForPrefixRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.s3Prefix(model.s3Prefix);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAccessGrantsInstanceForPrefixRequest build() {
            return new GetAccessGrantsInstanceForPrefixRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessGrantsInstanceForPrefixRequest> {
        public Builder accountId(String var1);

        public Builder s3Prefix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

