/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3ChecksumAlgorithm {
    CRC32("CRC32"),
    CRC32_C("CRC32C"),
    SHA1("SHA1"),
    SHA256("SHA256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3ChecksumAlgorithm> VALUE_MAP;
    private final String value;

    private S3ChecksumAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3ChecksumAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3ChecksumAlgorithm> knownValues() {
        EnumSet<S3ChecksumAlgorithm> knownValues = EnumSet.allOf(S3ChecksumAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3ChecksumAlgorithm.class, S3ChecksumAlgorithm::toString);
    }
}

