/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.endpoints.internal;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlClientContextParams;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointParams;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointProvider;
import software.amazon.awssdk.services.s3control.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.s3control.model.AssociateAccessGrantsIdentityCenterRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessGrantRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessGrantsInstanceRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessGrantsLocationRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3control.model.CreateJobRequest;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateStorageLensGroupRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantsInstanceRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantsInstanceResourcePolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantsLocationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensGroupRequest;
import software.amazon.awssdk.services.s3control.model.DescribeJobRequest;
import software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest;
import software.amazon.awssdk.services.s3control.model.DissociateAccessGrantsIdentityCenterRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceForPrefixRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceResourcePolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsLocationRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3control.model.GetDataAccessRequest;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesRequest;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensGroupRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstancesRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListJobsRequest;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensGroupsRequest;
import software.amazon.awssdk.services.s3control.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessGrantsInstanceResourcePolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest;
import software.amazon.awssdk.services.s3control.model.TagResourceRequest;
import software.amazon.awssdk.services.s3control.model.UntagResourceRequest;
import software.amazon.awssdk.services.s3control.model.UpdateAccessGrantsLocationRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest;
import software.amazon.awssdk.services.s3control.model.UpdateStorageLensGroupRequest;
import software.amazon.awssdk.utils.AttributeMap;

@SdkInternalApi
public final class S3ControlResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest result = context.request();
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return result;
        }
        S3ControlEndpointProvider provider = (S3ControlEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint endpoint = provider.resolveEndpoint(S3ControlResolveEndpointInterceptor.ruleParams(result, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = S3ControlResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), result)).isPresent()) {
                endpoint = AwsEndpointProviderUtils.addHostPrefix(endpoint, hostPrefix.get());
            }
            List endpointAuthSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
            SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
            if (endpointAuthSchemes != null && selectedAuthScheme != null) {
                selectedAuthScheme = this.authSchemeWithEndpointSignerProperties(endpointAuthSchemes, selectedAuthScheme);
                executionAttributes.putAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME, selectedAuthScheme);
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)endpoint);
            return result;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Endpoint resolvedEndpoint = (Endpoint)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        if (resolvedEndpoint.headers().isEmpty()) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder httpRequestBuilder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        resolvedEndpoint.headers().forEach((name, values) -> values.forEach(v -> httpRequestBuilder.appendHeader(name, v)));
        return (SdkHttpRequest)httpRequestBuilder.build();
    }

    public static S3ControlEndpointParams ruleParams(SdkRequest request, ExecutionAttributes executionAttributes) {
        S3ControlEndpointParams.Builder builder = S3ControlEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        S3ControlResolveEndpointInterceptor.setClientContextParams(builder, executionAttributes);
        S3ControlResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        S3ControlResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        return builder.build();
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            case "AssociateAccessGrantsIdentityCenter": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (AssociateAccessGrantsIdentityCenterRequest)request);
                break;
            }
            case "CreateAccessGrant": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (CreateAccessGrantRequest)request);
                break;
            }
            case "CreateAccessGrantsInstance": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (CreateAccessGrantsInstanceRequest)request);
                break;
            }
            case "CreateAccessGrantsLocation": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (CreateAccessGrantsLocationRequest)request);
                break;
            }
            case "CreateAccessPoint": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (CreateAccessPointRequest)request);
                break;
            }
            case "CreateAccessPointForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (CreateAccessPointForObjectLambdaRequest)request);
                break;
            }
            case "CreateBucket": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (CreateBucketRequest)request);
                break;
            }
            case "CreateJob": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (CreateJobRequest)request);
                break;
            }
            case "CreateMultiRegionAccessPoint": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (CreateMultiRegionAccessPointRequest)request);
                break;
            }
            case "CreateStorageLensGroup": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (CreateStorageLensGroupRequest)request);
                break;
            }
            case "DeleteAccessGrant": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteAccessGrantRequest)request);
                break;
            }
            case "DeleteAccessGrantsInstance": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteAccessGrantsInstanceRequest)request);
                break;
            }
            case "DeleteAccessGrantsInstanceResourcePolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteAccessGrantsInstanceResourcePolicyRequest)request);
                break;
            }
            case "DeleteAccessGrantsLocation": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteAccessGrantsLocationRequest)request);
                break;
            }
            case "DeleteAccessPoint": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteAccessPointRequest)request);
                break;
            }
            case "DeleteAccessPointForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteAccessPointForObjectLambdaRequest)request);
                break;
            }
            case "DeleteAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteAccessPointPolicyRequest)request);
                break;
            }
            case "DeleteAccessPointPolicyForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteAccessPointPolicyForObjectLambdaRequest)request);
                break;
            }
            case "DeleteBucket": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteBucketRequest)request);
                break;
            }
            case "DeleteBucketLifecycleConfiguration": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteBucketLifecycleConfigurationRequest)request);
                break;
            }
            case "DeleteBucketPolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteBucketPolicyRequest)request);
                break;
            }
            case "DeleteBucketReplication": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteBucketReplicationRequest)request);
                break;
            }
            case "DeleteBucketTagging": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteBucketTaggingRequest)request);
                break;
            }
            case "DeleteJobTagging": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteJobTaggingRequest)request);
                break;
            }
            case "DeleteMultiRegionAccessPoint": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteMultiRegionAccessPointRequest)request);
                break;
            }
            case "DeletePublicAccessBlock": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeletePublicAccessBlockRequest)request);
                break;
            }
            case "DeleteStorageLensConfiguration": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteStorageLensConfigurationRequest)request);
                break;
            }
            case "DeleteStorageLensConfigurationTagging": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteStorageLensConfigurationTaggingRequest)request);
                break;
            }
            case "DeleteStorageLensGroup": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DeleteStorageLensGroupRequest)request);
                break;
            }
            case "DescribeJob": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DescribeJobRequest)request);
                break;
            }
            case "DescribeMultiRegionAccessPointOperation": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DescribeMultiRegionAccessPointOperationRequest)request);
                break;
            }
            case "DissociateAccessGrantsIdentityCenter": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (DissociateAccessGrantsIdentityCenterRequest)request);
                break;
            }
            case "GetAccessGrant": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessGrantRequest)request);
                break;
            }
            case "GetAccessGrantsInstance": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessGrantsInstanceRequest)request);
                break;
            }
            case "GetAccessGrantsInstanceForPrefix": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessGrantsInstanceForPrefixRequest)request);
                break;
            }
            case "GetAccessGrantsInstanceResourcePolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessGrantsInstanceResourcePolicyRequest)request);
                break;
            }
            case "GetAccessGrantsLocation": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessGrantsLocationRequest)request);
                break;
            }
            case "GetAccessPoint": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessPointRequest)request);
                break;
            }
            case "GetAccessPointConfigurationForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessPointConfigurationForObjectLambdaRequest)request);
                break;
            }
            case "GetAccessPointForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessPointForObjectLambdaRequest)request);
                break;
            }
            case "GetAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessPointPolicyRequest)request);
                break;
            }
            case "GetAccessPointPolicyForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessPointPolicyForObjectLambdaRequest)request);
                break;
            }
            case "GetAccessPointPolicyStatus": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessPointPolicyStatusRequest)request);
                break;
            }
            case "GetAccessPointPolicyStatusForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetAccessPointPolicyStatusForObjectLambdaRequest)request);
                break;
            }
            case "GetBucket": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetBucketRequest)request);
                break;
            }
            case "GetBucketLifecycleConfiguration": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetBucketLifecycleConfigurationRequest)request);
                break;
            }
            case "GetBucketPolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetBucketPolicyRequest)request);
                break;
            }
            case "GetBucketReplication": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetBucketReplicationRequest)request);
                break;
            }
            case "GetBucketTagging": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetBucketTaggingRequest)request);
                break;
            }
            case "GetBucketVersioning": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetBucketVersioningRequest)request);
                break;
            }
            case "GetDataAccess": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetDataAccessRequest)request);
                break;
            }
            case "GetJobTagging": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetJobTaggingRequest)request);
                break;
            }
            case "GetMultiRegionAccessPoint": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetMultiRegionAccessPointRequest)request);
                break;
            }
            case "GetMultiRegionAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetMultiRegionAccessPointPolicyRequest)request);
                break;
            }
            case "GetMultiRegionAccessPointPolicyStatus": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetMultiRegionAccessPointPolicyStatusRequest)request);
                break;
            }
            case "GetMultiRegionAccessPointRoutes": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetMultiRegionAccessPointRoutesRequest)request);
                break;
            }
            case "GetPublicAccessBlock": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetPublicAccessBlockRequest)request);
                break;
            }
            case "GetStorageLensConfiguration": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetStorageLensConfigurationRequest)request);
                break;
            }
            case "GetStorageLensConfigurationTagging": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetStorageLensConfigurationTaggingRequest)request);
                break;
            }
            case "GetStorageLensGroup": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (GetStorageLensGroupRequest)request);
                break;
            }
            case "ListAccessGrants": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListAccessGrantsRequest)request);
                break;
            }
            case "ListAccessGrantsInstances": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListAccessGrantsInstancesRequest)request);
                break;
            }
            case "ListAccessGrantsLocations": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListAccessGrantsLocationsRequest)request);
                break;
            }
            case "ListAccessPoints": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListAccessPointsRequest)request);
                break;
            }
            case "ListAccessPointsForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListAccessPointsForObjectLambdaRequest)request);
                break;
            }
            case "ListJobs": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListJobsRequest)request);
                break;
            }
            case "ListMultiRegionAccessPoints": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListMultiRegionAccessPointsRequest)request);
                break;
            }
            case "ListRegionalBuckets": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListRegionalBucketsRequest)request);
                break;
            }
            case "ListStorageLensConfigurations": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListStorageLensConfigurationsRequest)request);
                break;
            }
            case "ListStorageLensGroups": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListStorageLensGroupsRequest)request);
                break;
            }
            case "ListTagsForResource": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (ListTagsForResourceRequest)request);
                break;
            }
            case "PutAccessGrantsInstanceResourcePolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutAccessGrantsInstanceResourcePolicyRequest)request);
                break;
            }
            case "PutAccessPointConfigurationForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutAccessPointConfigurationForObjectLambdaRequest)request);
                break;
            }
            case "PutAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutAccessPointPolicyRequest)request);
                break;
            }
            case "PutAccessPointPolicyForObjectLambda": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutAccessPointPolicyForObjectLambdaRequest)request);
                break;
            }
            case "PutBucketLifecycleConfiguration": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutBucketLifecycleConfigurationRequest)request);
                break;
            }
            case "PutBucketPolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutBucketPolicyRequest)request);
                break;
            }
            case "PutBucketReplication": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutBucketReplicationRequest)request);
                break;
            }
            case "PutBucketTagging": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutBucketTaggingRequest)request);
                break;
            }
            case "PutBucketVersioning": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutBucketVersioningRequest)request);
                break;
            }
            case "PutJobTagging": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutJobTaggingRequest)request);
                break;
            }
            case "PutMultiRegionAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutMultiRegionAccessPointPolicyRequest)request);
                break;
            }
            case "PutPublicAccessBlock": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutPublicAccessBlockRequest)request);
                break;
            }
            case "PutStorageLensConfiguration": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutStorageLensConfigurationRequest)request);
                break;
            }
            case "PutStorageLensConfigurationTagging": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (PutStorageLensConfigurationTaggingRequest)request);
                break;
            }
            case "SubmitMultiRegionAccessPointRoutes": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (SubmitMultiRegionAccessPointRoutesRequest)request);
                break;
            }
            case "TagResource": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (TagResourceRequest)request);
                break;
            }
            case "UntagResource": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (UntagResourceRequest)request);
                break;
            }
            case "UpdateAccessGrantsLocation": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (UpdateAccessGrantsLocationRequest)request);
                break;
            }
            case "UpdateJobPriority": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (UpdateJobPriorityRequest)request);
                break;
            }
            case "UpdateJobStatus": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (UpdateJobStatusRequest)request);
                break;
            }
            case "UpdateStorageLensGroup": {
                S3ControlResolveEndpointInterceptor.setContextParams(params, (UpdateStorageLensGroupRequest)request);
                break;
            }
        }
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, AssociateAccessGrantsIdentityCenterRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, CreateAccessGrantRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, CreateAccessGrantsInstanceRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, CreateAccessGrantsLocationRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, CreateAccessPointRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, CreateAccessPointForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, CreateBucketRequest request) {
        params.bucket(request.bucket());
        params.outpostId(request.outpostId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, CreateJobRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, CreateMultiRegionAccessPointRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, CreateStorageLensGroupRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteAccessGrantRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteAccessGrantsInstanceRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteAccessGrantsInstanceResourcePolicyRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteAccessGrantsLocationRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteAccessPointRequest request) {
        params.accountId(request.accountId());
        params.accessPointName(request.name());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteAccessPointForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteAccessPointPolicyRequest request) {
        params.accountId(request.accountId());
        params.accessPointName(request.name());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteAccessPointPolicyForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteBucketRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteBucketLifecycleConfigurationRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteBucketPolicyRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteBucketReplicationRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteBucketTaggingRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteJobTaggingRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteMultiRegionAccessPointRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeletePublicAccessBlockRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteStorageLensConfigurationRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteStorageLensConfigurationTaggingRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DeleteStorageLensGroupRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DescribeJobRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DescribeMultiRegionAccessPointOperationRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, DissociateAccessGrantsIdentityCenterRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessGrantRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessGrantsInstanceRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessGrantsInstanceForPrefixRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessGrantsInstanceResourcePolicyRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessGrantsLocationRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessPointRequest request) {
        params.accountId(request.accountId());
        params.accessPointName(request.name());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessPointConfigurationForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessPointForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessPointPolicyRequest request) {
        params.accountId(request.accountId());
        params.accessPointName(request.name());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessPointPolicyForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessPointPolicyStatusRequest request) {
        params.accountId(request.accountId());
        params.accessPointName(request.name());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetAccessPointPolicyStatusForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetBucketRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetBucketLifecycleConfigurationRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetBucketPolicyRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetBucketReplicationRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetBucketTaggingRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetBucketVersioningRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetDataAccessRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetJobTaggingRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetMultiRegionAccessPointRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetMultiRegionAccessPointPolicyRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetMultiRegionAccessPointPolicyStatusRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetMultiRegionAccessPointRoutesRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetPublicAccessBlockRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetStorageLensConfigurationRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetStorageLensConfigurationTaggingRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, GetStorageLensGroupRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListAccessGrantsRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListAccessGrantsInstancesRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListAccessGrantsLocationsRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListAccessPointsRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListAccessPointsForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListJobsRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListMultiRegionAccessPointsRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListRegionalBucketsRequest request) {
        params.accountId(request.accountId());
        params.outpostId(request.outpostId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListStorageLensConfigurationsRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListStorageLensGroupsRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, ListTagsForResourceRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutAccessGrantsInstanceResourcePolicyRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutAccessPointConfigurationForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutAccessPointPolicyRequest request) {
        params.accountId(request.accountId());
        params.accessPointName(request.name());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutAccessPointPolicyForObjectLambdaRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutBucketLifecycleConfigurationRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutBucketPolicyRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutBucketReplicationRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutBucketTaggingRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutBucketVersioningRequest request) {
        params.accountId(request.accountId());
        params.bucket(request.bucket());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutJobTaggingRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutMultiRegionAccessPointPolicyRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutPublicAccessBlockRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutStorageLensConfigurationRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, PutStorageLensConfigurationTaggingRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, SubmitMultiRegionAccessPointRoutesRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, TagResourceRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, UntagResourceRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, UpdateAccessGrantsLocationRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, UpdateJobPriorityRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, UpdateJobStatusRequest request) {
        params.accountId(request.accountId());
    }

    private static void setContextParams(S3ControlEndpointParams.Builder params, UpdateStorageLensGroupRequest request) {
        params.accountId(request.accountId());
    }

    private static void setStaticContextParams(S3ControlEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            case "AssociateAccessGrantsIdentityCenter": {
                S3ControlResolveEndpointInterceptor.associateAccessGrantsIdentityCenterStaticContextParams(params);
                break;
            }
            case "CreateAccessGrant": {
                S3ControlResolveEndpointInterceptor.createAccessGrantStaticContextParams(params);
                break;
            }
            case "CreateAccessGrantsInstance": {
                S3ControlResolveEndpointInterceptor.createAccessGrantsInstanceStaticContextParams(params);
                break;
            }
            case "CreateAccessGrantsLocation": {
                S3ControlResolveEndpointInterceptor.createAccessGrantsLocationStaticContextParams(params);
                break;
            }
            case "CreateAccessPoint": {
                S3ControlResolveEndpointInterceptor.createAccessPointStaticContextParams(params);
                break;
            }
            case "CreateAccessPointForObjectLambda": {
                S3ControlResolveEndpointInterceptor.createAccessPointForObjectLambdaStaticContextParams(params);
                break;
            }
            case "CreateJob": {
                S3ControlResolveEndpointInterceptor.createJobStaticContextParams(params);
                break;
            }
            case "CreateMultiRegionAccessPoint": {
                S3ControlResolveEndpointInterceptor.createMultiRegionAccessPointStaticContextParams(params);
                break;
            }
            case "CreateStorageLensGroup": {
                S3ControlResolveEndpointInterceptor.createStorageLensGroupStaticContextParams(params);
                break;
            }
            case "DeleteAccessGrant": {
                S3ControlResolveEndpointInterceptor.deleteAccessGrantStaticContextParams(params);
                break;
            }
            case "DeleteAccessGrantsInstance": {
                S3ControlResolveEndpointInterceptor.deleteAccessGrantsInstanceStaticContextParams(params);
                break;
            }
            case "DeleteAccessGrantsInstanceResourcePolicy": {
                S3ControlResolveEndpointInterceptor.deleteAccessGrantsInstanceResourcePolicyStaticContextParams(params);
                break;
            }
            case "DeleteAccessGrantsLocation": {
                S3ControlResolveEndpointInterceptor.deleteAccessGrantsLocationStaticContextParams(params);
                break;
            }
            case "DeleteAccessPoint": {
                S3ControlResolveEndpointInterceptor.deleteAccessPointStaticContextParams(params);
                break;
            }
            case "DeleteAccessPointForObjectLambda": {
                S3ControlResolveEndpointInterceptor.deleteAccessPointForObjectLambdaStaticContextParams(params);
                break;
            }
            case "DeleteAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.deleteAccessPointPolicyStaticContextParams(params);
                break;
            }
            case "DeleteAccessPointPolicyForObjectLambda": {
                S3ControlResolveEndpointInterceptor.deleteAccessPointPolicyForObjectLambdaStaticContextParams(params);
                break;
            }
            case "DeleteBucket": {
                S3ControlResolveEndpointInterceptor.deleteBucketStaticContextParams(params);
                break;
            }
            case "DeleteBucketLifecycleConfiguration": {
                S3ControlResolveEndpointInterceptor.deleteBucketLifecycleConfigurationStaticContextParams(params);
                break;
            }
            case "DeleteBucketPolicy": {
                S3ControlResolveEndpointInterceptor.deleteBucketPolicyStaticContextParams(params);
                break;
            }
            case "DeleteBucketReplication": {
                S3ControlResolveEndpointInterceptor.deleteBucketReplicationStaticContextParams(params);
                break;
            }
            case "DeleteBucketTagging": {
                S3ControlResolveEndpointInterceptor.deleteBucketTaggingStaticContextParams(params);
                break;
            }
            case "DeleteJobTagging": {
                S3ControlResolveEndpointInterceptor.deleteJobTaggingStaticContextParams(params);
                break;
            }
            case "DeleteMultiRegionAccessPoint": {
                S3ControlResolveEndpointInterceptor.deleteMultiRegionAccessPointStaticContextParams(params);
                break;
            }
            case "DeletePublicAccessBlock": {
                S3ControlResolveEndpointInterceptor.deletePublicAccessBlockStaticContextParams(params);
                break;
            }
            case "DeleteStorageLensConfiguration": {
                S3ControlResolveEndpointInterceptor.deleteStorageLensConfigurationStaticContextParams(params);
                break;
            }
            case "DeleteStorageLensConfigurationTagging": {
                S3ControlResolveEndpointInterceptor.deleteStorageLensConfigurationTaggingStaticContextParams(params);
                break;
            }
            case "DeleteStorageLensGroup": {
                S3ControlResolveEndpointInterceptor.deleteStorageLensGroupStaticContextParams(params);
                break;
            }
            case "DescribeJob": {
                S3ControlResolveEndpointInterceptor.describeJobStaticContextParams(params);
                break;
            }
            case "DescribeMultiRegionAccessPointOperation": {
                S3ControlResolveEndpointInterceptor.describeMultiRegionAccessPointOperationStaticContextParams(params);
                break;
            }
            case "DissociateAccessGrantsIdentityCenter": {
                S3ControlResolveEndpointInterceptor.dissociateAccessGrantsIdentityCenterStaticContextParams(params);
                break;
            }
            case "GetAccessGrant": {
                S3ControlResolveEndpointInterceptor.getAccessGrantStaticContextParams(params);
                break;
            }
            case "GetAccessGrantsInstance": {
                S3ControlResolveEndpointInterceptor.getAccessGrantsInstanceStaticContextParams(params);
                break;
            }
            case "GetAccessGrantsInstanceForPrefix": {
                S3ControlResolveEndpointInterceptor.getAccessGrantsInstanceForPrefixStaticContextParams(params);
                break;
            }
            case "GetAccessGrantsInstanceResourcePolicy": {
                S3ControlResolveEndpointInterceptor.getAccessGrantsInstanceResourcePolicyStaticContextParams(params);
                break;
            }
            case "GetAccessGrantsLocation": {
                S3ControlResolveEndpointInterceptor.getAccessGrantsLocationStaticContextParams(params);
                break;
            }
            case "GetAccessPoint": {
                S3ControlResolveEndpointInterceptor.getAccessPointStaticContextParams(params);
                break;
            }
            case "GetAccessPointConfigurationForObjectLambda": {
                S3ControlResolveEndpointInterceptor.getAccessPointConfigurationForObjectLambdaStaticContextParams(params);
                break;
            }
            case "GetAccessPointForObjectLambda": {
                S3ControlResolveEndpointInterceptor.getAccessPointForObjectLambdaStaticContextParams(params);
                break;
            }
            case "GetAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.getAccessPointPolicyStaticContextParams(params);
                break;
            }
            case "GetAccessPointPolicyForObjectLambda": {
                S3ControlResolveEndpointInterceptor.getAccessPointPolicyForObjectLambdaStaticContextParams(params);
                break;
            }
            case "GetAccessPointPolicyStatus": {
                S3ControlResolveEndpointInterceptor.getAccessPointPolicyStatusStaticContextParams(params);
                break;
            }
            case "GetAccessPointPolicyStatusForObjectLambda": {
                S3ControlResolveEndpointInterceptor.getAccessPointPolicyStatusForObjectLambdaStaticContextParams(params);
                break;
            }
            case "GetBucket": {
                S3ControlResolveEndpointInterceptor.getBucketStaticContextParams(params);
                break;
            }
            case "GetBucketLifecycleConfiguration": {
                S3ControlResolveEndpointInterceptor.getBucketLifecycleConfigurationStaticContextParams(params);
                break;
            }
            case "GetBucketPolicy": {
                S3ControlResolveEndpointInterceptor.getBucketPolicyStaticContextParams(params);
                break;
            }
            case "GetBucketReplication": {
                S3ControlResolveEndpointInterceptor.getBucketReplicationStaticContextParams(params);
                break;
            }
            case "GetBucketTagging": {
                S3ControlResolveEndpointInterceptor.getBucketTaggingStaticContextParams(params);
                break;
            }
            case "GetBucketVersioning": {
                S3ControlResolveEndpointInterceptor.getBucketVersioningStaticContextParams(params);
                break;
            }
            case "GetDataAccess": {
                S3ControlResolveEndpointInterceptor.getDataAccessStaticContextParams(params);
                break;
            }
            case "GetJobTagging": {
                S3ControlResolveEndpointInterceptor.getJobTaggingStaticContextParams(params);
                break;
            }
            case "GetMultiRegionAccessPoint": {
                S3ControlResolveEndpointInterceptor.getMultiRegionAccessPointStaticContextParams(params);
                break;
            }
            case "GetMultiRegionAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.getMultiRegionAccessPointPolicyStaticContextParams(params);
                break;
            }
            case "GetMultiRegionAccessPointPolicyStatus": {
                S3ControlResolveEndpointInterceptor.getMultiRegionAccessPointPolicyStatusStaticContextParams(params);
                break;
            }
            case "GetMultiRegionAccessPointRoutes": {
                S3ControlResolveEndpointInterceptor.getMultiRegionAccessPointRoutesStaticContextParams(params);
                break;
            }
            case "GetPublicAccessBlock": {
                S3ControlResolveEndpointInterceptor.getPublicAccessBlockStaticContextParams(params);
                break;
            }
            case "GetStorageLensConfiguration": {
                S3ControlResolveEndpointInterceptor.getStorageLensConfigurationStaticContextParams(params);
                break;
            }
            case "GetStorageLensConfigurationTagging": {
                S3ControlResolveEndpointInterceptor.getStorageLensConfigurationTaggingStaticContextParams(params);
                break;
            }
            case "GetStorageLensGroup": {
                S3ControlResolveEndpointInterceptor.getStorageLensGroupStaticContextParams(params);
                break;
            }
            case "ListAccessGrants": {
                S3ControlResolveEndpointInterceptor.listAccessGrantsStaticContextParams(params);
                break;
            }
            case "ListAccessGrantsInstances": {
                S3ControlResolveEndpointInterceptor.listAccessGrantsInstancesStaticContextParams(params);
                break;
            }
            case "ListAccessGrantsLocations": {
                S3ControlResolveEndpointInterceptor.listAccessGrantsLocationsStaticContextParams(params);
                break;
            }
            case "ListAccessPoints": {
                S3ControlResolveEndpointInterceptor.listAccessPointsStaticContextParams(params);
                break;
            }
            case "ListAccessPointsForObjectLambda": {
                S3ControlResolveEndpointInterceptor.listAccessPointsForObjectLambdaStaticContextParams(params);
                break;
            }
            case "ListJobs": {
                S3ControlResolveEndpointInterceptor.listJobsStaticContextParams(params);
                break;
            }
            case "ListMultiRegionAccessPoints": {
                S3ControlResolveEndpointInterceptor.listMultiRegionAccessPointsStaticContextParams(params);
                break;
            }
            case "ListRegionalBuckets": {
                S3ControlResolveEndpointInterceptor.listRegionalBucketsStaticContextParams(params);
                break;
            }
            case "ListStorageLensConfigurations": {
                S3ControlResolveEndpointInterceptor.listStorageLensConfigurationsStaticContextParams(params);
                break;
            }
            case "ListStorageLensGroups": {
                S3ControlResolveEndpointInterceptor.listStorageLensGroupsStaticContextParams(params);
                break;
            }
            case "ListTagsForResource": {
                S3ControlResolveEndpointInterceptor.listTagsForResourceStaticContextParams(params);
                break;
            }
            case "PutAccessGrantsInstanceResourcePolicy": {
                S3ControlResolveEndpointInterceptor.putAccessGrantsInstanceResourcePolicyStaticContextParams(params);
                break;
            }
            case "PutAccessPointConfigurationForObjectLambda": {
                S3ControlResolveEndpointInterceptor.putAccessPointConfigurationForObjectLambdaStaticContextParams(params);
                break;
            }
            case "PutAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.putAccessPointPolicyStaticContextParams(params);
                break;
            }
            case "PutAccessPointPolicyForObjectLambda": {
                S3ControlResolveEndpointInterceptor.putAccessPointPolicyForObjectLambdaStaticContextParams(params);
                break;
            }
            case "PutBucketLifecycleConfiguration": {
                S3ControlResolveEndpointInterceptor.putBucketLifecycleConfigurationStaticContextParams(params);
                break;
            }
            case "PutBucketPolicy": {
                S3ControlResolveEndpointInterceptor.putBucketPolicyStaticContextParams(params);
                break;
            }
            case "PutBucketReplication": {
                S3ControlResolveEndpointInterceptor.putBucketReplicationStaticContextParams(params);
                break;
            }
            case "PutBucketTagging": {
                S3ControlResolveEndpointInterceptor.putBucketTaggingStaticContextParams(params);
                break;
            }
            case "PutBucketVersioning": {
                S3ControlResolveEndpointInterceptor.putBucketVersioningStaticContextParams(params);
                break;
            }
            case "PutJobTagging": {
                S3ControlResolveEndpointInterceptor.putJobTaggingStaticContextParams(params);
                break;
            }
            case "PutMultiRegionAccessPointPolicy": {
                S3ControlResolveEndpointInterceptor.putMultiRegionAccessPointPolicyStaticContextParams(params);
                break;
            }
            case "PutPublicAccessBlock": {
                S3ControlResolveEndpointInterceptor.putPublicAccessBlockStaticContextParams(params);
                break;
            }
            case "PutStorageLensConfiguration": {
                S3ControlResolveEndpointInterceptor.putStorageLensConfigurationStaticContextParams(params);
                break;
            }
            case "PutStorageLensConfigurationTagging": {
                S3ControlResolveEndpointInterceptor.putStorageLensConfigurationTaggingStaticContextParams(params);
                break;
            }
            case "SubmitMultiRegionAccessPointRoutes": {
                S3ControlResolveEndpointInterceptor.submitMultiRegionAccessPointRoutesStaticContextParams(params);
                break;
            }
            case "TagResource": {
                S3ControlResolveEndpointInterceptor.tagResourceStaticContextParams(params);
                break;
            }
            case "UntagResource": {
                S3ControlResolveEndpointInterceptor.untagResourceStaticContextParams(params);
                break;
            }
            case "UpdateAccessGrantsLocation": {
                S3ControlResolveEndpointInterceptor.updateAccessGrantsLocationStaticContextParams(params);
                break;
            }
            case "UpdateJobPriority": {
                S3ControlResolveEndpointInterceptor.updateJobPriorityStaticContextParams(params);
                break;
            }
            case "UpdateJobStatus": {
                S3ControlResolveEndpointInterceptor.updateJobStatusStaticContextParams(params);
                break;
            }
            case "UpdateStorageLensGroup": {
                S3ControlResolveEndpointInterceptor.updateStorageLensGroupStaticContextParams(params);
                break;
            }
        }
    }

    private static void associateAccessGrantsIdentityCenterStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void createAccessGrantStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void createAccessGrantsInstanceStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void createAccessGrantsLocationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void createAccessPointStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void createAccessPointForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void createJobStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void createMultiRegionAccessPointStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void createStorageLensGroupStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteAccessGrantStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteAccessGrantsInstanceStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteAccessGrantsInstanceResourcePolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteAccessGrantsLocationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteAccessPointStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteAccessPointForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteAccessPointPolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteAccessPointPolicyForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteBucketStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteBucketLifecycleConfigurationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteBucketPolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteBucketReplicationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteBucketTaggingStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteJobTaggingStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteMultiRegionAccessPointStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deletePublicAccessBlockStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteStorageLensConfigurationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteStorageLensConfigurationTaggingStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void deleteStorageLensGroupStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void describeJobStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void describeMultiRegionAccessPointOperationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void dissociateAccessGrantsIdentityCenterStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessGrantStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessGrantsInstanceStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessGrantsInstanceForPrefixStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessGrantsInstanceResourcePolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessGrantsLocationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessPointStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessPointConfigurationForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessPointForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessPointPolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessPointPolicyForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessPointPolicyStatusStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getAccessPointPolicyStatusForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getBucketStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getBucketLifecycleConfigurationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getBucketPolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getBucketReplicationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getBucketTaggingStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getBucketVersioningStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getDataAccessStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getJobTaggingStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getMultiRegionAccessPointStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getMultiRegionAccessPointPolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getMultiRegionAccessPointPolicyStatusStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getMultiRegionAccessPointRoutesStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getPublicAccessBlockStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getStorageLensConfigurationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getStorageLensConfigurationTaggingStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void getStorageLensGroupStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listAccessGrantsStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listAccessGrantsInstancesStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listAccessGrantsLocationsStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listAccessPointsStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listAccessPointsForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listJobsStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listMultiRegionAccessPointsStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listRegionalBucketsStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listStorageLensConfigurationsStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listStorageLensGroupsStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void listTagsForResourceStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putAccessGrantsInstanceResourcePolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putAccessPointConfigurationForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putAccessPointPolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putAccessPointPolicyForObjectLambdaStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putBucketLifecycleConfigurationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putBucketPolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putBucketReplicationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putBucketTaggingStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putBucketVersioningStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putJobTaggingStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putMultiRegionAccessPointPolicyStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putPublicAccessBlockStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putStorageLensConfigurationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void putStorageLensConfigurationTaggingStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void submitMultiRegionAccessPointRoutesStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void tagResourceStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void untagResourceStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void updateAccessGrantsLocationStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void updateJobPriorityStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void updateJobStatusStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private static void updateStorageLensGroupStaticContextParams(S3ControlEndpointParams.Builder params) {
        params.requiresAccountId(true);
    }

    private <T extends Identity> SelectedAuthScheme<T> authSchemeWithEndpointSignerProperties(List<EndpointAuthScheme> endpointAuthSchemes, SelectedAuthScheme<T> selectedAuthScheme) {
        for (EndpointAuthScheme endpointAuthScheme : endpointAuthSchemes) {
            if (!endpointAuthScheme.schemeId().equals(selectedAuthScheme.authSchemeOption().schemeId())) continue;
            AuthSchemeOption.Builder option = (AuthSchemeOption.Builder)selectedAuthScheme.authSchemeOption().toBuilder();
            if (endpointAuthScheme instanceof SigV4AuthScheme) {
                SigV4AuthScheme v4AuthScheme = (SigV4AuthScheme)endpointAuthScheme;
                if (v4AuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4AuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4AuthScheme.signingRegion() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)v4AuthScheme.signingRegion());
                }
                if (v4AuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)v4AuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            if (endpointAuthScheme instanceof SigV4aAuthScheme) {
                SigV4aAuthScheme v4aAuthScheme = (SigV4aAuthScheme)endpointAuthScheme;
                if (v4aAuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4aAuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4aAuthScheme.signingRegionSet() != null) {
                    RegionSet regionSet = RegionSet.create((Collection)v4aAuthScheme.signingRegionSet());
                    option.putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet);
                }
                if (v4aAuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)v4aAuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            throw new IllegalArgumentException("Endpoint auth scheme '" + endpointAuthScheme.name() + "' cannot be mapped to the SDK auth scheme. Was it declared in the service's model?");
        }
        return selectedAuthScheme;
    }

    private static void setClientContextParams(S3ControlEndpointParams.Builder params, ExecutionAttributes executionAttributes) {
        AttributeMap clientContextParams = (AttributeMap)executionAttributes.getAttribute(SdkInternalExecutionAttribute.CLIENT_CONTEXT_PARAMS);
        Optional.ofNullable((Boolean)clientContextParams.get(S3ControlClientContextParams.USE_ARN_REGION)).ifPresent(params::useArnRegion);
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        return Optional.empty();
    }
}

