/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksumRequired;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.S3ControlServiceClientConfiguration;
import software.amazon.awssdk.services.s3control.internal.S3ControlServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.s3control.model.BadRequestException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3control.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3control.model.CreateJobRequest;
import software.amazon.awssdk.services.s3control.model.CreateJobResponse;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DescribeJobRequest;
import software.amazon.awssdk.services.s3control.model.DescribeJobResponse;
import software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest;
import software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketReplicationResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesResponse;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.IdempotencyException;
import software.amazon.awssdk.services.s3control.model.InternalServiceException;
import software.amazon.awssdk.services.s3control.model.InvalidNextTokenException;
import software.amazon.awssdk.services.s3control.model.InvalidRequestException;
import software.amazon.awssdk.services.s3control.model.JobStatusException;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListJobsRequest;
import software.amazon.awssdk.services.s3control.model.ListJobsResponse;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse;
import software.amazon.awssdk.services.s3control.model.NoSuchPublicAccessBlockConfigurationException;
import software.amazon.awssdk.services.s3control.model.NotFoundException;
import software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketReplicationResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketVersioningResponse;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.S3ControlException;
import software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest;
import software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesResponse;
import software.amazon.awssdk.services.s3control.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3control.model.TooManyTagsException;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeletePublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeMultiRegionAccessPointOperationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointConfigurationForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointRoutesRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListMultiRegionAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListRegionalBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListStorageLensConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointConfigurationForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutMultiRegionAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.SubmitMultiRegionAccessPointRoutesRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobPriorityRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobStatusRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultS3ControlClient
implements S3ControlClient {
    private static final Logger log = Logger.loggerFor(DefaultS3ControlClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_XML).build();
    private final SyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3ControlClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessPointResponse createAccessPoint(CreateAccessPointRequest createAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, createAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPoint");
            CreateAccessPointResponse createAccessPointResponse = (CreateAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAccessPointRequest).withMarshaller((Marshaller)new CreateAccessPointRequestMarshaller(this.protocolFactory)));
            return createAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createAccessPoint$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessPointForObjectLambdaResponse createAccessPointForObjectLambda(CreateAccessPointForObjectLambdaRequest createAccessPointForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateAccessPointForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAccessPointForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, createAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPointForObjectLambda");
            CreateAccessPointForObjectLambdaResponse createAccessPointForObjectLambdaResponse = (CreateAccessPointForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPointForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAccessPointForObjectLambdaRequest).withMarshaller((Marshaller)new CreateAccessPointForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return createAccessPointForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createAccessPointForObjectLambda$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, createBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucket");
            CreateBucketResponse createBucketResponse = (CreateBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBucketRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new CreateBucketRequestMarshaller(this.protocolFactory)));
            return createBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createBucket$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws TooManyRequestsException, BadRequestException, IdempotencyException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, createJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJob");
            CreateJobResponse createJobResponse = (CreateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createJobRequest).withMarshaller((Marshaller)new CreateJobRequestMarshaller(this.protocolFactory)));
            return createJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMultiRegionAccessPointResponse createMultiRegionAccessPoint(CreateMultiRegionAccessPointRequest createMultiRegionAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateMultiRegionAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMultiRegionAccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, createMultiRegionAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMultiRegionAccessPoint");
            CreateMultiRegionAccessPointResponse createMultiRegionAccessPointResponse = (CreateMultiRegionAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultiRegionAccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMultiRegionAccessPointRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new CreateMultiRegionAccessPointRequestMarshaller(this.protocolFactory)));
            return createMultiRegionAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createMultiRegionAccessPoint$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointResponse deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPoint");
            DeleteAccessPointResponse deleteAccessPointResponse = (DeleteAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAccessPointRequest).withMarshaller((Marshaller)new DeleteAccessPointRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPoint$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointForObjectLambdaResponse deleteAccessPointForObjectLambda(DeleteAccessPointForObjectLambdaRequest deleteAccessPointForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccessPointForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointForObjectLambda");
            DeleteAccessPointForObjectLambdaResponse deleteAccessPointForObjectLambdaResponse = (DeleteAccessPointForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAccessPointForObjectLambdaRequest).withMarshaller((Marshaller)new DeleteAccessPointForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPointForObjectLambda$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointPolicyResponse deleteAccessPointPolicy(DeleteAccessPointPolicyRequest deleteAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccessPointPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointPolicy");
            DeleteAccessPointPolicyResponse deleteAccessPointPolicyResponse = (DeleteAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAccessPointPolicyRequest).withMarshaller((Marshaller)new DeleteAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPointPolicy$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointPolicyForObjectLambdaResponse deleteAccessPointPolicyForObjectLambda(DeleteAccessPointPolicyForObjectLambdaRequest deleteAccessPointPolicyForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointPolicyForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccessPointPolicyForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointPolicyForObjectLambda");
            DeleteAccessPointPolicyForObjectLambdaResponse deleteAccessPointPolicyForObjectLambdaResponse = (DeleteAccessPointPolicyForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointPolicyForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAccessPointPolicyForObjectLambdaRequest).withMarshaller((Marshaller)new DeleteAccessPointPolicyForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointPolicyForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPointPolicyForObjectLambda$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucket");
            DeleteBucketResponse deleteBucketResponse = (DeleteBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBucketRequest).withMarshaller((Marshaller)new DeleteBucketRequestMarshaller(this.protocolFactory)));
            return deleteBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucket$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketLifecycleConfigurationResponse deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBucketLifecycleConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketLifecycleConfiguration");
            DeleteBucketLifecycleConfigurationResponse deleteBucketLifecycleConfigurationResponse = (DeleteBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketLifecycleConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBucketLifecycleConfigurationRequest).withMarshaller((Marshaller)new DeleteBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketLifecycleConfiguration$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketPolicyResponse deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBucketPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketPolicy");
            DeleteBucketPolicyResponse deleteBucketPolicyResponse = (DeleteBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBucketPolicyRequest).withMarshaller((Marshaller)new DeleteBucketPolicyRequestMarshaller(this.protocolFactory)));
            return deleteBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketPolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketReplicationResponse deleteBucketReplication(DeleteBucketReplicationRequest deleteBucketReplicationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBucketReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteBucketReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketReplication");
            DeleteBucketReplicationResponse deleteBucketReplicationResponse = (DeleteBucketReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketReplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBucketReplicationRequest).withMarshaller((Marshaller)new DeleteBucketReplicationRequestMarshaller(this.protocolFactory)));
            return deleteBucketReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketReplication$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketTaggingResponse deleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBucketTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketTagging");
            DeleteBucketTaggingResponse deleteBucketTaggingResponse = (DeleteBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketTagging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBucketTaggingRequest).withMarshaller((Marshaller)new DeleteBucketTaggingRequestMarshaller(this.protocolFactory)));
            return deleteBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketTagging$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteJobTaggingResponse deleteJobTagging(DeleteJobTaggingRequest deleteJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteJobTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJobTagging");
            DeleteJobTaggingResponse deleteJobTaggingResponse = (DeleteJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJobTagging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteJobTaggingRequest).withMarshaller((Marshaller)new DeleteJobTaggingRequestMarshaller(this.protocolFactory)));
            return deleteJobTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteJobTagging$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMultiRegionAccessPointResponse deleteMultiRegionAccessPoint(DeleteMultiRegionAccessPointRequest deleteMultiRegionAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteMultiRegionAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMultiRegionAccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteMultiRegionAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMultiRegionAccessPoint");
            DeleteMultiRegionAccessPointResponse deleteMultiRegionAccessPointResponse = (DeleteMultiRegionAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMultiRegionAccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMultiRegionAccessPointRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new DeleteMultiRegionAccessPointRequestMarshaller(this.protocolFactory)));
            return deleteMultiRegionAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteMultiRegionAccessPoint$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePublicAccessBlockResponse deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePublicAccessBlockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deletePublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePublicAccessBlock");
            DeletePublicAccessBlockResponse deletePublicAccessBlockResponse = (DeletePublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicAccessBlock").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePublicAccessBlockRequest).withMarshaller((Marshaller)new DeletePublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return deletePublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deletePublicAccessBlock$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStorageLensConfigurationResponse deleteStorageLensConfiguration(DeleteStorageLensConfigurationRequest deleteStorageLensConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteStorageLensConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStorageLensConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStorageLensConfiguration");
            DeleteStorageLensConfigurationResponse deleteStorageLensConfigurationResponse = (DeleteStorageLensConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStorageLensConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteStorageLensConfigurationRequest).withMarshaller((Marshaller)new DeleteStorageLensConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteStorageLensConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteStorageLensConfiguration$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStorageLensConfigurationTaggingResponse deleteStorageLensConfigurationTagging(DeleteStorageLensConfigurationTaggingRequest deleteStorageLensConfigurationTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteStorageLensConfigurationTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStorageLensConfigurationTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, deleteStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStorageLensConfigurationTagging");
            DeleteStorageLensConfigurationTaggingResponse deleteStorageLensConfigurationTaggingResponse = (DeleteStorageLensConfigurationTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStorageLensConfigurationTagging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteStorageLensConfigurationTaggingRequest).withMarshaller((Marshaller)new DeleteStorageLensConfigurationTaggingRequestMarshaller(this.protocolFactory)));
            return deleteStorageLensConfigurationTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteStorageLensConfigurationTagging$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, describeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJob");
            DescribeJobResponse describeJobResponse = (DescribeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeJobRequest).withMarshaller((Marshaller)new DescribeJobRequestMarshaller(this.protocolFactory)));
            return describeJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$describeJob$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMultiRegionAccessPointOperationResponse describeMultiRegionAccessPointOperation(DescribeMultiRegionAccessPointOperationRequest describeMultiRegionAccessPointOperationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeMultiRegionAccessPointOperationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMultiRegionAccessPointOperationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, describeMultiRegionAccessPointOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiRegionAccessPointOperation");
            DescribeMultiRegionAccessPointOperationResponse describeMultiRegionAccessPointOperationResponse = (DescribeMultiRegionAccessPointOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiRegionAccessPointOperation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMultiRegionAccessPointOperationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new DescribeMultiRegionAccessPointOperationRequestMarshaller(this.protocolFactory)));
            return describeMultiRegionAccessPointOperationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$describeMultiRegionAccessPointOperation$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointResponse getAccessPoint(GetAccessPointRequest getAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPoint");
            GetAccessPointResponse getAccessPointResponse = (GetAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccessPointRequest).withMarshaller((Marshaller)new GetAccessPointRequestMarshaller(this.protocolFactory)));
            return getAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPoint$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointConfigurationForObjectLambdaResponse getAccessPointConfigurationForObjectLambda(GetAccessPointConfigurationForObjectLambdaRequest getAccessPointConfigurationForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointConfigurationForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccessPointConfigurationForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getAccessPointConfigurationForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointConfigurationForObjectLambda");
            GetAccessPointConfigurationForObjectLambdaResponse getAccessPointConfigurationForObjectLambdaResponse = (GetAccessPointConfigurationForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointConfigurationForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccessPointConfigurationForObjectLambdaRequest).withMarshaller((Marshaller)new GetAccessPointConfigurationForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return getAccessPointConfigurationForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointConfigurationForObjectLambda$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointForObjectLambdaResponse getAccessPointForObjectLambda(GetAccessPointForObjectLambdaRequest getAccessPointForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccessPointForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointForObjectLambda");
            GetAccessPointForObjectLambdaResponse getAccessPointForObjectLambdaResponse = (GetAccessPointForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccessPointForObjectLambdaRequest).withMarshaller((Marshaller)new GetAccessPointForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return getAccessPointForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointForObjectLambda$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyResponse getAccessPointPolicy(GetAccessPointPolicyRequest getAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccessPointPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicy");
            GetAccessPointPolicyResponse getAccessPointPolicyResponse = (GetAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccessPointPolicyRequest).withMarshaller((Marshaller)new GetAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicy$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyForObjectLambdaResponse getAccessPointPolicyForObjectLambda(GetAccessPointPolicyForObjectLambdaRequest getAccessPointPolicyForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccessPointPolicyForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyForObjectLambda");
            GetAccessPointPolicyForObjectLambdaResponse getAccessPointPolicyForObjectLambdaResponse = (GetAccessPointPolicyForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccessPointPolicyForObjectLambdaRequest).withMarshaller((Marshaller)new GetAccessPointPolicyForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicyForObjectLambda$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyStatusResponse getAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest getAccessPointPolicyStatusRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccessPointPolicyStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getAccessPointPolicyStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyStatus");
            GetAccessPointPolicyStatusResponse getAccessPointPolicyStatusResponse = (GetAccessPointPolicyStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccessPointPolicyStatusRequest).withMarshaller((Marshaller)new GetAccessPointPolicyStatusRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicyStatus$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyStatusForObjectLambdaResponse getAccessPointPolicyStatusForObjectLambda(GetAccessPointPolicyStatusForObjectLambdaRequest getAccessPointPolicyStatusForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyStatusForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccessPointPolicyStatusForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getAccessPointPolicyStatusForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyStatusForObjectLambda");
            GetAccessPointPolicyStatusForObjectLambdaResponse getAccessPointPolicyStatusForObjectLambdaResponse = (GetAccessPointPolicyStatusForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyStatusForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAccessPointPolicyStatusForObjectLambdaRequest).withMarshaller((Marshaller)new GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyStatusForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicyStatusForObjectLambda$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketResponse getBucket(GetBucketRequest getBucketRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucket");
            GetBucketResponse getBucketResponse = (GetBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketRequest).withMarshaller((Marshaller)new GetBucketRequestMarshaller(this.protocolFactory)));
            return getBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucket$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketLifecycleConfigurationResponse getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketLifecycleConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketLifecycleConfiguration");
            GetBucketLifecycleConfigurationResponse getBucketLifecycleConfigurationResponse = (GetBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLifecycleConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketLifecycleConfigurationRequest).withMarshaller((Marshaller)new GetBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketLifecycleConfiguration$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketPolicyResponse getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketPolicy");
            GetBucketPolicyResponse getBucketPolicyResponse = (GetBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketPolicyRequest).withMarshaller((Marshaller)new GetBucketPolicyRequestMarshaller(this.protocolFactory)));
            return getBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketPolicy$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketReplicationResponse getBucketReplication(GetBucketReplicationRequest getBucketReplicationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getBucketReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketReplication");
            GetBucketReplicationResponse getBucketReplicationResponse = (GetBucketReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketReplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketReplicationRequest).withMarshaller((Marshaller)new GetBucketReplicationRequestMarshaller(this.protocolFactory)));
            return getBucketReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketReplication$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketTaggingResponse getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketTagging");
            GetBucketTaggingResponse getBucketTaggingResponse = (GetBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketTagging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketTaggingRequest).withMarshaller((Marshaller)new GetBucketTaggingRequestMarshaller(this.protocolFactory)));
            return getBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketTagging$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketVersioningResponse getBucketVersioning(GetBucketVersioningRequest getBucketVersioningRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketVersioningResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBucketVersioningRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getBucketVersioningRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketVersioning");
            GetBucketVersioningResponse getBucketVersioningResponse = (GetBucketVersioningResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketVersioning").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBucketVersioningRequest).withMarshaller((Marshaller)new GetBucketVersioningRequestMarshaller(this.protocolFactory)));
            return getBucketVersioningResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketVersioning$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobTaggingResponse getJobTagging(GetJobTaggingRequest getJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobTagging");
            GetJobTaggingResponse getJobTaggingResponse = (GetJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobTagging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getJobTaggingRequest).withMarshaller((Marshaller)new GetJobTaggingRequestMarshaller(this.protocolFactory)));
            return getJobTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getJobTagging$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMultiRegionAccessPointResponse getMultiRegionAccessPoint(GetMultiRegionAccessPointRequest getMultiRegionAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMultiRegionAccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getMultiRegionAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPoint");
            GetMultiRegionAccessPointResponse getMultiRegionAccessPointResponse = (GetMultiRegionAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMultiRegionAccessPointRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new GetMultiRegionAccessPointRequestMarshaller(this.protocolFactory)));
            return getMultiRegionAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getMultiRegionAccessPoint$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMultiRegionAccessPointPolicyResponse getMultiRegionAccessPointPolicy(GetMultiRegionAccessPointPolicyRequest getMultiRegionAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMultiRegionAccessPointPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getMultiRegionAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPointPolicy");
            GetMultiRegionAccessPointPolicyResponse getMultiRegionAccessPointPolicyResponse = (GetMultiRegionAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPointPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMultiRegionAccessPointPolicyRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new GetMultiRegionAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return getMultiRegionAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getMultiRegionAccessPointPolicy$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMultiRegionAccessPointPolicyStatusResponse getMultiRegionAccessPointPolicyStatus(GetMultiRegionAccessPointPolicyStatusRequest getMultiRegionAccessPointPolicyStatusRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMultiRegionAccessPointPolicyStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getMultiRegionAccessPointPolicyStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPointPolicyStatus");
            GetMultiRegionAccessPointPolicyStatusResponse getMultiRegionAccessPointPolicyStatusResponse = (GetMultiRegionAccessPointPolicyStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPointPolicyStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMultiRegionAccessPointPolicyStatusRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new GetMultiRegionAccessPointPolicyStatusRequestMarshaller(this.protocolFactory)));
            return getMultiRegionAccessPointPolicyStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getMultiRegionAccessPointPolicyStatus$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMultiRegionAccessPointRoutesResponse getMultiRegionAccessPointRoutes(GetMultiRegionAccessPointRoutesRequest getMultiRegionAccessPointRoutesRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointRoutesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMultiRegionAccessPointRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getMultiRegionAccessPointRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPointRoutes");
            GetMultiRegionAccessPointRoutesResponse getMultiRegionAccessPointRoutesResponse = (GetMultiRegionAccessPointRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPointRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMultiRegionAccessPointRoutesRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new GetMultiRegionAccessPointRoutesRequestMarshaller(this.protocolFactory)));
            return getMultiRegionAccessPointRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getMultiRegionAccessPointRoutes$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPublicAccessBlockResponse getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) throws NoSuchPublicAccessBlockConfigurationException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPublicAccessBlockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicAccessBlock");
            GetPublicAccessBlockResponse getPublicAccessBlockResponse = (GetPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicAccessBlock").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPublicAccessBlockRequest).withMarshaller((Marshaller)new GetPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return getPublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getPublicAccessBlock$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStorageLensConfigurationResponse getStorageLensConfiguration(GetStorageLensConfigurationRequest getStorageLensConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStorageLensConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getStorageLensConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStorageLensConfiguration");
            GetStorageLensConfigurationResponse getStorageLensConfigurationResponse = (GetStorageLensConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStorageLensConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getStorageLensConfigurationRequest).withMarshaller((Marshaller)new GetStorageLensConfigurationRequestMarshaller(this.protocolFactory)));
            return getStorageLensConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getStorageLensConfiguration$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStorageLensConfigurationTaggingResponse getStorageLensConfigurationTagging(GetStorageLensConfigurationTaggingRequest getStorageLensConfigurationTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStorageLensConfigurationTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getStorageLensConfigurationTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, getStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStorageLensConfigurationTagging");
            GetStorageLensConfigurationTaggingResponse getStorageLensConfigurationTaggingResponse = (GetStorageLensConfigurationTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStorageLensConfigurationTagging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getStorageLensConfigurationTaggingRequest).withMarshaller((Marshaller)new GetStorageLensConfigurationTaggingRequestMarshaller(this.protocolFactory)));
            return getStorageLensConfigurationTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getStorageLensConfigurationTagging$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccessPointsResponse listAccessPoints(ListAccessPointsRequest listAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListAccessPointsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAccessPointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, listAccessPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPoints");
            ListAccessPointsResponse listAccessPointsResponse = (ListAccessPointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAccessPointsRequest).withMarshaller((Marshaller)new ListAccessPointsRequestMarshaller(this.protocolFactory)));
            return listAccessPointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listAccessPoints$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccessPointsForObjectLambdaResponse listAccessPointsForObjectLambda(ListAccessPointsForObjectLambdaRequest listAccessPointsForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListAccessPointsForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAccessPointsForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, listAccessPointsForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPointsForObjectLambda");
            ListAccessPointsForObjectLambdaResponse listAccessPointsForObjectLambdaResponse = (ListAccessPointsForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPointsForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAccessPointsForObjectLambdaRequest).withMarshaller((Marshaller)new ListAccessPointsForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return listAccessPointsForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listAccessPointsForObjectLambda$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListJobsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            ListJobsResponse listJobsResponse = (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listJobsRequest).withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)));
            return listJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listJobs$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultiRegionAccessPointsResponse listMultiRegionAccessPoints(ListMultiRegionAccessPointsRequest listMultiRegionAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListMultiRegionAccessPointsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMultiRegionAccessPointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, listMultiRegionAccessPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMultiRegionAccessPoints");
            ListMultiRegionAccessPointsResponse listMultiRegionAccessPointsResponse = (ListMultiRegionAccessPointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultiRegionAccessPoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMultiRegionAccessPointsRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new ListMultiRegionAccessPointsRequestMarshaller(this.protocolFactory)));
            return listMultiRegionAccessPointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listMultiRegionAccessPoints$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRegionalBucketsResponse listRegionalBuckets(ListRegionalBucketsRequest listRegionalBucketsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListRegionalBucketsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRegionalBucketsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, listRegionalBucketsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRegionalBuckets");
            ListRegionalBucketsResponse listRegionalBucketsResponse = (ListRegionalBucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRegionalBuckets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRegionalBucketsRequest).withMarshaller((Marshaller)new ListRegionalBucketsRequestMarshaller(this.protocolFactory)));
            return listRegionalBucketsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listRegionalBuckets$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStorageLensConfigurationsResponse listStorageLensConfigurations(ListStorageLensConfigurationsRequest listStorageLensConfigurationsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListStorageLensConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStorageLensConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, listStorageLensConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStorageLensConfigurations");
            ListStorageLensConfigurationsResponse listStorageLensConfigurationsResponse = (ListStorageLensConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStorageLensConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listStorageLensConfigurationsRequest).withMarshaller((Marshaller)new ListStorageLensConfigurationsRequestMarshaller(this.protocolFactory)));
            return listStorageLensConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listStorageLensConfigurations$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccessPointConfigurationForObjectLambdaResponse putAccessPointConfigurationForObjectLambda(PutAccessPointConfigurationForObjectLambdaRequest putAccessPointConfigurationForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointConfigurationForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccessPointConfigurationForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putAccessPointConfigurationForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointConfigurationForObjectLambda");
            PutAccessPointConfigurationForObjectLambdaResponse putAccessPointConfigurationForObjectLambdaResponse = (PutAccessPointConfigurationForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointConfigurationForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccessPointConfigurationForObjectLambdaRequest).withMarshaller((Marshaller)new PutAccessPointConfigurationForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return putAccessPointConfigurationForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putAccessPointConfigurationForObjectLambda$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccessPointPolicyResponse putAccessPointPolicy(PutAccessPointPolicyRequest putAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccessPointPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointPolicy");
            PutAccessPointPolicyResponse putAccessPointPolicyResponse = (PutAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccessPointPolicyRequest).withMarshaller((Marshaller)new PutAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return putAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putAccessPointPolicy$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccessPointPolicyForObjectLambdaResponse putAccessPointPolicyForObjectLambda(PutAccessPointPolicyForObjectLambdaRequest putAccessPointPolicyForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointPolicyForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccessPointPolicyForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointPolicyForObjectLambda");
            PutAccessPointPolicyForObjectLambdaResponse putAccessPointPolicyForObjectLambdaResponse = (PutAccessPointPolicyForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointPolicyForObjectLambda").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccessPointPolicyForObjectLambdaRequest).withMarshaller((Marshaller)new PutAccessPointPolicyForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return putAccessPointPolicyForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putAccessPointPolicyForObjectLambda$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketLifecycleConfigurationResponse putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putBucketLifecycleConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketLifecycleConfiguration");
            PutBucketLifecycleConfigurationResponse putBucketLifecycleConfigurationResponse = (PutBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLifecycleConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putBucketLifecycleConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new PutBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketLifecycleConfiguration$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketPolicyResponse putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putBucketPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketPolicy");
            PutBucketPolicyResponse putBucketPolicyResponse = (PutBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putBucketPolicyRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new PutBucketPolicyRequestMarshaller(this.protocolFactory)));
            return putBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketPolicy$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketReplicationResponse putBucketReplication(PutBucketReplicationRequest putBucketReplicationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putBucketReplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putBucketReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketReplication");
            PutBucketReplicationResponse putBucketReplicationResponse = (PutBucketReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketReplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putBucketReplicationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new PutBucketReplicationRequestMarshaller(this.protocolFactory)));
            return putBucketReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketReplication$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketTaggingResponse putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putBucketTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketTagging");
            PutBucketTaggingResponse putBucketTaggingResponse = (PutBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketTagging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putBucketTaggingRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new PutBucketTaggingRequestMarshaller(this.protocolFactory)));
            return putBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketTagging$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketVersioningResponse putBucketVersioning(PutBucketVersioningRequest putBucketVersioningRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketVersioningResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putBucketVersioningRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putBucketVersioningRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketVersioning");
            PutBucketVersioningResponse putBucketVersioningResponse = (PutBucketVersioningResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketVersioning").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putBucketVersioningRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new PutBucketVersioningRequestMarshaller(this.protocolFactory)));
            return putBucketVersioningResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketVersioning$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutJobTaggingResponse putJobTagging(PutJobTaggingRequest putJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putJobTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobTagging");
            PutJobTaggingResponse putJobTaggingResponse = (PutJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobTagging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putJobTaggingRequest).withMarshaller((Marshaller)new PutJobTaggingRequestMarshaller(this.protocolFactory)));
            return putJobTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putJobTagging$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutMultiRegionAccessPointPolicyResponse putMultiRegionAccessPointPolicy(PutMultiRegionAccessPointPolicyRequest putMultiRegionAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutMultiRegionAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putMultiRegionAccessPointPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putMultiRegionAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMultiRegionAccessPointPolicy");
            PutMultiRegionAccessPointPolicyResponse putMultiRegionAccessPointPolicyResponse = (PutMultiRegionAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMultiRegionAccessPointPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putMultiRegionAccessPointPolicyRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new PutMultiRegionAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return putMultiRegionAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putMultiRegionAccessPointPolicy$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPublicAccessBlockResponse putPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putPublicAccessBlockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPublicAccessBlock");
            PutPublicAccessBlockResponse putPublicAccessBlockResponse = (PutPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPublicAccessBlock").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putPublicAccessBlockRequest).withMarshaller((Marshaller)new PutPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return putPublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putPublicAccessBlock$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutStorageLensConfigurationResponse putStorageLensConfiguration(PutStorageLensConfigurationRequest putStorageLensConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutStorageLensConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putStorageLensConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutStorageLensConfiguration");
            PutStorageLensConfigurationResponse putStorageLensConfigurationResponse = (PutStorageLensConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutStorageLensConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putStorageLensConfigurationRequest).withMarshaller((Marshaller)new PutStorageLensConfigurationRequestMarshaller(this.protocolFactory)));
            return putStorageLensConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putStorageLensConfiguration$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutStorageLensConfigurationTaggingResponse putStorageLensConfigurationTagging(PutStorageLensConfigurationTaggingRequest putStorageLensConfigurationTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutStorageLensConfigurationTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putStorageLensConfigurationTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, putStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutStorageLensConfigurationTagging");
            PutStorageLensConfigurationTaggingResponse putStorageLensConfigurationTaggingResponse = (PutStorageLensConfigurationTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutStorageLensConfigurationTagging").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putStorageLensConfigurationTaggingRequest).withMarshaller((Marshaller)new PutStorageLensConfigurationTaggingRequestMarshaller(this.protocolFactory)));
            return putStorageLensConfigurationTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putStorageLensConfigurationTagging$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitMultiRegionAccessPointRoutesResponse submitMultiRegionAccessPointRoutes(SubmitMultiRegionAccessPointRoutesRequest submitMultiRegionAccessPointRoutesRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(SubmitMultiRegionAccessPointRoutesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)submitMultiRegionAccessPointRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, submitMultiRegionAccessPointRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitMultiRegionAccessPointRoutes");
            SubmitMultiRegionAccessPointRoutesResponse submitMultiRegionAccessPointRoutesResponse = (SubmitMultiRegionAccessPointRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitMultiRegionAccessPointRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)submitMultiRegionAccessPointRoutesRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new SubmitMultiRegionAccessPointRoutesRequestMarshaller(this.protocolFactory)));
            return submitMultiRegionAccessPointRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$submitMultiRegionAccessPointRoutes$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobPriorityResponse updateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobPriorityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateJobPriorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, updateJobPriorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobPriority");
            UpdateJobPriorityResponse updateJobPriorityResponse = (UpdateJobPriorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobPriority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateJobPriorityRequest).withMarshaller((Marshaller)new UpdateJobPriorityRequestMarshaller(this.protocolFactory)));
            return updateJobPriorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$updateJobPriority$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobStatusResponse updateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, JobStatusException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateJobStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(clientConfiguration, updateJobStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobStatus");
            UpdateJobStatusResponse updateJobStatusResponse = (UpdateJobStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateJobStatusRequest).withMarshaller((Marshaller)new UpdateJobStatusRequestMarshaller(this.protocolFactory)));
            return updateJobStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$updateJobStatus$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "s3";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        S3ControlServiceClientConfigurationBuilder serviceConfigBuilder = new S3ControlServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("JobStatusException").exceptionBuilderSupplier(JobStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchPublicAccessBlockConfiguration").exceptionBuilderSupplier(NoSuchPublicAccessBlockConfigurationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyExists").exceptionBuilderSupplier(BucketAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotencyException").exceptionBuilderSupplier(IdempotencyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyOwnedByYou").exceptionBuilderSupplier(BucketAlreadyOwnedByYouException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(S3ControlException::builder).build();
    }

    @Override
    public final S3ControlServiceClientConfiguration serviceClientConfiguration() {
        return new S3ControlServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateJobStatus$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJobPriority$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitMultiRegionAccessPointRoutes$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putStorageLensConfigurationTagging$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putStorageLensConfiguration$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPublicAccessBlock$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMultiRegionAccessPointPolicy$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobTagging$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketVersioning$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketTagging$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketReplication$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketPolicy$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketLifecycleConfiguration$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointPolicyForObjectLambda$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointPolicy$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointConfigurationForObjectLambda$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStorageLensConfigurations$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRegionalBuckets$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMultiRegionAccessPoints$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobs$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessPointsForObjectLambda$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessPoints$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStorageLensConfigurationTagging$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStorageLensConfiguration$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicAccessBlock$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPointRoutes$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPointPolicyStatus$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPointPolicy$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPoint$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobTagging$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketVersioning$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketTagging$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketReplication$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketPolicy$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketLifecycleConfiguration$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucket$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyStatusForObjectLambda$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyStatus$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyForObjectLambda$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicy$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointForObjectLambda$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointConfigurationForObjectLambda$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPoint$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiRegionAccessPointOperation$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJob$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStorageLensConfigurationTagging$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStorageLensConfiguration$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePublicAccessBlock$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMultiRegionAccessPoint$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJobTagging$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketTagging$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketReplication$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketPolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketLifecycleConfiguration$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucket$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointPolicyForObjectLambda$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointPolicy$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointForObjectLambda$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPoint$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMultiRegionAccessPoint$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucket$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPointForObjectLambda$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPoint$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

