/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation that you want this job to perform on every object listed in the manifest. For more information about
 * the available operations, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html">Operations</a> in the <i>Amazon S3
 * User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobOperation implements SdkPojo, Serializable, ToCopyableBuilder<JobOperation.Builder, JobOperation> {
    private static final SdkField<LambdaInvokeOperation> LAMBDA_INVOKE_FIELD = SdkField
            .<LambdaInvokeOperation> builder(MarshallingType.SDK_POJO)
            .memberName("LambdaInvoke")
            .getter(getter(JobOperation::lambdaInvoke))
            .setter(setter(Builder::lambdaInvoke))
            .constructor(LambdaInvokeOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaInvoke")
                    .unmarshallLocationName("LambdaInvoke").build()).build();

    private static final SdkField<S3CopyObjectOperation> S3_PUT_OBJECT_COPY_FIELD = SdkField
            .<S3CopyObjectOperation> builder(MarshallingType.SDK_POJO)
            .memberName("S3PutObjectCopy")
            .getter(getter(JobOperation::s3PutObjectCopy))
            .setter(setter(Builder::s3PutObjectCopy))
            .constructor(S3CopyObjectOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectCopy")
                    .unmarshallLocationName("S3PutObjectCopy").build()).build();

    private static final SdkField<S3SetObjectAclOperation> S3_PUT_OBJECT_ACL_FIELD = SdkField
            .<S3SetObjectAclOperation> builder(MarshallingType.SDK_POJO)
            .memberName("S3PutObjectAcl")
            .getter(getter(JobOperation::s3PutObjectAcl))
            .setter(setter(Builder::s3PutObjectAcl))
            .constructor(S3SetObjectAclOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectAcl")
                    .unmarshallLocationName("S3PutObjectAcl").build()).build();

    private static final SdkField<S3SetObjectTaggingOperation> S3_PUT_OBJECT_TAGGING_FIELD = SdkField
            .<S3SetObjectTaggingOperation> builder(MarshallingType.SDK_POJO)
            .memberName("S3PutObjectTagging")
            .getter(getter(JobOperation::s3PutObjectTagging))
            .setter(setter(Builder::s3PutObjectTagging))
            .constructor(S3SetObjectTaggingOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectTagging")
                    .unmarshallLocationName("S3PutObjectTagging").build()).build();

    private static final SdkField<S3DeleteObjectTaggingOperation> S3_DELETE_OBJECT_TAGGING_FIELD = SdkField
            .<S3DeleteObjectTaggingOperation> builder(MarshallingType.SDK_POJO)
            .memberName("S3DeleteObjectTagging")
            .getter(getter(JobOperation::s3DeleteObjectTagging))
            .setter(setter(Builder::s3DeleteObjectTagging))
            .constructor(S3DeleteObjectTaggingOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DeleteObjectTagging")
                    .unmarshallLocationName("S3DeleteObjectTagging").build()).build();

    private static final SdkField<S3InitiateRestoreObjectOperation> S3_INITIATE_RESTORE_OBJECT_FIELD = SdkField
            .<S3InitiateRestoreObjectOperation> builder(MarshallingType.SDK_POJO)
            .memberName("S3InitiateRestoreObject")
            .getter(getter(JobOperation::s3InitiateRestoreObject))
            .setter(setter(Builder::s3InitiateRestoreObject))
            .constructor(S3InitiateRestoreObjectOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InitiateRestoreObject")
                    .unmarshallLocationName("S3InitiateRestoreObject").build()).build();

    private static final SdkField<S3SetObjectLegalHoldOperation> S3_PUT_OBJECT_LEGAL_HOLD_FIELD = SdkField
            .<S3SetObjectLegalHoldOperation> builder(MarshallingType.SDK_POJO)
            .memberName("S3PutObjectLegalHold")
            .getter(getter(JobOperation::s3PutObjectLegalHold))
            .setter(setter(Builder::s3PutObjectLegalHold))
            .constructor(S3SetObjectLegalHoldOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectLegalHold")
                    .unmarshallLocationName("S3PutObjectLegalHold").build()).build();

    private static final SdkField<S3SetObjectRetentionOperation> S3_PUT_OBJECT_RETENTION_FIELD = SdkField
            .<S3SetObjectRetentionOperation> builder(MarshallingType.SDK_POJO)
            .memberName("S3PutObjectRetention")
            .getter(getter(JobOperation::s3PutObjectRetention))
            .setter(setter(Builder::s3PutObjectRetention))
            .constructor(S3SetObjectRetentionOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectRetention")
                    .unmarshallLocationName("S3PutObjectRetention").build()).build();

    private static final SdkField<S3ReplicateObjectOperation> S3_REPLICATE_OBJECT_FIELD = SdkField
            .<S3ReplicateObjectOperation> builder(MarshallingType.SDK_POJO)
            .memberName("S3ReplicateObject")
            .getter(getter(JobOperation::s3ReplicateObject))
            .setter(setter(Builder::s3ReplicateObject))
            .constructor(S3ReplicateObjectOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ReplicateObject")
                    .unmarshallLocationName("S3ReplicateObject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_INVOKE_FIELD,
            S3_PUT_OBJECT_COPY_FIELD, S3_PUT_OBJECT_ACL_FIELD, S3_PUT_OBJECT_TAGGING_FIELD, S3_DELETE_OBJECT_TAGGING_FIELD,
            S3_INITIATE_RESTORE_OBJECT_FIELD, S3_PUT_OBJECT_LEGAL_HOLD_FIELD, S3_PUT_OBJECT_RETENTION_FIELD,
            S3_REPLICATE_OBJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final LambdaInvokeOperation lambdaInvoke;

    private final S3CopyObjectOperation s3PutObjectCopy;

    private final S3SetObjectAclOperation s3PutObjectAcl;

    private final S3SetObjectTaggingOperation s3PutObjectTagging;

    private final S3DeleteObjectTaggingOperation s3DeleteObjectTagging;

    private final S3InitiateRestoreObjectOperation s3InitiateRestoreObject;

    private final S3SetObjectLegalHoldOperation s3PutObjectLegalHold;

    private final S3SetObjectRetentionOperation s3PutObjectRetention;

    private final S3ReplicateObjectOperation s3ReplicateObject;

    private JobOperation(BuilderImpl builder) {
        this.lambdaInvoke = builder.lambdaInvoke;
        this.s3PutObjectCopy = builder.s3PutObjectCopy;
        this.s3PutObjectAcl = builder.s3PutObjectAcl;
        this.s3PutObjectTagging = builder.s3PutObjectTagging;
        this.s3DeleteObjectTagging = builder.s3DeleteObjectTagging;
        this.s3InitiateRestoreObject = builder.s3InitiateRestoreObject;
        this.s3PutObjectLegalHold = builder.s3PutObjectLegalHold;
        this.s3PutObjectRetention = builder.s3PutObjectRetention;
        this.s3ReplicateObject = builder.s3ReplicateObject;
    }

    /**
     * <p>
     * Directs the specified job to invoke an Lambda function on every object in the manifest.
     * </p>
     * 
     * @return Directs the specified job to invoke an Lambda function on every object in the manifest.
     */
    public final LambdaInvokeOperation lambdaInvoke() {
        return lambdaInvoke;
    }

    /**
     * <p>
     * Directs the specified job to run a PUT Copy object call on every object in the manifest.
     * </p>
     * 
     * @return Directs the specified job to run a PUT Copy object call on every object in the manifest.
     */
    public final S3CopyObjectOperation s3PutObjectCopy() {
        return s3PutObjectCopy;
    }

    /**
     * <p>
     * Directs the specified job to run a <code>PutObjectAcl</code> call on every object in the manifest.
     * </p>
     * 
     * @return Directs the specified job to run a <code>PutObjectAcl</code> call on every object in the manifest.
     */
    public final S3SetObjectAclOperation s3PutObjectAcl() {
        return s3PutObjectAcl;
    }

    /**
     * <p>
     * Directs the specified job to run a PUT Object tagging call on every object in the manifest.
     * </p>
     * 
     * @return Directs the specified job to run a PUT Object tagging call on every object in the manifest.
     */
    public final S3SetObjectTaggingOperation s3PutObjectTagging() {
        return s3PutObjectTagging;
    }

    /**
     * <p>
     * Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.
     * </p>
     * 
     * @return Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.
     */
    public final S3DeleteObjectTaggingOperation s3DeleteObjectTagging() {
        return s3DeleteObjectTagging;
    }

    /**
     * <p>
     * Directs the specified job to initiate restore requests for every archived object in the manifest.
     * </p>
     * 
     * @return Directs the specified job to initiate restore requests for every archived object in the manifest.
     */
    public final S3InitiateRestoreObjectOperation s3InitiateRestoreObject() {
        return s3InitiateRestoreObject;
    }

    /**
     * Returns the value of the S3PutObjectLegalHold property for this object.
     * 
     * @return The value of the S3PutObjectLegalHold property for this object.
     */
    public final S3SetObjectLegalHoldOperation s3PutObjectLegalHold() {
        return s3PutObjectLegalHold;
    }

    /**
     * Returns the value of the S3PutObjectRetention property for this object.
     * 
     * @return The value of the S3PutObjectRetention property for this object.
     */
    public final S3SetObjectRetentionOperation s3PutObjectRetention() {
        return s3PutObjectRetention;
    }

    /**
     * <p>
     * Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's manifest.
     * </p>
     * 
     * @return Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's manifest.
     */
    public final S3ReplicateObjectOperation s3ReplicateObject() {
        return s3ReplicateObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaInvoke());
        hashCode = 31 * hashCode + Objects.hashCode(s3PutObjectCopy());
        hashCode = 31 * hashCode + Objects.hashCode(s3PutObjectAcl());
        hashCode = 31 * hashCode + Objects.hashCode(s3PutObjectTagging());
        hashCode = 31 * hashCode + Objects.hashCode(s3DeleteObjectTagging());
        hashCode = 31 * hashCode + Objects.hashCode(s3InitiateRestoreObject());
        hashCode = 31 * hashCode + Objects.hashCode(s3PutObjectLegalHold());
        hashCode = 31 * hashCode + Objects.hashCode(s3PutObjectRetention());
        hashCode = 31 * hashCode + Objects.hashCode(s3ReplicateObject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobOperation)) {
            return false;
        }
        JobOperation other = (JobOperation) obj;
        return Objects.equals(lambdaInvoke(), other.lambdaInvoke()) && Objects.equals(s3PutObjectCopy(), other.s3PutObjectCopy())
                && Objects.equals(s3PutObjectAcl(), other.s3PutObjectAcl())
                && Objects.equals(s3PutObjectTagging(), other.s3PutObjectTagging())
                && Objects.equals(s3DeleteObjectTagging(), other.s3DeleteObjectTagging())
                && Objects.equals(s3InitiateRestoreObject(), other.s3InitiateRestoreObject())
                && Objects.equals(s3PutObjectLegalHold(), other.s3PutObjectLegalHold())
                && Objects.equals(s3PutObjectRetention(), other.s3PutObjectRetention())
                && Objects.equals(s3ReplicateObject(), other.s3ReplicateObject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobOperation").add("LambdaInvoke", lambdaInvoke()).add("S3PutObjectCopy", s3PutObjectCopy())
                .add("S3PutObjectAcl", s3PutObjectAcl()).add("S3PutObjectTagging", s3PutObjectTagging())
                .add("S3DeleteObjectTagging", s3DeleteObjectTagging()).add("S3InitiateRestoreObject", s3InitiateRestoreObject())
                .add("S3PutObjectLegalHold", s3PutObjectLegalHold()).add("S3PutObjectRetention", s3PutObjectRetention())
                .add("S3ReplicateObject", s3ReplicateObject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaInvoke":
            return Optional.ofNullable(clazz.cast(lambdaInvoke()));
        case "S3PutObjectCopy":
            return Optional.ofNullable(clazz.cast(s3PutObjectCopy()));
        case "S3PutObjectAcl":
            return Optional.ofNullable(clazz.cast(s3PutObjectAcl()));
        case "S3PutObjectTagging":
            return Optional.ofNullable(clazz.cast(s3PutObjectTagging()));
        case "S3DeleteObjectTagging":
            return Optional.ofNullable(clazz.cast(s3DeleteObjectTagging()));
        case "S3InitiateRestoreObject":
            return Optional.ofNullable(clazz.cast(s3InitiateRestoreObject()));
        case "S3PutObjectLegalHold":
            return Optional.ofNullable(clazz.cast(s3PutObjectLegalHold()));
        case "S3PutObjectRetention":
            return Optional.ofNullable(clazz.cast(s3PutObjectRetention()));
        case "S3ReplicateObject":
            return Optional.ofNullable(clazz.cast(s3ReplicateObject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobOperation, T> g) {
        return obj -> g.apply((JobOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobOperation> {
        /**
         * <p>
         * Directs the specified job to invoke an Lambda function on every object in the manifest.
         * </p>
         * 
         * @param lambdaInvoke
         *        Directs the specified job to invoke an Lambda function on every object in the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaInvoke(LambdaInvokeOperation lambdaInvoke);

        /**
         * <p>
         * Directs the specified job to invoke an Lambda function on every object in the manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaInvokeOperation.Builder} avoiding
         * the need to create one manually via {@link LambdaInvokeOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaInvokeOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaInvoke(LambdaInvokeOperation)}.
         * 
         * @param lambdaInvoke
         *        a consumer that will call methods on {@link LambdaInvokeOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaInvoke(LambdaInvokeOperation)
         */
        default Builder lambdaInvoke(Consumer<LambdaInvokeOperation.Builder> lambdaInvoke) {
            return lambdaInvoke(LambdaInvokeOperation.builder().applyMutation(lambdaInvoke).build());
        }

        /**
         * <p>
         * Directs the specified job to run a PUT Copy object call on every object in the manifest.
         * </p>
         * 
         * @param s3PutObjectCopy
         *        Directs the specified job to run a PUT Copy object call on every object in the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3PutObjectCopy(S3CopyObjectOperation s3PutObjectCopy);

        /**
         * <p>
         * Directs the specified job to run a PUT Copy object call on every object in the manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3CopyObjectOperation.Builder} avoiding
         * the need to create one manually via {@link S3CopyObjectOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3CopyObjectOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #s3PutObjectCopy(S3CopyObjectOperation)}.
         * 
         * @param s3PutObjectCopy
         *        a consumer that will call methods on {@link S3CopyObjectOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3PutObjectCopy(S3CopyObjectOperation)
         */
        default Builder s3PutObjectCopy(Consumer<S3CopyObjectOperation.Builder> s3PutObjectCopy) {
            return s3PutObjectCopy(S3CopyObjectOperation.builder().applyMutation(s3PutObjectCopy).build());
        }

        /**
         * <p>
         * Directs the specified job to run a <code>PutObjectAcl</code> call on every object in the manifest.
         * </p>
         * 
         * @param s3PutObjectAcl
         *        Directs the specified job to run a <code>PutObjectAcl</code> call on every object in the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3PutObjectAcl(S3SetObjectAclOperation s3PutObjectAcl);

        /**
         * <p>
         * Directs the specified job to run a <code>PutObjectAcl</code> call on every object in the manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3SetObjectAclOperation.Builder} avoiding
         * the need to create one manually via {@link S3SetObjectAclOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3SetObjectAclOperation.Builder#build()} is called immediately
         * and its result is passed to {@link #s3PutObjectAcl(S3SetObjectAclOperation)}.
         * 
         * @param s3PutObjectAcl
         *        a consumer that will call methods on {@link S3SetObjectAclOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3PutObjectAcl(S3SetObjectAclOperation)
         */
        default Builder s3PutObjectAcl(Consumer<S3SetObjectAclOperation.Builder> s3PutObjectAcl) {
            return s3PutObjectAcl(S3SetObjectAclOperation.builder().applyMutation(s3PutObjectAcl).build());
        }

        /**
         * <p>
         * Directs the specified job to run a PUT Object tagging call on every object in the manifest.
         * </p>
         * 
         * @param s3PutObjectTagging
         *        Directs the specified job to run a PUT Object tagging call on every object in the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3PutObjectTagging(S3SetObjectTaggingOperation s3PutObjectTagging);

        /**
         * <p>
         * Directs the specified job to run a PUT Object tagging call on every object in the manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3SetObjectTaggingOperation.Builder}
         * avoiding the need to create one manually via {@link S3SetObjectTaggingOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3SetObjectTaggingOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #s3PutObjectTagging(S3SetObjectTaggingOperation)}.
         * 
         * @param s3PutObjectTagging
         *        a consumer that will call methods on {@link S3SetObjectTaggingOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3PutObjectTagging(S3SetObjectTaggingOperation)
         */
        default Builder s3PutObjectTagging(Consumer<S3SetObjectTaggingOperation.Builder> s3PutObjectTagging) {
            return s3PutObjectTagging(S3SetObjectTaggingOperation.builder().applyMutation(s3PutObjectTagging).build());
        }

        /**
         * <p>
         * Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.
         * </p>
         * 
         * @param s3DeleteObjectTagging
         *        Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DeleteObjectTagging(S3DeleteObjectTaggingOperation s3DeleteObjectTagging);

        /**
         * <p>
         * Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DeleteObjectTaggingOperation.Builder}
         * avoiding the need to create one manually via {@link S3DeleteObjectTaggingOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DeleteObjectTaggingOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #s3DeleteObjectTagging(S3DeleteObjectTaggingOperation)}.
         * 
         * @param s3DeleteObjectTagging
         *        a consumer that will call methods on {@link S3DeleteObjectTaggingOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DeleteObjectTagging(S3DeleteObjectTaggingOperation)
         */
        default Builder s3DeleteObjectTagging(Consumer<S3DeleteObjectTaggingOperation.Builder> s3DeleteObjectTagging) {
            return s3DeleteObjectTagging(S3DeleteObjectTaggingOperation.builder().applyMutation(s3DeleteObjectTagging).build());
        }

        /**
         * <p>
         * Directs the specified job to initiate restore requests for every archived object in the manifest.
         * </p>
         * 
         * @param s3InitiateRestoreObject
         *        Directs the specified job to initiate restore requests for every archived object in the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3InitiateRestoreObject(S3InitiateRestoreObjectOperation s3InitiateRestoreObject);

        /**
         * <p>
         * Directs the specified job to initiate restore requests for every archived object in the manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3InitiateRestoreObjectOperation.Builder}
         * avoiding the need to create one manually via {@link S3InitiateRestoreObjectOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3InitiateRestoreObjectOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #s3InitiateRestoreObject(S3InitiateRestoreObjectOperation)}.
         * 
         * @param s3InitiateRestoreObject
         *        a consumer that will call methods on {@link S3InitiateRestoreObjectOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3InitiateRestoreObject(S3InitiateRestoreObjectOperation)
         */
        default Builder s3InitiateRestoreObject(Consumer<S3InitiateRestoreObjectOperation.Builder> s3InitiateRestoreObject) {
            return s3InitiateRestoreObject(S3InitiateRestoreObjectOperation.builder().applyMutation(s3InitiateRestoreObject)
                    .build());
        }

        /**
         * Sets the value of the S3PutObjectLegalHold property for this object.
         *
         * @param s3PutObjectLegalHold
         *        The new value for the S3PutObjectLegalHold property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3PutObjectLegalHold(S3SetObjectLegalHoldOperation s3PutObjectLegalHold);

        /**
         * Sets the value of the S3PutObjectLegalHold property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3SetObjectLegalHoldOperation.Builder}
         * avoiding the need to create one manually via {@link S3SetObjectLegalHoldOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3SetObjectLegalHoldOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #s3PutObjectLegalHold(S3SetObjectLegalHoldOperation)}.
         * 
         * @param s3PutObjectLegalHold
         *        a consumer that will call methods on {@link S3SetObjectLegalHoldOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3PutObjectLegalHold(S3SetObjectLegalHoldOperation)
         */
        default Builder s3PutObjectLegalHold(Consumer<S3SetObjectLegalHoldOperation.Builder> s3PutObjectLegalHold) {
            return s3PutObjectLegalHold(S3SetObjectLegalHoldOperation.builder().applyMutation(s3PutObjectLegalHold).build());
        }

        /**
         * Sets the value of the S3PutObjectRetention property for this object.
         *
         * @param s3PutObjectRetention
         *        The new value for the S3PutObjectRetention property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3PutObjectRetention(S3SetObjectRetentionOperation s3PutObjectRetention);

        /**
         * Sets the value of the S3PutObjectRetention property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3SetObjectRetentionOperation.Builder}
         * avoiding the need to create one manually via {@link S3SetObjectRetentionOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3SetObjectRetentionOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #s3PutObjectRetention(S3SetObjectRetentionOperation)}.
         * 
         * @param s3PutObjectRetention
         *        a consumer that will call methods on {@link S3SetObjectRetentionOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3PutObjectRetention(S3SetObjectRetentionOperation)
         */
        default Builder s3PutObjectRetention(Consumer<S3SetObjectRetentionOperation.Builder> s3PutObjectRetention) {
            return s3PutObjectRetention(S3SetObjectRetentionOperation.builder().applyMutation(s3PutObjectRetention).build());
        }

        /**
         * <p>
         * Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's manifest.
         * </p>
         * 
         * @param s3ReplicateObject
         *        Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's
         *        manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ReplicateObject(S3ReplicateObjectOperation s3ReplicateObject);

        /**
         * <p>
         * Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ReplicateObjectOperation.Builder}
         * avoiding the need to create one manually via {@link S3ReplicateObjectOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ReplicateObjectOperation.Builder#build()} is called immediately
         * and its result is passed to {@link #s3ReplicateObject(S3ReplicateObjectOperation)}.
         * 
         * @param s3ReplicateObject
         *        a consumer that will call methods on {@link S3ReplicateObjectOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ReplicateObject(S3ReplicateObjectOperation)
         */
        default Builder s3ReplicateObject(Consumer<S3ReplicateObjectOperation.Builder> s3ReplicateObject) {
            return s3ReplicateObject(S3ReplicateObjectOperation.builder().applyMutation(s3ReplicateObject).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaInvokeOperation lambdaInvoke;

        private S3CopyObjectOperation s3PutObjectCopy;

        private S3SetObjectAclOperation s3PutObjectAcl;

        private S3SetObjectTaggingOperation s3PutObjectTagging;

        private S3DeleteObjectTaggingOperation s3DeleteObjectTagging;

        private S3InitiateRestoreObjectOperation s3InitiateRestoreObject;

        private S3SetObjectLegalHoldOperation s3PutObjectLegalHold;

        private S3SetObjectRetentionOperation s3PutObjectRetention;

        private S3ReplicateObjectOperation s3ReplicateObject;

        private BuilderImpl() {
        }

        private BuilderImpl(JobOperation model) {
            lambdaInvoke(model.lambdaInvoke);
            s3PutObjectCopy(model.s3PutObjectCopy);
            s3PutObjectAcl(model.s3PutObjectAcl);
            s3PutObjectTagging(model.s3PutObjectTagging);
            s3DeleteObjectTagging(model.s3DeleteObjectTagging);
            s3InitiateRestoreObject(model.s3InitiateRestoreObject);
            s3PutObjectLegalHold(model.s3PutObjectLegalHold);
            s3PutObjectRetention(model.s3PutObjectRetention);
            s3ReplicateObject(model.s3ReplicateObject);
        }

        public final LambdaInvokeOperation.Builder getLambdaInvoke() {
            return lambdaInvoke != null ? lambdaInvoke.toBuilder() : null;
        }

        public final void setLambdaInvoke(LambdaInvokeOperation.BuilderImpl lambdaInvoke) {
            this.lambdaInvoke = lambdaInvoke != null ? lambdaInvoke.build() : null;
        }

        @Override
        public final Builder lambdaInvoke(LambdaInvokeOperation lambdaInvoke) {
            this.lambdaInvoke = lambdaInvoke;
            return this;
        }

        public final S3CopyObjectOperation.Builder getS3PutObjectCopy() {
            return s3PutObjectCopy != null ? s3PutObjectCopy.toBuilder() : null;
        }

        public final void setS3PutObjectCopy(S3CopyObjectOperation.BuilderImpl s3PutObjectCopy) {
            this.s3PutObjectCopy = s3PutObjectCopy != null ? s3PutObjectCopy.build() : null;
        }

        @Override
        public final Builder s3PutObjectCopy(S3CopyObjectOperation s3PutObjectCopy) {
            this.s3PutObjectCopy = s3PutObjectCopy;
            return this;
        }

        public final S3SetObjectAclOperation.Builder getS3PutObjectAcl() {
            return s3PutObjectAcl != null ? s3PutObjectAcl.toBuilder() : null;
        }

        public final void setS3PutObjectAcl(S3SetObjectAclOperation.BuilderImpl s3PutObjectAcl) {
            this.s3PutObjectAcl = s3PutObjectAcl != null ? s3PutObjectAcl.build() : null;
        }

        @Override
        public final Builder s3PutObjectAcl(S3SetObjectAclOperation s3PutObjectAcl) {
            this.s3PutObjectAcl = s3PutObjectAcl;
            return this;
        }

        public final S3SetObjectTaggingOperation.Builder getS3PutObjectTagging() {
            return s3PutObjectTagging != null ? s3PutObjectTagging.toBuilder() : null;
        }

        public final void setS3PutObjectTagging(S3SetObjectTaggingOperation.BuilderImpl s3PutObjectTagging) {
            this.s3PutObjectTagging = s3PutObjectTagging != null ? s3PutObjectTagging.build() : null;
        }

        @Override
        public final Builder s3PutObjectTagging(S3SetObjectTaggingOperation s3PutObjectTagging) {
            this.s3PutObjectTagging = s3PutObjectTagging;
            return this;
        }

        public final S3DeleteObjectTaggingOperation.Builder getS3DeleteObjectTagging() {
            return s3DeleteObjectTagging != null ? s3DeleteObjectTagging.toBuilder() : null;
        }

        public final void setS3DeleteObjectTagging(S3DeleteObjectTaggingOperation.BuilderImpl s3DeleteObjectTagging) {
            this.s3DeleteObjectTagging = s3DeleteObjectTagging != null ? s3DeleteObjectTagging.build() : null;
        }

        @Override
        public final Builder s3DeleteObjectTagging(S3DeleteObjectTaggingOperation s3DeleteObjectTagging) {
            this.s3DeleteObjectTagging = s3DeleteObjectTagging;
            return this;
        }

        public final S3InitiateRestoreObjectOperation.Builder getS3InitiateRestoreObject() {
            return s3InitiateRestoreObject != null ? s3InitiateRestoreObject.toBuilder() : null;
        }

        public final void setS3InitiateRestoreObject(S3InitiateRestoreObjectOperation.BuilderImpl s3InitiateRestoreObject) {
            this.s3InitiateRestoreObject = s3InitiateRestoreObject != null ? s3InitiateRestoreObject.build() : null;
        }

        @Override
        public final Builder s3InitiateRestoreObject(S3InitiateRestoreObjectOperation s3InitiateRestoreObject) {
            this.s3InitiateRestoreObject = s3InitiateRestoreObject;
            return this;
        }

        public final S3SetObjectLegalHoldOperation.Builder getS3PutObjectLegalHold() {
            return s3PutObjectLegalHold != null ? s3PutObjectLegalHold.toBuilder() : null;
        }

        public final void setS3PutObjectLegalHold(S3SetObjectLegalHoldOperation.BuilderImpl s3PutObjectLegalHold) {
            this.s3PutObjectLegalHold = s3PutObjectLegalHold != null ? s3PutObjectLegalHold.build() : null;
        }

        @Override
        public final Builder s3PutObjectLegalHold(S3SetObjectLegalHoldOperation s3PutObjectLegalHold) {
            this.s3PutObjectLegalHold = s3PutObjectLegalHold;
            return this;
        }

        public final S3SetObjectRetentionOperation.Builder getS3PutObjectRetention() {
            return s3PutObjectRetention != null ? s3PutObjectRetention.toBuilder() : null;
        }

        public final void setS3PutObjectRetention(S3SetObjectRetentionOperation.BuilderImpl s3PutObjectRetention) {
            this.s3PutObjectRetention = s3PutObjectRetention != null ? s3PutObjectRetention.build() : null;
        }

        @Override
        public final Builder s3PutObjectRetention(S3SetObjectRetentionOperation s3PutObjectRetention) {
            this.s3PutObjectRetention = s3PutObjectRetention;
            return this;
        }

        public final S3ReplicateObjectOperation.Builder getS3ReplicateObject() {
            return s3ReplicateObject != null ? s3ReplicateObject.toBuilder() : null;
        }

        public final void setS3ReplicateObject(S3ReplicateObjectOperation.BuilderImpl s3ReplicateObject) {
            this.s3ReplicateObject = s3ReplicateObject != null ? s3ReplicateObject.build() : null;
        }

        @Override
        public final Builder s3ReplicateObject(S3ReplicateObjectOperation s3ReplicateObject) {
            this.s3ReplicateObject = s3ReplicateObject;
            return this;
        }

        @Override
        public JobOperation build() {
            return new JobOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
