/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.ActivityMetrics;
import software.amazon.awssdk.services.s3control.model.PrefixLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketLevel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketLevel> {
    private static final SdkField<ActivityMetrics> ACTIVITY_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActivityMetrics").getter(BucketLevel.getter(BucketLevel::activityMetrics)).setter(BucketLevel.setter(Builder::activityMetrics)).constructor(ActivityMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityMetrics").unmarshallLocationName("ActivityMetrics").build()}).build();
    private static final SdkField<PrefixLevel> PREFIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrefixLevel").getter(BucketLevel.getter(BucketLevel::prefixLevel)).setter(BucketLevel.setter(Builder::prefixLevel)).constructor(PrefixLevel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixLevel").unmarshallLocationName("PrefixLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_METRICS_FIELD, PREFIX_LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final ActivityMetrics activityMetrics;
    private final PrefixLevel prefixLevel;

    private BucketLevel(BuilderImpl builder) {
        this.activityMetrics = builder.activityMetrics;
        this.prefixLevel = builder.prefixLevel;
    }

    public final ActivityMetrics activityMetrics() {
        return this.activityMetrics;
    }

    public final PrefixLevel prefixLevel() {
        return this.prefixLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixLevel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketLevel)) {
            return false;
        }
        BucketLevel other = (BucketLevel)obj;
        return Objects.equals(this.activityMetrics(), other.activityMetrics()) && Objects.equals(this.prefixLevel(), other.prefixLevel());
    }

    public final String toString() {
        return ToString.builder((String)"BucketLevel").add("ActivityMetrics", (Object)this.activityMetrics()).add("PrefixLevel", (Object)this.prefixLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityMetrics": {
                return Optional.ofNullable(clazz.cast(this.activityMetrics()));
            }
            case "PrefixLevel": {
                return Optional.ofNullable(clazz.cast(this.prefixLevel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketLevel, T> g) {
        return obj -> g.apply((BucketLevel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActivityMetrics activityMetrics;
        private PrefixLevel prefixLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketLevel model) {
            this.activityMetrics(model.activityMetrics);
            this.prefixLevel(model.prefixLevel);
        }

        public final ActivityMetrics.Builder getActivityMetrics() {
            return this.activityMetrics != null ? this.activityMetrics.toBuilder() : null;
        }

        public final void setActivityMetrics(ActivityMetrics.BuilderImpl activityMetrics) {
            this.activityMetrics = activityMetrics != null ? activityMetrics.build() : null;
        }

        @Override
        public final Builder activityMetrics(ActivityMetrics activityMetrics) {
            this.activityMetrics = activityMetrics;
            return this;
        }

        public final PrefixLevel.Builder getPrefixLevel() {
            return this.prefixLevel != null ? this.prefixLevel.toBuilder() : null;
        }

        public final void setPrefixLevel(PrefixLevel.BuilderImpl prefixLevel) {
            this.prefixLevel = prefixLevel != null ? prefixLevel.build() : null;
        }

        @Override
        public final Builder prefixLevel(PrefixLevel prefixLevel) {
            this.prefixLevel = prefixLevel;
            return this;
        }

        public BucketLevel build() {
            return new BucketLevel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketLevel> {
        public Builder activityMetrics(ActivityMetrics var1);

        default public Builder activityMetrics(Consumer<ActivityMetrics.Builder> activityMetrics) {
            return this.activityMetrics((ActivityMetrics)((ActivityMetrics.Builder)ActivityMetrics.builder().applyMutation(activityMetrics)).build());
        }

        public Builder prefixLevel(PrefixLevel var1);

        default public Builder prefixLevel(Consumer<PrefixLevel.Builder> prefixLevel) {
            return this.prefixLevel((PrefixLevel)((PrefixLevel.Builder)PrefixLevel.builder().applyMutation(prefixLevel)).build());
        }
    }
}

