/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint;

public class ListAccessPointsForObjectLambdaPublisher
implements SdkPublisher<ListAccessPointsForObjectLambdaResponse> {
    private final S3ControlAsyncClient client;
    private final ListAccessPointsForObjectLambdaRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessPointsForObjectLambdaPublisher(S3ControlAsyncClient client, ListAccessPointsForObjectLambdaRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessPointsForObjectLambdaPublisher(S3ControlAsyncClient client, ListAccessPointsForObjectLambdaRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessPointsForObjectLambdaResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessPointsForObjectLambdaResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ObjectLambdaAccessPoint> objectLambdaAccessPointList() {
        Function<ListAccessPointsForObjectLambdaResponse, Iterator> getIterator = response -> {
            if (response != null && response.objectLambdaAccessPointList() != null) {
                return response.objectLambdaAccessPointList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessPointsForObjectLambdaResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessPointsForObjectLambdaResponseFetcher
    implements AsyncPageFetcher<ListAccessPointsForObjectLambdaResponse> {
        private ListAccessPointsForObjectLambdaResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPointsForObjectLambdaResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessPointsForObjectLambdaResponse> nextPage(ListAccessPointsForObjectLambdaResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPointsForObjectLambdaPublisher.this.client.listAccessPointsForObjectLambda(ListAccessPointsForObjectLambdaPublisher.this.firstRequest);
            }
            return ListAccessPointsForObjectLambdaPublisher.this.client.listAccessPointsForObjectLambda((ListAccessPointsForObjectLambdaRequest)((Object)ListAccessPointsForObjectLambdaPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

