/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.ReplicationStatus;
import software.amazon.awssdk.services.s3control.model.ReplicationStatusFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobManifestGeneratorFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobManifestGeneratorFilter> {
    private static final SdkField<Boolean> ELIGIBLE_FOR_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EligibleForReplication").getter(JobManifestGeneratorFilter.getter(JobManifestGeneratorFilter::eligibleForReplication)).setter(JobManifestGeneratorFilter.setter(Builder::eligibleForReplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EligibleForReplication").unmarshallLocationName("EligibleForReplication").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAfter").getter(JobManifestGeneratorFilter.getter(JobManifestGeneratorFilter::createdAfter)).setter(JobManifestGeneratorFilter.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").unmarshallLocationName("CreatedAfter").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedBefore").getter(JobManifestGeneratorFilter.getter(JobManifestGeneratorFilter::createdBefore)).setter(JobManifestGeneratorFilter.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").unmarshallLocationName("CreatedBefore").build()}).build();
    private static final SdkField<List<String>> OBJECT_REPLICATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ObjectReplicationStatuses").getter(JobManifestGeneratorFilter.getter(JobManifestGeneratorFilter::objectReplicationStatusesAsStrings)).setter(JobManifestGeneratorFilter.setter(Builder::objectReplicationStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReplicationStatuses").unmarshallLocationName("ObjectReplicationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELIGIBLE_FOR_REPLICATION_FIELD, CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, OBJECT_REPLICATION_STATUSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean eligibleForReplication;
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final List<String> objectReplicationStatuses;

    private JobManifestGeneratorFilter(BuilderImpl builder) {
        this.eligibleForReplication = builder.eligibleForReplication;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.objectReplicationStatuses = builder.objectReplicationStatuses;
    }

    public final Boolean eligibleForReplication() {
        return this.eligibleForReplication;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final List<ReplicationStatus> objectReplicationStatuses() {
        return ReplicationStatusFilterListCopier.copyStringToEnum(this.objectReplicationStatuses);
    }

    public final boolean hasObjectReplicationStatuses() {
        return this.objectReplicationStatuses != null && !(this.objectReplicationStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> objectReplicationStatusesAsStrings() {
        return this.objectReplicationStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eligibleForReplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectReplicationStatuses() ? this.objectReplicationStatusesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobManifestGeneratorFilter)) {
            return false;
        }
        JobManifestGeneratorFilter other = (JobManifestGeneratorFilter)obj;
        return Objects.equals(this.eligibleForReplication(), other.eligibleForReplication()) && Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && this.hasObjectReplicationStatuses() == other.hasObjectReplicationStatuses() && Objects.equals(this.objectReplicationStatusesAsStrings(), other.objectReplicationStatusesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"JobManifestGeneratorFilter").add("EligibleForReplication", (Object)this.eligibleForReplication()).add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("ObjectReplicationStatuses", this.hasObjectReplicationStatuses() ? this.objectReplicationStatusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EligibleForReplication": {
                return Optional.ofNullable(clazz.cast(this.eligibleForReplication()));
            }
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "ObjectReplicationStatuses": {
                return Optional.ofNullable(clazz.cast(this.objectReplicationStatusesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobManifestGeneratorFilter, T> g) {
        return obj -> g.apply((JobManifestGeneratorFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean eligibleForReplication;
        private Instant createdAfter;
        private Instant createdBefore;
        private List<String> objectReplicationStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobManifestGeneratorFilter model) {
            this.eligibleForReplication(model.eligibleForReplication);
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.objectReplicationStatusesWithStrings(model.objectReplicationStatuses);
        }

        public final Boolean getEligibleForReplication() {
            return this.eligibleForReplication;
        }

        public final void setEligibleForReplication(Boolean eligibleForReplication) {
            this.eligibleForReplication = eligibleForReplication;
        }

        @Override
        @Transient
        public final Builder eligibleForReplication(Boolean eligibleForReplication) {
            this.eligibleForReplication = eligibleForReplication;
            return this;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        @Transient
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        @Transient
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Collection<String> getObjectReplicationStatuses() {
            if (this.objectReplicationStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.objectReplicationStatuses;
        }

        public final void setObjectReplicationStatuses(Collection<String> objectReplicationStatuses) {
            this.objectReplicationStatuses = ReplicationStatusFilterListCopier.copy(objectReplicationStatuses);
        }

        @Override
        @Transient
        public final Builder objectReplicationStatusesWithStrings(Collection<String> objectReplicationStatuses) {
            this.objectReplicationStatuses = ReplicationStatusFilterListCopier.copy(objectReplicationStatuses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder objectReplicationStatusesWithStrings(String ... objectReplicationStatuses) {
            this.objectReplicationStatusesWithStrings(Arrays.asList(objectReplicationStatuses));
            return this;
        }

        @Override
        @Transient
        public final Builder objectReplicationStatuses(Collection<ReplicationStatus> objectReplicationStatuses) {
            this.objectReplicationStatuses = ReplicationStatusFilterListCopier.copyEnumToString(objectReplicationStatuses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder objectReplicationStatuses(ReplicationStatus ... objectReplicationStatuses) {
            this.objectReplicationStatuses(Arrays.asList(objectReplicationStatuses));
            return this;
        }

        public JobManifestGeneratorFilter build() {
            return new JobManifestGeneratorFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobManifestGeneratorFilter> {
        public Builder eligibleForReplication(Boolean var1);

        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder objectReplicationStatusesWithStrings(Collection<String> var1);

        public Builder objectReplicationStatusesWithStrings(String ... var1);

        public Builder objectReplicationStatuses(Collection<ReplicationStatus> var1);

        public Builder objectReplicationStatuses(ReplicationStatus ... var1);
    }
}

